/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.mceliece;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.digests.SHA1Digest;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.crypto.prng.DigestRandomGenerator;
import com.enterprisedt.bouncycastle.pqc.crypto.MessageEncryptor;
import com.enterprisedt.bouncycastle.pqc.crypto.mceliece.McElieceCCA2KeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.mceliece.McElieceCCA2PublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.mceliece.a;
import com.enterprisedt.bouncycastle.pqc.crypto.mceliece.b;
import com.enterprisedt.bouncycastle.pqc.crypto.mceliece.c;
import com.enterprisedt.bouncycastle.pqc.math.linearalgebra.ByteUtils;
import com.enterprisedt.bouncycastle.pqc.math.linearalgebra.GF2Vector;
import com.enterprisedt.bouncycastle.pqc.math.linearalgebra.IntegerFunctions;
import java.security.SecureRandom;

public class McElieceKobaraImaiCipher
implements MessageEncryptor {
    public static final String OID = "1.3.6.1.4.1.8301.3.1.3.4.2.3";
    public static final byte[] PUBLIC_CONSTANT = "a predetermined public constant".getBytes();
    private Digest b;
    private SecureRandom c;
    McElieceCCA2KeyParameters a;
    private int d;
    private int e;
    private int f;
    private boolean g;

    @Override
    public void init(boolean forEncryption, CipherParameters param) {
        this.g = forEncryption;
        if (forEncryption) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)param;
                this.c = parametersWithRandom.getRandom();
                this.a = (McElieceCCA2PublicKeyParameters)parametersWithRandom.getParameters();
                this.a((McElieceCCA2PublicKeyParameters)this.a);
            } else {
                this.c = CryptoServicesRegistrar.getSecureRandom();
                this.a = (McElieceCCA2PublicKeyParameters)param;
                this.a((McElieceCCA2PublicKeyParameters)this.a);
            }
        } else {
            this.a = (McElieceCCA2PrivateKeyParameters)param;
            this.a((McElieceCCA2PrivateKeyParameters)this.a);
        }
    }

    public int getKeySize(McElieceCCA2KeyParameters key) {
        if (key instanceof McElieceCCA2PublicKeyParameters) {
            return ((McElieceCCA2PublicKeyParameters)key).getN();
        }
        if (key instanceof McElieceCCA2PrivateKeyParameters) {
            return ((McElieceCCA2PrivateKeyParameters)key).getN();
        }
        throw new IllegalArgumentException("unsupported type");
    }

    private void a(McElieceCCA2PublicKeyParameters mcElieceCCA2PublicKeyParameters) {
        this.b = com.enterprisedt.bouncycastle.pqc.crypto.mceliece.c.a(mcElieceCCA2PublicKeyParameters.getDigest());
        this.d = mcElieceCCA2PublicKeyParameters.getN();
        this.e = mcElieceCCA2PublicKeyParameters.getK();
        this.f = mcElieceCCA2PublicKeyParameters.getT();
    }

    private void a(McElieceCCA2PrivateKeyParameters mcElieceCCA2PrivateKeyParameters) {
        this.b = com.enterprisedt.bouncycastle.pqc.crypto.mceliece.c.a(mcElieceCCA2PrivateKeyParameters.getDigest());
        this.d = mcElieceCCA2PrivateKeyParameters.getN();
        this.e = mcElieceCCA2PrivateKeyParameters.getK();
        this.f = mcElieceCCA2PrivateKeyParameters.getT();
    }

    @Override
    public byte[] messageEncrypt(byte[] input) {
        if (!this.g) {
            throw new IllegalStateException("cipher initialised for decryption");
        }
        int n2 = this.b.getDigestSize();
        int n3 = this.e >> 3;
        int n4 = IntegerFunctions.binomial(this.d, this.f).bitLength() - 1 >> 3;
        int n5 = n3 + n4 - n2 - PUBLIC_CONSTANT.length;
        if (input.length > n5) {
            n5 = input.length;
        }
        int n6 = n5 + PUBLIC_CONSTANT.length;
        int n7 = n6 + n2 - n3 - n4;
        byte[] byArray = new byte[n6];
        System.arraycopy(input, 0, byArray, 0, input.length);
        System.arraycopy(PUBLIC_CONSTANT, 0, byArray, n5, PUBLIC_CONSTANT.length);
        byte[] byArray2 = new byte[n2];
        this.c.nextBytes(byArray2);
        DigestRandomGenerator digestRandomGenerator = new DigestRandomGenerator(new SHA1Digest());
        digestRandomGenerator.addSeedMaterial(byArray2);
        byte[] byArray3 = new byte[n6];
        digestRandomGenerator.nextBytes(byArray3);
        for (int i2 = n6 - 1; i2 >= 0; --i2) {
            int n8 = i2;
            byArray3[n8] = (byte)(byArray3[n8] ^ byArray[i2]);
        }
        byte[] byArray4 = new byte[this.b.getDigestSize()];
        this.b.update(byArray3, 0, byArray3.length);
        this.b.doFinal(byArray4, 0);
        for (int i3 = n2 - 1; i3 >= 0; --i3) {
            int n9 = i3;
            byArray4[n9] = (byte)(byArray4[n9] ^ byArray2[i3]);
        }
        byte[] byArray5 = ByteUtils.concatenate(byArray4, byArray3);
        byte[] byArray6 = new byte[]{};
        if (n7 > 0) {
            byArray6 = new byte[n7];
            System.arraycopy(byArray5, 0, byArray6, 0, n7);
        }
        byte[] byArray7 = new byte[n4];
        System.arraycopy(byArray5, n7, byArray7, 0, n4);
        byte[] byArray8 = new byte[n3];
        System.arraycopy(byArray5, n7 + n4, byArray8, 0, n3);
        GF2Vector gF2Vector = GF2Vector.OS2VP(this.e, byArray8);
        GF2Vector gF2Vector2 = com.enterprisedt.bouncycastle.pqc.crypto.mceliece.a.a(this.d, this.f, byArray7);
        byte[] byArray9 = com.enterprisedt.bouncycastle.pqc.crypto.mceliece.b.a((McElieceCCA2PublicKeyParameters)this.a, gF2Vector, gF2Vector2).getEncoded();
        if (n7 > 0) {
            return ByteUtils.concatenate(byArray6, byArray9);
        }
        return byArray9;
    }

    @Override
    public byte[] messageDecrypt(byte[] input) throws InvalidCipherTextException {
        byte[] byArray;
        byte[] byArray2;
        Object object;
        if (this.g) {
            throw new IllegalStateException("cipher initialised for decryption");
        }
        int n2 = this.d >> 3;
        if (input.length < n2) {
            throw new InvalidCipherTextException("Bad Padding: Ciphertext too short.");
        }
        int n3 = this.b.getDigestSize();
        int n4 = this.e >> 3;
        int n5 = input.length - n2;
        if (n5 > 0) {
            object = ByteUtils.split(input, n5);
            byArray2 = object[0];
            byArray = object[1];
        } else {
            byArray2 = new byte[]{};
            byArray = input;
        }
        object = GF2Vector.OS2VP(this.d, byArray);
        GF2Vector[] gF2VectorArray = com.enterprisedt.bouncycastle.pqc.crypto.mceliece.b.a((McElieceCCA2PrivateKeyParameters)this.a, (GF2Vector)object);
        byte[] byArray3 = gF2VectorArray[0].getEncoded();
        GF2Vector gF2Vector = gF2VectorArray[1];
        if (byArray3.length > n4) {
            byArray3 = ByteUtils.subArray(byArray3, 0, n4);
        }
        byte[] byArray4 = com.enterprisedt.bouncycastle.pqc.crypto.mceliece.a.a(this.d, this.f, gF2Vector);
        byte[] byArray5 = ByteUtils.concatenate(byArray2, byArray4);
        byArray5 = ByteUtils.concatenate(byArray5, byArray3);
        int n6 = byArray5.length - n3;
        byte[][] byArray6 = ByteUtils.split(byArray5, n3);
        byte[] byArray7 = byArray6[0];
        byte[] byArray8 = byArray6[1];
        byte[] byArray9 = new byte[this.b.getDigestSize()];
        this.b.update(byArray8, 0, byArray8.length);
        this.b.doFinal(byArray9, 0);
        for (int i2 = n3 - 1; i2 >= 0; --i2) {
            int n7 = i2;
            byArray9[n7] = (byte)(byArray9[n7] ^ byArray7[i2]);
        }
        DigestRandomGenerator digestRandomGenerator = new DigestRandomGenerator(new SHA1Digest());
        digestRandomGenerator.addSeedMaterial(byArray9);
        byte[] byArray10 = new byte[n6];
        digestRandomGenerator.nextBytes(byArray10);
        for (int i3 = n6 - 1; i3 >= 0; --i3) {
            int n8 = i3;
            byArray10[n8] = (byte)(byArray10[n8] ^ byArray8[i3]);
        }
        if (byArray10.length < n6) {
            throw new InvalidCipherTextException("Bad Padding: invalid ciphertext");
        }
        byte[][] byArray11 = ByteUtils.split(byArray10, n6 - PUBLIC_CONSTANT.length);
        byte[] byArray12 = byArray11[0];
        byte[] byArray13 = byArray11[1];
        if (!ByteUtils.equals(byArray13, PUBLIC_CONSTANT)) {
            throw new InvalidCipherTextException("Bad Padding: invalid ciphertext");
        }
        return byArray12;
    }
}

