/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.ntru;

import com.enterprisedt.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.enterprisedt.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import com.enterprisedt.bouncycastle.crypto.KeyGenerationParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.ntru.NTRUEncryptionKeyGenerationParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.ntru.NTRUEncryptionPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.ntru.NTRUEncryptionPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.math.ntru.polynomial.DenseTernaryPolynomial;
import com.enterprisedt.bouncycastle.pqc.math.ntru.polynomial.IntegerPolynomial;
import com.enterprisedt.bouncycastle.pqc.math.ntru.polynomial.Polynomial;
import com.enterprisedt.bouncycastle.pqc.math.ntru.polynomial.ProductFormPolynomial;
import com.enterprisedt.bouncycastle.pqc.math.ntru.util.Util;

public class NTRUEncryptionKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private NTRUEncryptionKeyGenerationParameters a;

    @Override
    public void init(KeyGenerationParameters param) {
        this.a = (NTRUEncryptionKeyGenerationParameters)param;
    }

    @Override
    public AsymmetricCipherKeyPair generateKeyPair() {
        IntegerPolynomial integerPolynomial;
        IntegerPolynomial integerPolynomial2;
        Polynomial polynomial;
        int n2 = this.a.N;
        int n3 = this.a.q;
        int n4 = this.a.df;
        int n5 = this.a.df1;
        int n6 = this.a.df2;
        int n7 = this.a.df3;
        int n8 = this.a.dg;
        boolean bl = this.a.fastFp;
        boolean bl2 = this.a.sparse;
        IntegerPolynomial integerPolynomial3 = null;
        while (true) {
            if (bl) {
                polynomial = this.a.polyType == 0 ? Util.generateRandomTernary(n2, n4, n4, bl2, this.a.getRandom()) : ProductFormPolynomial.generateRandom(n2, n5, n6, n7, n7, this.a.getRandom());
                integerPolynomial2 = polynomial.toIntegerPolynomial();
                integerPolynomial2.mult(3);
                integerPolynomial2.coeffs[0] = integerPolynomial2.coeffs[0] + 1;
            } else {
                polynomial = this.a.polyType == 0 ? Util.generateRandomTernary(n2, n4, n4 - 1, bl2, this.a.getRandom()) : ProductFormPolynomial.generateRandom(n2, n5, n6, n7, n7 - 1, this.a.getRandom());
                integerPolynomial2 = polynomial.toIntegerPolynomial();
                integerPolynomial3 = integerPolynomial2.invertF3();
                if (integerPolynomial3 == null) continue;
            }
            if ((integerPolynomial = integerPolynomial2.invertFq(n3)) != null) break;
        }
        if (bl) {
            integerPolynomial3 = new IntegerPolynomial(n2);
            integerPolynomial3.coeffs[0] = 1;
        }
        while ((integerPolynomial2 = DenseTernaryPolynomial.generateRandom(n2, n8, n8 - 1, this.a.getRandom())).invertFq(n3) == null) {
        }
        IntegerPolynomial integerPolynomial4 = ((DenseTernaryPolynomial)integerPolynomial2).mult(integerPolynomial, n3);
        integerPolynomial4.mult3(n3);
        integerPolynomial4.ensurePositive(n3);
        integerPolynomial2.clear();
        integerPolynomial.clear();
        NTRUEncryptionPrivateKeyParameters nTRUEncryptionPrivateKeyParameters = new NTRUEncryptionPrivateKeyParameters(integerPolynomial4, polynomial, integerPolynomial3, this.a.getEncryptionParameters());
        NTRUEncryptionPublicKeyParameters nTRUEncryptionPublicKeyParameters = new NTRUEncryptionPublicKeyParameters(integerPolynomial4, this.a.getEncryptionParameters());
        return new AsymmetricCipherKeyPair(nTRUEncryptionPublicKeyParameters, nTRUEncryptionPrivateKeyParameters);
    }
}

