/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.ntru;

import com.enterprisedt.bouncycastle.pqc.crypto.ntru.NTRUEncryptionKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.ntru.NTRUEncryptionParameters;
import com.enterprisedt.bouncycastle.pqc.math.ntru.polynomial.DenseTernaryPolynomial;
import com.enterprisedt.bouncycastle.pqc.math.ntru.polynomial.IntegerPolynomial;
import com.enterprisedt.bouncycastle.pqc.math.ntru.polynomial.Polynomial;
import com.enterprisedt.bouncycastle.pqc.math.ntru.polynomial.ProductFormPolynomial;
import com.enterprisedt.bouncycastle.pqc.math.ntru.polynomial.SparseTernaryPolynomial;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class NTRUEncryptionPrivateKeyParameters
extends NTRUEncryptionKeyParameters {
    public Polynomial t;
    public IntegerPolynomial fp;
    public IntegerPolynomial h;

    public NTRUEncryptionPrivateKeyParameters(IntegerPolynomial h2, Polynomial t2, IntegerPolynomial fp, NTRUEncryptionParameters params) {
        super(true, params);
        this.h = h2;
        this.t = t2;
        this.fp = fp;
    }

    public NTRUEncryptionPrivateKeyParameters(byte[] b2, NTRUEncryptionParameters params) throws IOException {
        this(new ByteArrayInputStream(b2), params);
    }

    public NTRUEncryptionPrivateKeyParameters(InputStream is, NTRUEncryptionParameters params) throws IOException {
        super(true, params);
        if (params.polyType == 1) {
            int n2 = params.N;
            int n3 = params.df1;
            int n4 = params.df2;
            int n5 = params.df3;
            int n6 = params.fastFp ? params.df3 : params.df3 - 1;
            this.h = IntegerPolynomial.fromBinary(is, params.N, params.q);
            this.t = ProductFormPolynomial.fromBinary(is, n2, n3, n4, n5, n6);
        } else {
            this.h = IntegerPolynomial.fromBinary(is, params.N, params.q);
            IntegerPolynomial integerPolynomial = IntegerPolynomial.fromBinary3Tight(is, params.N);
            this.t = params.sparse ? new SparseTernaryPolynomial(integerPolynomial) : new DenseTernaryPolynomial(integerPolynomial);
        }
        this.a();
    }

    private void a() {
        if (this.params.fastFp) {
            this.fp = new IntegerPolynomial(this.params.N);
            this.fp.coeffs[0] = 1;
        } else {
            this.fp = this.t.toIntegerPolynomial().invertF3();
        }
    }

    public byte[] getEncoded() {
        byte[] byArray = this.h.toBinary(this.params.q);
        byte[] byArray2 = this.t instanceof ProductFormPolynomial ? ((ProductFormPolynomial)this.t).toBinary() : this.t.toIntegerPolynomial().toBinary3Tight();
        byte[] byArray3 = new byte[byArray.length + byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    public void writeTo(OutputStream os) throws IOException {
        os.write(this.getEncoded());
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + (this.params == null ? 0 : this.params.hashCode());
        n3 = 31 * n3 + (this.t == null ? 0 : this.t.hashCode());
        n3 = 31 * n3 + (this.h == null ? 0 : this.h.hashCode());
        return n3;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NTRUEncryptionPrivateKeyParameters)) {
            return false;
        }
        NTRUEncryptionPrivateKeyParameters nTRUEncryptionPrivateKeyParameters = (NTRUEncryptionPrivateKeyParameters)obj;
        if (this.params == null ? nTRUEncryptionPrivateKeyParameters.params != null : !this.params.equals(nTRUEncryptionPrivateKeyParameters.params)) {
            return false;
        }
        if (this.t == null ? nTRUEncryptionPrivateKeyParameters.t != null : !this.t.equals(nTRUEncryptionPrivateKeyParameters.t)) {
            return false;
        }
        return this.h.equals(nTRUEncryptionPrivateKeyParameters.h);
    }
}

