/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.ntru;

import com.enterprisedt.bouncycastle.crypto.AsymmetricBlockCipher;
import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.DataLengthException;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.pqc.crypto.ntru.IndexGenerator;
import com.enterprisedt.bouncycastle.pqc.crypto.ntru.NTRUEncryptionParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.ntru.NTRUEncryptionPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.ntru.NTRUEncryptionPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.math.ntru.polynomial.DenseTernaryPolynomial;
import com.enterprisedt.bouncycastle.pqc.math.ntru.polynomial.IntegerPolynomial;
import com.enterprisedt.bouncycastle.pqc.math.ntru.polynomial.Polynomial;
import com.enterprisedt.bouncycastle.pqc.math.ntru.polynomial.ProductFormPolynomial;
import com.enterprisedt.bouncycastle.pqc.math.ntru.polynomial.SparseTernaryPolynomial;
import com.enterprisedt.bouncycastle.pqc.math.ntru.polynomial.TernaryPolynomial;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.security.SecureRandom;

public class NTRUEngine
implements AsymmetricBlockCipher {
    private boolean a;
    private NTRUEncryptionParameters b;
    private NTRUEncryptionPublicKeyParameters c;
    private NTRUEncryptionPrivateKeyParameters d;
    private SecureRandom e;

    @Override
    public void init(boolean forEncryption, CipherParameters parameters) {
        this.a = forEncryption;
        if (forEncryption) {
            if (parameters instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)parameters;
                this.e = parametersWithRandom.getRandom();
                this.c = (NTRUEncryptionPublicKeyParameters)parametersWithRandom.getParameters();
            } else {
                this.e = CryptoServicesRegistrar.getSecureRandom();
                this.c = (NTRUEncryptionPublicKeyParameters)parameters;
            }
            this.b = this.c.getParameters();
        } else {
            this.d = (NTRUEncryptionPrivateKeyParameters)parameters;
            this.b = this.d.getParameters();
        }
    }

    @Override
    public int getInputBlockSize() {
        return this.b.maxMsgLenBytes;
    }

    @Override
    public int getOutputBlockSize() {
        return (this.b.N * this.a(this.b.q) + 7) / 8;
    }

    @Override
    public byte[] processBlock(byte[] in, int inOff, int len) throws InvalidCipherTextException {
        byte[] byArray = new byte[len];
        System.arraycopy(in, inOff, byArray, 0, len);
        if (this.a) {
            return this.a(byArray, this.c);
        }
        return this.a(byArray, this.d);
    }

    private byte[] a(byte[] byArray, NTRUEncryptionPublicKeyParameters nTRUEncryptionPublicKeyParameters) {
        IntegerPolynomial integerPolynomial;
        IntegerPolynomial integerPolynomial2;
        IntegerPolynomial integerPolynomial3 = nTRUEncryptionPublicKeyParameters.h;
        int n2 = this.b.N;
        int n3 = this.b.q;
        int n4 = this.b.maxMsgLenBytes;
        int n5 = this.b.db;
        int n6 = this.b.bufferLenBits;
        int n7 = this.b.dm0;
        int n8 = this.b.pkLen;
        int n9 = this.b.minCallsMask;
        boolean bl = this.b.hashSeed;
        byte[] byArray2 = this.b.oid;
        int n10 = byArray.length;
        if (n4 > 255) {
            throw new IllegalArgumentException("llen values bigger than 1 are not supported");
        }
        if (n10 > n4) {
            throw new DataLengthException("Message too long: " + n10 + ">" + n4);
        }
        do {
            byte[] byArray3 = new byte[n5 / 8];
            this.e.nextBytes(byArray3);
            byte[] byArray4 = new byte[n4 + 1 - n10];
            byte[] byArray5 = new byte[n6 / 8];
            System.arraycopy(byArray3, 0, byArray5, 0, byArray3.length);
            byArray5[byArray3.length] = (byte)n10;
            System.arraycopy(byArray, 0, byArray5, byArray3.length + 1, byArray.length);
            System.arraycopy(byArray4, 0, byArray5, byArray3.length + 1 + byArray.length, byArray4.length);
            integerPolynomial2 = IntegerPolynomial.fromBinary3Sves(byArray5, n2);
            byte[] byArray6 = integerPolynomial3.toBinary(n3);
            byte[] byArray7 = this.a(byArray6, n8 / 8);
            byte[] byArray8 = this.a(byArray2, byArray, n10, byArray3, byArray7);
            Polynomial polynomial = this.a(byArray8, byArray5);
            integerPolynomial = polynomial.mult(integerPolynomial3, n3);
            IntegerPolynomial integerPolynomial4 = (IntegerPolynomial)integerPolynomial.clone();
            integerPolynomial4.modPositive(4);
            byte[] byArray9 = integerPolynomial4.toBinary(4);
            IntegerPolynomial integerPolynomial5 = this.a(byArray9, n2, n9, bl);
            integerPolynomial2.add(integerPolynomial5);
            integerPolynomial2.mod3();
        } while (integerPolynomial2.count(-1) < n7 || integerPolynomial2.count(0) < n7 || integerPolynomial2.count(1) < n7);
        integerPolynomial.add(integerPolynomial2, n3);
        integerPolynomial.ensurePositive(n3);
        return integerPolynomial.toBinary(n3);
    }

    private byte[] a(byte[] byArray, byte[] byArray2, int n2, byte[] byArray3, byte[] byArray4) {
        byte[] byArray5 = new byte[byArray.length + n2 + byArray3.length + byArray4.length];
        System.arraycopy(byArray, 0, byArray5, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray5, byArray.length, byArray2.length);
        System.arraycopy(byArray3, 0, byArray5, byArray.length + byArray2.length, byArray3.length);
        System.arraycopy(byArray4, 0, byArray5, byArray.length + byArray2.length + byArray3.length, byArray4.length);
        return byArray5;
    }

    protected IntegerPolynomial encrypt(IntegerPolynomial m2, TernaryPolynomial r2, IntegerPolynomial pubKey) {
        IntegerPolynomial integerPolynomial = r2.mult(pubKey, this.b.q);
        integerPolynomial.add(m2, this.b.q);
        integerPolynomial.ensurePositive(this.b.q);
        return integerPolynomial;
    }

    private Polynomial a(byte[] byArray, byte[] byArray2) {
        IndexGenerator indexGenerator = new IndexGenerator(byArray, this.b);
        if (this.b.polyType == 1) {
            SparseTernaryPolynomial sparseTernaryPolynomial = new SparseTernaryPolynomial(this.a(indexGenerator, this.b.dr1));
            SparseTernaryPolynomial sparseTernaryPolynomial2 = new SparseTernaryPolynomial(this.a(indexGenerator, this.b.dr2));
            SparseTernaryPolynomial sparseTernaryPolynomial3 = new SparseTernaryPolynomial(this.a(indexGenerator, this.b.dr3));
            return new ProductFormPolynomial(sparseTernaryPolynomial, sparseTernaryPolynomial2, sparseTernaryPolynomial3);
        }
        int n2 = this.b.dr;
        boolean bl = this.b.sparse;
        int[] nArray = this.a(indexGenerator, n2);
        if (bl) {
            return new SparseTernaryPolynomial(nArray);
        }
        return new DenseTernaryPolynomial(nArray);
    }

    private int[] a(IndexGenerator indexGenerator, int n2) {
        int n3 = this.b.N;
        int[] nArray = new int[n3];
        for (int i2 = -1; i2 <= 1; i2 += 2) {
            int n4 = 0;
            while (n4 < n2) {
                int n5 = indexGenerator.a();
                if (nArray[n5] != 0) continue;
                nArray[n5] = i2;
                ++n4;
            }
        }
        return nArray;
    }

    private IntegerPolynomial a(byte[] byArray, int n2, int n3, boolean bl) {
        Object object;
        int n4;
        Digest digest = this.b.hashAlg;
        int n5 = digest.getDigestSize();
        byte[] byArray2 = new byte[n3 * n5];
        byte[] byArray3 = bl ? this.a(digest, byArray) : byArray;
        for (n4 = 0; n4 < n3; ++n4) {
            digest.update(byArray3, 0, byArray3.length);
            this.a(digest, n4);
            object = this.a(digest);
            System.arraycopy(object, 0, byArray2, n4 * n5, n5);
        }
        object = new IntegerPolynomial(n2);
        while (true) {
            int n6 = 0;
            for (int i2 = 0; i2 != byArray2.length; ++i2) {
                int n7 = byArray2[i2] & 0xFF;
                if (n7 >= 243) continue;
                for (int i3 = 0; i3 < 4; ++i3) {
                    int n8 = n7 % 3;
                    ((IntegerPolynomial)object).coeffs[n6] = n8 - 1;
                    if (++n6 == n2) {
                        return object;
                    }
                    n7 = (n7 - n8) / 3;
                }
                ((IntegerPolynomial)object).coeffs[n6] = n7 - 1;
                if (++n6 != n2) continue;
                return object;
            }
            if (n6 >= n2) {
                return object;
            }
            digest.update(byArray3, 0, byArray3.length);
            this.a(digest, n4);
            byte[] byArray4 = this.a(digest);
            byArray2 = byArray4;
            ++n4;
        }
    }

    private void a(Digest digest, int n2) {
        digest.update((byte)(n2 >> 24));
        digest.update((byte)(n2 >> 16));
        digest.update((byte)(n2 >> 8));
        digest.update((byte)n2);
    }

    private byte[] a(Digest digest) {
        byte[] byArray = new byte[digest.getDigestSize()];
        digest.doFinal(byArray, 0);
        return byArray;
    }

    private byte[] a(Digest digest, byte[] byArray) {
        byte[] byArray2 = new byte[digest.getDigestSize()];
        digest.update(byArray, 0, byArray.length);
        digest.doFinal(byArray2, 0);
        return byArray2;
    }

    private byte[] a(byte[] byArray, NTRUEncryptionPrivateKeyParameters nTRUEncryptionPrivateKeyParameters) throws InvalidCipherTextException {
        Polynomial polynomial = nTRUEncryptionPrivateKeyParameters.t;
        IntegerPolynomial integerPolynomial = nTRUEncryptionPrivateKeyParameters.fp;
        IntegerPolynomial integerPolynomial2 = nTRUEncryptionPrivateKeyParameters.h;
        int n2 = this.b.N;
        int n3 = this.b.q;
        int n4 = this.b.db;
        int n5 = this.b.maxMsgLenBytes;
        int n6 = this.b.dm0;
        int n7 = this.b.pkLen;
        int n8 = this.b.minCallsMask;
        boolean bl = this.b.hashSeed;
        byte[] byArray2 = this.b.oid;
        if (n5 > 255) {
            throw new DataLengthException("maxMsgLenBytes values bigger than 255 are not supported");
        }
        int n9 = n4 / 8;
        IntegerPolynomial integerPolynomial3 = IntegerPolynomial.fromBinary(byArray, n2, n3);
        IntegerPolynomial integerPolynomial4 = this.decrypt(integerPolynomial3, polynomial, integerPolynomial);
        if (integerPolynomial4.count(-1) < n6) {
            throw new InvalidCipherTextException("Less than dm0 coefficients equal -1");
        }
        if (integerPolynomial4.count(0) < n6) {
            throw new InvalidCipherTextException("Less than dm0 coefficients equal 0");
        }
        if (integerPolynomial4.count(1) < n6) {
            throw new InvalidCipherTextException("Less than dm0 coefficients equal 1");
        }
        IntegerPolynomial integerPolynomial5 = (IntegerPolynomial)integerPolynomial3.clone();
        integerPolynomial5.sub(integerPolynomial4);
        integerPolynomial5.modPositive(n3);
        IntegerPolynomial integerPolynomial6 = (IntegerPolynomial)integerPolynomial5.clone();
        integerPolynomial6.modPositive(4);
        byte[] byArray3 = integerPolynomial6.toBinary(4);
        IntegerPolynomial integerPolynomial7 = this.a(byArray3, n2, n8, bl);
        IntegerPolynomial integerPolynomial8 = integerPolynomial4;
        integerPolynomial8.sub(integerPolynomial7);
        integerPolynomial8.mod3();
        byte[] byArray4 = integerPolynomial8.toBinary3Sves();
        byte[] byArray5 = new byte[n9];
        System.arraycopy(byArray4, 0, byArray5, 0, n9);
        int n10 = byArray4[n9] & 0xFF;
        if (n10 > n5) {
            throw new InvalidCipherTextException("Message too long: " + n10 + ">" + n5);
        }
        byte[] byArray6 = new byte[n10];
        System.arraycopy(byArray4, n9 + 1, byArray6, 0, n10);
        byte[] byArray7 = new byte[byArray4.length - (n9 + 1 + n10)];
        System.arraycopy(byArray4, n9 + 1 + n10, byArray7, 0, byArray7.length);
        if (!Arrays.constantTimeAreEqual(byArray7, new byte[byArray7.length])) {
            throw new InvalidCipherTextException("The message is not followed by zeroes");
        }
        byte[] byArray8 = integerPolynomial2.toBinary(n3);
        byte[] byArray9 = this.a(byArray8, n7 / 8);
        byte[] byArray10 = this.a(byArray2, byArray6, n10, byArray5, byArray9);
        Polynomial polynomial2 = this.a(byArray10, byArray6);
        IntegerPolynomial integerPolynomial9 = polynomial2.mult(integerPolynomial2);
        integerPolynomial9.modPositive(n3);
        if (!integerPolynomial9.equals(integerPolynomial5)) {
            throw new InvalidCipherTextException("Invalid message encoding");
        }
        return byArray6;
    }

    protected IntegerPolynomial decrypt(IntegerPolynomial e2, Polynomial priv_t, IntegerPolynomial priv_fp) {
        IntegerPolynomial integerPolynomial;
        if (this.b.fastFp) {
            integerPolynomial = priv_t.mult(e2, this.b.q);
            integerPolynomial.mult(3);
            integerPolynomial.add(e2);
        } else {
            integerPolynomial = priv_t.mult(e2, this.b.q);
        }
        integerPolynomial.center0(this.b.q);
        integerPolynomial.mod3();
        IntegerPolynomial integerPolynomial2 = this.b.fastFp ? integerPolynomial : new DenseTernaryPolynomial(integerPolynomial).mult(priv_fp, 3);
        integerPolynomial2.center0(3);
        return integerPolynomial2;
    }

    private byte[] a(byte[] byArray, int n2) {
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, 0, byArray2, 0, n2 < byArray.length ? n2 : byArray.length);
        return byArray2;
    }

    private int a(int n2) {
        if (n2 == 2048) {
            return 11;
        }
        throw new IllegalStateException("log2 not fully implemented");
    }
}

