/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.ntru;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.pqc.crypto.ntru.NTRUSignerPrng;
import com.enterprisedt.bouncycastle.pqc.crypto.ntru.NTRUSigningParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.ntru.NTRUSigningPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.ntru.NTRUSigningPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.math.ntru.polynomial.IntegerPolynomial;
import com.enterprisedt.bouncycastle.pqc.math.ntru.polynomial.Polynomial;
import java.nio.ByteBuffer;

public class NTRUSigner {
    private NTRUSigningParameters a;
    private Digest b;
    private NTRUSigningPrivateKeyParameters c;
    private NTRUSigningPublicKeyParameters d;

    public NTRUSigner(NTRUSigningParameters params) {
        this.a = params;
    }

    public void init(boolean forSigning, CipherParameters params) {
        if (forSigning) {
            this.c = (NTRUSigningPrivateKeyParameters)params;
        } else {
            this.d = (NTRUSigningPublicKeyParameters)params;
        }
        this.b = this.a.hashAlg;
        this.b.reset();
    }

    public void update(byte b2) {
        if (this.b == null) {
            throw new IllegalStateException("Call initSign or initVerify first!");
        }
        this.b.update(b2);
    }

    public void update(byte[] m2, int off, int length) {
        if (this.b == null) {
            throw new IllegalStateException("Call initSign or initVerify first!");
        }
        this.b.update(m2, off, length);
    }

    public byte[] generateSignature() {
        if (this.b == null || this.c == null) {
            throw new IllegalStateException("Call initSign first!");
        }
        byte[] byArray = new byte[this.b.getDigestSize()];
        this.b.doFinal(byArray, 0);
        return this.a(byArray, this.c);
    }

    private byte[] a(byte[] byArray, NTRUSigningPrivateKeyParameters nTRUSigningPrivateKeyParameters) {
        IntegerPolynomial integerPolynomial;
        IntegerPolynomial integerPolynomial2;
        int n2 = 0;
        NTRUSigningPublicKeyParameters nTRUSigningPublicKeyParameters = nTRUSigningPrivateKeyParameters.getPublicKey();
        do {
            if (++n2 <= this.a.signFailTolerance) continue;
            throw new IllegalStateException("Signing failed: too many retries (max=" + this.a.signFailTolerance + ")");
        } while (!this.a(integerPolynomial2 = this.createMsgRep(byArray, n2), integerPolynomial = this.a(integerPolynomial2, nTRUSigningPrivateKeyParameters), nTRUSigningPublicKeyParameters.h));
        byte[] byArray2 = integerPolynomial.toBinary(this.a.q);
        ByteBuffer byteBuffer = ByteBuffer.allocate(byArray2.length + 4);
        byteBuffer.put(byArray2);
        byteBuffer.putInt(n2);
        return byteBuffer.array();
    }

    private IntegerPolynomial a(IntegerPolynomial integerPolynomial, NTRUSigningPrivateKeyParameters nTRUSigningPrivateKeyParameters) {
        IntegerPolynomial integerPolynomial2;
        IntegerPolynomial integerPolynomial3;
        Polynomial polynomial;
        Polynomial polynomial2;
        int n2 = this.a.N;
        int n3 = this.a.q;
        int n4 = this.a.B;
        NTRUSigningPrivateKeyParameters nTRUSigningPrivateKeyParameters2 = nTRUSigningPrivateKeyParameters;
        NTRUSigningPublicKeyParameters nTRUSigningPublicKeyParameters = nTRUSigningPrivateKeyParameters.getPublicKey();
        IntegerPolynomial integerPolynomial4 = new IntegerPolynomial(n2);
        for (int i2 = n4; i2 >= 1; --i2) {
            polynomial2 = nTRUSigningPrivateKeyParameters2.getBasis((int)i2).f;
            polynomial = nTRUSigningPrivateKeyParameters2.getBasis((int)i2).fPrime;
            integerPolynomial3 = polynomial2.mult(integerPolynomial);
            integerPolynomial3.div(n3);
            integerPolynomial3 = polynomial.mult(integerPolynomial3);
            integerPolynomial2 = polynomial.mult(integerPolynomial);
            integerPolynomial2.div(n3);
            integerPolynomial2 = polynomial2.mult(integerPolynomial2);
            IntegerPolynomial integerPolynomial5 = integerPolynomial3;
            integerPolynomial5.sub(integerPolynomial2);
            integerPolynomial4.add(integerPolynomial5);
            IntegerPolynomial integerPolynomial6 = (IntegerPolynomial)nTRUSigningPrivateKeyParameters2.getBasis((int)i2).h.clone();
            if (i2 > 1) {
                integerPolynomial6.sub(nTRUSigningPrivateKeyParameters2.getBasis((int)(i2 - 1)).h);
            } else {
                integerPolynomial6.sub(nTRUSigningPublicKeyParameters.h);
            }
            integerPolynomial = integerPolynomial5.mult(integerPolynomial6, n3);
        }
        polynomial2 = nTRUSigningPrivateKeyParameters2.getBasis((int)0).f;
        polynomial = nTRUSigningPrivateKeyParameters2.getBasis((int)0).fPrime;
        integerPolynomial3 = polynomial2.mult(integerPolynomial);
        integerPolynomial3.div(n3);
        integerPolynomial3 = polynomial.mult(integerPolynomial3);
        integerPolynomial2 = polynomial.mult(integerPolynomial);
        integerPolynomial2.div(n3);
        integerPolynomial2 = polynomial2.mult(integerPolynomial2);
        integerPolynomial3.sub(integerPolynomial2);
        integerPolynomial4.add(integerPolynomial3);
        integerPolynomial4.modPositive(n3);
        return integerPolynomial4;
    }

    public boolean verifySignature(byte[] sig) {
        if (this.b == null || this.d == null) {
            throw new IllegalStateException("Call initVerify first!");
        }
        byte[] byArray = new byte[this.b.getDigestSize()];
        this.b.doFinal(byArray, 0);
        return this.a(byArray, sig, this.d);
    }

    private boolean a(byte[] byArray, byte[] byArray2, NTRUSigningPublicKeyParameters nTRUSigningPublicKeyParameters) {
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
        byte[] byArray3 = new byte[byArray2.length - 4];
        byteBuffer.get(byArray3);
        IntegerPolynomial integerPolynomial = IntegerPolynomial.fromBinary(byArray3, this.a.N, this.a.q);
        int n2 = byteBuffer.getInt();
        return this.a(this.createMsgRep(byArray, n2), integerPolynomial, nTRUSigningPublicKeyParameters.h);
    }

    private boolean a(IntegerPolynomial integerPolynomial, IntegerPolynomial integerPolynomial2, IntegerPolynomial integerPolynomial3) {
        int n2 = this.a.q;
        double d2 = this.a.normBoundSq;
        double d3 = this.a.betaSq;
        IntegerPolynomial integerPolynomial4 = integerPolynomial3.mult(integerPolynomial2, n2);
        integerPolynomial4.sub(integerPolynomial);
        long l2 = (long)((double)integerPolynomial2.centeredNormSq(n2) + d3 * (double)integerPolynomial4.centeredNormSq(n2));
        return (double)l2 <= d2;
    }

    protected IntegerPolynomial createMsgRep(byte[] msgHash, int r2) {
        int n2 = this.a.N;
        int n3 = this.a.q;
        int n4 = 31 - Integer.numberOfLeadingZeros(n3);
        int n5 = (n4 + 7) / 8;
        IntegerPolynomial integerPolynomial = new IntegerPolynomial(n2);
        ByteBuffer byteBuffer = ByteBuffer.allocate(msgHash.length + 4);
        byteBuffer.put(msgHash);
        byteBuffer.putInt(r2);
        NTRUSignerPrng nTRUSignerPrng = new NTRUSignerPrng(byteBuffer.array(), this.a.hashAlg);
        for (int i2 = 0; i2 < n2; ++i2) {
            byte[] byArray = nTRUSignerPrng.a(n5);
            int n6 = byArray[byArray.length - 1];
            n6 >>= 8 * n5 - n4;
            byArray[byArray.length - 1] = (byte)(n6 <<= 8 * n5 - n4);
            ByteBuffer byteBuffer2 = ByteBuffer.allocate(4);
            byteBuffer2.put(byArray);
            byteBuffer2.rewind();
            integerPolynomial.coeffs[i2] = Integer.reverseBytes(byteBuffer2.getInt());
        }
        return integerPolynomial;
    }
}

