/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.ntru;

import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.digests.SHA256Digest;
import com.enterprisedt.bouncycastle.crypto.digests.SHA512Digest;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.DecimalFormat;

public class NTRUSigningParameters
implements Cloneable {
    public int N;
    public int q;
    public int d;
    public int d1;
    public int d2;
    public int d3;
    public int B;
    double a;
    public double betaSq;
    double b;
    public double normBoundSq;
    public int signFailTolerance = 100;
    int c = 6;
    public Digest hashAlg;

    public NTRUSigningParameters(int N, int q2, int d2, int B, double beta, double normBound, Digest hashAlg) {
        this.N = N;
        this.q = q2;
        this.d = d2;
        this.B = B;
        this.a = beta;
        this.b = normBound;
        this.hashAlg = hashAlg;
        this.a();
    }

    public NTRUSigningParameters(int N, int q2, int d1, int d2, int d3, int B, double beta, double normBound, double keyNormBound, Digest hashAlg) {
        this.N = N;
        this.q = q2;
        this.d1 = d1;
        this.d2 = d2;
        this.d3 = d3;
        this.B = B;
        this.a = beta;
        this.b = normBound;
        this.hashAlg = hashAlg;
        this.a();
    }

    private void a() {
        this.betaSq = this.a * this.a;
        this.normBoundSq = this.b * this.b;
    }

    public NTRUSigningParameters(InputStream is) throws IOException {
        DataInputStream dataInputStream = new DataInputStream(is);
        this.N = dataInputStream.readInt();
        this.q = dataInputStream.readInt();
        this.d = dataInputStream.readInt();
        this.d1 = dataInputStream.readInt();
        this.d2 = dataInputStream.readInt();
        this.d3 = dataInputStream.readInt();
        this.B = dataInputStream.readInt();
        this.a = dataInputStream.readDouble();
        this.b = dataInputStream.readDouble();
        this.signFailTolerance = dataInputStream.readInt();
        this.c = dataInputStream.readInt();
        String string = dataInputStream.readUTF();
        if ("SHA-512".equals(string)) {
            this.hashAlg = new SHA512Digest();
        } else if ("SHA-256".equals(string)) {
            this.hashAlg = new SHA256Digest();
        }
        this.a();
    }

    public void writeTo(OutputStream os) throws IOException {
        DataOutputStream dataOutputStream = new DataOutputStream(os);
        dataOutputStream.writeInt(this.N);
        dataOutputStream.writeInt(this.q);
        dataOutputStream.writeInt(this.d);
        dataOutputStream.writeInt(this.d1);
        dataOutputStream.writeInt(this.d2);
        dataOutputStream.writeInt(this.d3);
        dataOutputStream.writeInt(this.B);
        dataOutputStream.writeDouble(this.a);
        dataOutputStream.writeDouble(this.b);
        dataOutputStream.writeInt(this.signFailTolerance);
        dataOutputStream.writeInt(this.c);
        dataOutputStream.writeUTF(this.hashAlg.getAlgorithmName());
    }

    public NTRUSigningParameters clone() {
        return new NTRUSigningParameters(this.N, this.q, this.d, this.B, this.a, this.b, this.hashAlg);
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + this.B;
        n3 = 31 * n3 + this.N;
        long l2 = Double.doubleToLongBits(this.a);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.betaSq);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        n3 = 31 * n3 + this.c;
        n3 = 31 * n3 + this.d;
        n3 = 31 * n3 + this.d1;
        n3 = 31 * n3 + this.d2;
        n3 = 31 * n3 + this.d3;
        n3 = 31 * n3 + (this.hashAlg == null ? 0 : this.hashAlg.getAlgorithmName().hashCode());
        l2 = Double.doubleToLongBits(this.b);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        l2 = Double.doubleToLongBits(this.normBoundSq);
        n3 = 31 * n3 + (int)(l2 ^ l2 >>> 32);
        n3 = 31 * n3 + this.q;
        n3 = 31 * n3 + this.signFailTolerance;
        return n3;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof NTRUSigningParameters)) {
            return false;
        }
        NTRUSigningParameters nTRUSigningParameters = (NTRUSigningParameters)obj;
        if (this.B != nTRUSigningParameters.B) {
            return false;
        }
        if (this.N != nTRUSigningParameters.N) {
            return false;
        }
        if (Double.doubleToLongBits(this.a) != Double.doubleToLongBits(nTRUSigningParameters.a)) {
            return false;
        }
        if (Double.doubleToLongBits(this.betaSq) != Double.doubleToLongBits(nTRUSigningParameters.betaSq)) {
            return false;
        }
        if (this.c != nTRUSigningParameters.c) {
            return false;
        }
        if (this.d != nTRUSigningParameters.d) {
            return false;
        }
        if (this.d1 != nTRUSigningParameters.d1) {
            return false;
        }
        if (this.d2 != nTRUSigningParameters.d2) {
            return false;
        }
        if (this.d3 != nTRUSigningParameters.d3) {
            return false;
        }
        if (this.hashAlg == null ? nTRUSigningParameters.hashAlg != null : !this.hashAlg.getAlgorithmName().equals(nTRUSigningParameters.hashAlg.getAlgorithmName())) {
            return false;
        }
        if (Double.doubleToLongBits(this.b) != Double.doubleToLongBits(nTRUSigningParameters.b)) {
            return false;
        }
        if (Double.doubleToLongBits(this.normBoundSq) != Double.doubleToLongBits(nTRUSigningParameters.normBoundSq)) {
            return false;
        }
        if (this.q != nTRUSigningParameters.q) {
            return false;
        }
        return this.signFailTolerance == nTRUSigningParameters.signFailTolerance;
    }

    public String toString() {
        DecimalFormat decimalFormat = new DecimalFormat("0.00");
        StringBuilder stringBuilder = new StringBuilder("SignatureParameters(N=" + this.N + " q=" + this.q);
        stringBuilder.append(" B=" + this.B + " beta=" + decimalFormat.format(this.a) + " normBound=" + decimalFormat.format(this.b) + " hashAlg=" + this.hashAlg + ")");
        return stringBuilder.toString();
    }
}

