/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.rainbow;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.CryptoServicesRegistrar;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.pqc.crypto.MessageSigner;
import com.enterprisedt.bouncycastle.pqc.crypto.rainbow.Layer;
import com.enterprisedt.bouncycastle.pqc.crypto.rainbow.RainbowKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.rainbow.RainbowPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.rainbow.RainbowPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.rainbow.util.ComputeInField;
import com.enterprisedt.bouncycastle.pqc.crypto.rainbow.util.GF2Field;
import java.security.SecureRandom;

public class RainbowSigner
implements MessageSigner {
    private SecureRandom c;
    int a;
    private short[] d;
    private ComputeInField e = new ComputeInField();
    RainbowKeyParameters b;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                ParametersWithRandom parametersWithRandom = (ParametersWithRandom)param;
                this.c = parametersWithRandom.getRandom();
                this.b = (RainbowPrivateKeyParameters)parametersWithRandom.getParameters();
            } else {
                this.c = CryptoServicesRegistrar.getSecureRandom();
                this.b = (RainbowPrivateKeyParameters)param;
            }
        } else {
            this.b = (RainbowPublicKeyParameters)param;
        }
        this.a = this.b.getDocLength();
    }

    private short[] a(Layer[] layerArray, short[] sArray) {
        short[] sArray2 = new short[sArray.length];
        sArray2 = this.e.addVect(((RainbowPrivateKeyParameters)this.b).getB1(), sArray);
        short[] sArray3 = this.e.multiplyMatrix(((RainbowPrivateKeyParameters)this.b).getInvA1(), sArray2);
        for (int i2 = 0; i2 < layerArray[0].getVi(); ++i2) {
            this.d[i2] = (short)this.c.nextInt();
            this.d[i2] = (short)(this.d[i2] & 0xFF);
        }
        return sArray3;
    }

    @Override
    public byte[] generateSignature(byte[] message) {
        boolean bl;
        Layer[] layerArray = ((RainbowPrivateKeyParameters)this.b).getLayers();
        int n2 = layerArray.length;
        this.d = new short[((RainbowPrivateKeyParameters)this.b).getInvA2().length];
        byte[] byArray = new byte[layerArray[n2 - 1].getViNext()];
        short[] sArray = this.a(message);
        int n3 = 0;
        do {
            bl = true;
            int n4 = 0;
            try {
                int n5;
                short[] sArray2 = this.a(layerArray, sArray);
                for (n5 = 0; n5 < n2; ++n5) {
                    int n6;
                    short[] sArray3 = new short[layerArray[n5].getOi()];
                    short[] sArray4 = new short[layerArray[n5].getOi()];
                    for (n6 = 0; n6 < layerArray[n5].getOi(); ++n6) {
                        sArray3[n6] = sArray2[n4];
                        ++n4;
                    }
                    sArray4 = this.e.solveEquation(layerArray[n5].plugInVinegars(this.d), sArray3);
                    if (sArray4 == null) {
                        throw new Exception("LES is not solveable!");
                    }
                    for (n6 = 0; n6 < sArray4.length; ++n6) {
                        this.d[layerArray[n5].getVi() + n6] = sArray4[n6];
                    }
                }
                short[] sArray5 = this.e.addVect(((RainbowPrivateKeyParameters)this.b).getB2(), this.d);
                short[] sArray6 = this.e.multiplyMatrix(((RainbowPrivateKeyParameters)this.b).getInvA2(), sArray5);
                for (n5 = 0; n5 < byArray.length; ++n5) {
                    byArray[n5] = (byte)sArray6[n5];
                }
            }
            catch (Exception exception) {
                bl = false;
            }
        } while (!bl && ++n3 < 65536);
        if (n3 == 65536) {
            throw new IllegalStateException("unable to generate signature - LES not solvable");
        }
        return byArray;
    }

    @Override
    public boolean verifySignature(byte[] message, byte[] signature) {
        short[] sArray = new short[signature.length];
        for (int i2 = 0; i2 < signature.length; ++i2) {
            short s2 = signature[i2];
            sArray[i2] = s2 = (short)(s2 & 0xFF);
        }
        short[] sArray2 = this.a(message);
        short[] sArray3 = this.a(sArray);
        boolean bl = true;
        if (sArray2.length != sArray3.length) {
            return false;
        }
        for (int i3 = 0; i3 < sArray2.length; ++i3) {
            bl = bl && sArray2[i3] == sArray3[i3];
        }
        return bl;
    }

    private short[] a(short[] sArray) {
        short[][] sArray2 = ((RainbowPublicKeyParameters)this.b).getCoeffQuadratic();
        short[][] sArray3 = ((RainbowPublicKeyParameters)this.b).getCoeffSingular();
        short[] sArray4 = ((RainbowPublicKeyParameters)this.b).getCoeffScalar();
        short[] sArray5 = new short[sArray2.length];
        int n2 = sArray3[0].length;
        int n3 = 0;
        short s2 = 0;
        for (int i2 = 0; i2 < sArray2.length; ++i2) {
            n3 = 0;
            for (int i3 = 0; i3 < n2; ++i3) {
                for (int i4 = i3; i4 < n2; ++i4) {
                    s2 = GF2Field.multElem(sArray2[i2][n3], GF2Field.multElem(sArray[i3], sArray[i4]));
                    sArray5[i2] = GF2Field.addElem(sArray5[i2], s2);
                    ++n3;
                }
                s2 = GF2Field.multElem(sArray3[i2][i3], sArray[i3]);
                sArray5[i2] = GF2Field.addElem(sArray5[i2], s2);
            }
            sArray5[i2] = GF2Field.addElem(sArray5[i2], sArray4[i2]);
        }
        return sArray5;
    }

    private short[] a(byte[] byArray) {
        short[] sArray = new short[this.a];
        int n2 = 0;
        int n3 = 0;
        while (n3 < byArray.length) {
            sArray[n3] = byArray[n2];
            int n4 = n3++;
            sArray[n4] = (short)(sArray[n4] & 0xFF);
            ++n2;
            if (n3 < sArray.length) continue;
        }
        return sArray;
    }
}

