/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.xmss;

import com.enterprisedt.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.enterprisedt.bouncycastle.crypto.KeyGenerationParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.BDS;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSKeyGenerationParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSNode;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSPublicKeyParameters;
import java.security.SecureRandom;

public final class XMSSKeyPairGenerator {
    private XMSSParameters a;
    private SecureRandom b;

    public void init(KeyGenerationParameters param) {
        XMSSKeyGenerationParameters xMSSKeyGenerationParameters = (XMSSKeyGenerationParameters)param;
        this.b = xMSSKeyGenerationParameters.getRandom();
        this.a = xMSSKeyGenerationParameters.getParameters();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        XMSSPrivateKeyParameters xMSSPrivateKeyParameters = this.a(this.a, this.b);
        XMSSNode xMSSNode = xMSSPrivateKeyParameters.a().getRoot();
        xMSSPrivateKeyParameters = new XMSSPrivateKeyParameters.Builder(this.a).withSecretKeySeed(xMSSPrivateKeyParameters.getSecretKeySeed()).withSecretKeyPRF(xMSSPrivateKeyParameters.getSecretKeyPRF()).withPublicSeed(xMSSPrivateKeyParameters.getPublicSeed()).withRoot(xMSSNode.getValue()).withBDSState(xMSSPrivateKeyParameters.a()).build();
        XMSSPublicKeyParameters xMSSPublicKeyParameters = new XMSSPublicKeyParameters.Builder(this.a).withRoot(xMSSNode.getValue()).withPublicSeed(xMSSPrivateKeyParameters.getPublicSeed()).build();
        return new AsymmetricCipherKeyPair(xMSSPublicKeyParameters, xMSSPrivateKeyParameters);
    }

    private XMSSPrivateKeyParameters a(XMSSParameters xMSSParameters, SecureRandom secureRandom) {
        int n2 = xMSSParameters.getDigestSize();
        byte[] byArray = new byte[n2];
        secureRandom.nextBytes(byArray);
        byte[] byArray2 = new byte[n2];
        secureRandom.nextBytes(byArray2);
        byte[] byArray3 = new byte[n2];
        secureRandom.nextBytes(byArray3);
        XMSSPrivateKeyParameters xMSSPrivateKeyParameters = new XMSSPrivateKeyParameters.Builder(xMSSParameters).withSecretKeySeed(byArray).withSecretKeyPRF(byArray2).withPublicSeed(byArray3).withBDSState(new BDS(xMSSParameters, byArray3, byArray, (OTSHashAddress)new OTSHashAddress.Builder().build())).build();
        return xMSSPrivateKeyParameters;
    }
}

