/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.xmss;

import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSStoreableObjectInterface;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSUtil;

public final class XMSSMTPublicKeyParameters
extends AsymmetricKeyParameter
implements XMSSStoreableObjectInterface {
    private final XMSSMTParameters b;
    private final byte[] c;
    private final byte[] d;

    private XMSSMTPublicKeyParameters(Builder builder) {
        super(false);
        this.b = builder.a;
        if (this.b == null) {
            throw new NullPointerException("params == null");
        }
        int n2 = this.b.getDigestSize();
        byte[] byArray = builder.d;
        if (byArray != null) {
            int n3 = n2;
            int n4 = n2;
            int n5 = n3 + n4;
            if (byArray.length != n5) {
                throw new IllegalArgumentException("public key has wrong size");
            }
            int n6 = 0;
            this.c = XMSSUtil.extractBytesAtOffset(byArray, n6, n3);
            this.d = XMSSUtil.extractBytesAtOffset(byArray, n6 += n3, n4);
        } else {
            byte[] byArray2 = builder.b;
            if (byArray2 != null) {
                if (byArray2.length != n2) {
                    throw new IllegalArgumentException("length of root must be equal to length of digest");
                }
                this.c = byArray2;
            } else {
                this.c = new byte[n2];
            }
            byte[] byArray3 = builder.c;
            if (byArray3 != null) {
                if (byArray3.length != n2) {
                    throw new IllegalArgumentException("length of publicSeed must be equal to length of digest");
                }
                this.d = byArray3;
            } else {
                this.d = new byte[n2];
            }
        }
    }

    @Override
    public byte[] toByteArray() {
        int n2;
        int n3 = n2 = this.b.getDigestSize();
        int n4 = n2;
        int n5 = n3 + n4;
        byte[] byArray = new byte[n5];
        int n6 = 0;
        XMSSUtil.copyBytesAtOffset(byArray, this.c, n6);
        XMSSUtil.copyBytesAtOffset(byArray, this.d, n6 += n3);
        return byArray;
    }

    public byte[] getRoot() {
        return XMSSUtil.cloneArray(this.c);
    }

    public byte[] getPublicSeed() {
        return XMSSUtil.cloneArray(this.d);
    }

    public XMSSMTParameters getParameters() {
        return this.b;
    }

    public static class Builder {
        private final XMSSMTParameters a;
        private byte[] b = null;
        private byte[] c = null;
        private byte[] d = null;

        public Builder(XMSSMTParameters params) {
            this.a = params;
        }

        public Builder withRoot(byte[] val) {
            this.b = XMSSUtil.cloneArray(val);
            return this;
        }

        public Builder withPublicSeed(byte[] val) {
            this.c = XMSSUtil.cloneArray(val);
            return this;
        }

        public Builder withPublicKey(byte[] val) {
            this.d = XMSSUtil.cloneArray(val);
            return this;
        }

        public XMSSMTPublicKeyParameters build() {
            return new XMSSMTPublicKeyParameters(this);
        }
    }
}

