/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.xmss;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.pqc.crypto.StateAwareMessageSigner;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.BDS;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.BDSStateMap;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSMTParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSMTPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSMTPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSMTSignature;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSNode;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSReducedSignature;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.c;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.e;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.g;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.i;
import com.enterprisedt.bouncycastle.util.Arrays;

public class XMSSMTSigner
implements StateAwareMessageSigner {
    private XMSSMTPrivateKeyParameters a;
    private XMSSMTPrivateKeyParameters b;
    private XMSSMTPublicKeyParameters c;
    private XMSSMTParameters d;
    private XMSSParameters e;
    private c f;
    private boolean g;
    private boolean h;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            this.h = true;
            this.g = false;
            this.b = this.a = (XMSSMTPrivateKeyParameters)param;
            this.d = this.a.getParameters();
            this.e = this.d.getXMSSParameters();
        } else {
            this.h = false;
            this.c = (XMSSMTPublicKeyParameters)param;
            this.d = this.c.getParameters();
            this.e = this.d.getXMSSParameters();
        }
        this.f = new c(new e(this.d.getDigest()));
    }

    @Override
    public byte[] generateSignature(byte[] message) {
        if (message == null) {
            throw new NullPointerException("message == null");
        }
        if (this.h) {
            if (this.a == null) {
                throw new IllegalStateException("signing key no longer usable");
            }
        } else {
            throw new IllegalStateException("signer not initialized for signature generation");
        }
        if (this.a.a().isEmpty()) {
            throw new IllegalStateException("not initialized");
        }
        BDSStateMap bDSStateMap = this.a.a();
        long l2 = this.a.getIndex();
        int n2 = this.d.getHeight();
        int n3 = this.e.getHeight();
        if (!XMSSUtil.isIndexValid(n2, l2)) {
            throw new IllegalStateException("index out of bounds");
        }
        byte[] byArray = this.f.b().d(this.a.getSecretKeyPRF(), XMSSUtil.toBytesBigEndian(l2, 32));
        byte[] byArray2 = Arrays.concatenate(byArray, this.a.getRoot(), XMSSUtil.toBytesBigEndian(l2, this.d.getDigestSize()));
        byte[] byArray3 = this.f.b().c(byArray2, message);
        XMSSMTSignature xMSSMTSignature = new XMSSMTSignature.Builder(this.d).withIndex(l2).withRandom(byArray).build();
        long l3 = XMSSUtil.getTreeIndex(l2, n3);
        int n4 = XMSSUtil.getLeafIndex(l2, n3);
        this.f.a(new byte[this.d.getDigestSize()], this.a.getPublicSeed());
        OTSHashAddress oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withTreeAddress(l3)).withOTSAddress(n4).build();
        if (bDSStateMap.get(0) == null || n4 == 0) {
            bDSStateMap.put(0, new BDS(this.e, this.a.getPublicSeed(), this.a.getSecretKeySeed(), oTSHashAddress));
        }
        g g2 = this.a(byArray3, oTSHashAddress);
        XMSSReducedSignature xMSSReducedSignature = new XMSSReducedSignature.Builder(this.e).withWOTSPlusSignature(g2).withAuthPath(bDSStateMap.get(0).getAuthenticationPath()).build();
        xMSSMTSignature.getReducedSignatures().add(xMSSReducedSignature);
        for (int i2 = 1; i2 < this.d.getLayers(); ++i2) {
            XMSSNode xMSSNode = bDSStateMap.get(i2 - 1).getRoot();
            n4 = XMSSUtil.getLeafIndex(l3, n3);
            l3 = XMSSUtil.getTreeIndex(l3, n3);
            oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(i2)).withTreeAddress(l3)).withOTSAddress(n4).build();
            g2 = this.a(xMSSNode.getValue(), oTSHashAddress);
            if (bDSStateMap.get(i2) == null || XMSSUtil.isNewBDSInitNeeded(l2, n3, i2)) {
                bDSStateMap.put(i2, new BDS(this.e, this.a.getPublicSeed(), this.a.getSecretKeySeed(), oTSHashAddress));
            }
            xMSSReducedSignature = new XMSSReducedSignature.Builder(this.e).withWOTSPlusSignature(g2).withAuthPath(bDSStateMap.get(i2).getAuthenticationPath()).build();
            xMSSMTSignature.getReducedSignatures().add(xMSSReducedSignature);
        }
        this.g = true;
        if (this.b != null) {
            this.b = this.a = this.b.getNextKey();
        } else {
            this.a = null;
        }
        return xMSSMTSignature.toByteArray();
    }

    @Override
    public boolean verifySignature(byte[] message, byte[] signature) {
        if (message == null) {
            throw new NullPointerException("message == null");
        }
        if (signature == null) {
            throw new NullPointerException("signature == null");
        }
        if (this.c == null) {
            throw new NullPointerException("publicKey == null");
        }
        XMSSMTSignature xMSSMTSignature = new XMSSMTSignature.Builder(this.d).withSignature(signature).build();
        byte[] byArray = Arrays.concatenate(xMSSMTSignature.getRandom(), this.c.getRoot(), XMSSUtil.toBytesBigEndian(xMSSMTSignature.getIndex(), this.d.getDigestSize()));
        byte[] byArray2 = this.f.b().c(byArray, message);
        long l2 = xMSSMTSignature.getIndex();
        int n2 = this.e.getHeight();
        long l3 = XMSSUtil.getTreeIndex(l2, n2);
        int n3 = XMSSUtil.getLeafIndex(l2, n2);
        this.f.a(new byte[this.d.getDigestSize()], this.c.getPublicSeed());
        OTSHashAddress oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withTreeAddress(l3)).withOTSAddress(n3).build();
        XMSSReducedSignature xMSSReducedSignature = xMSSMTSignature.getReducedSignatures().get(0);
        XMSSNode xMSSNode = i.a(this.f, n2, byArray2, xMSSReducedSignature, oTSHashAddress, n3);
        for (int i2 = 1; i2 < this.d.getLayers(); ++i2) {
            xMSSReducedSignature = xMSSMTSignature.getReducedSignatures().get(i2);
            n3 = XMSSUtil.getLeafIndex(l3, n2);
            l3 = XMSSUtil.getTreeIndex(l3, n2);
            oTSHashAddress = (OTSHashAddress)((OTSHashAddress.Builder)((OTSHashAddress.Builder)new OTSHashAddress.Builder().withLayerAddress(i2)).withTreeAddress(l3)).withOTSAddress(n3).build();
            xMSSNode = i.a(this.f, n2, xMSSNode.getValue(), xMSSReducedSignature, oTSHashAddress, n3);
        }
        return Arrays.constantTimeAreEqual(xMSSNode.getValue(), this.c.getRoot());
    }

    private g a(byte[] byArray, OTSHashAddress oTSHashAddress) {
        if (byArray.length != this.d.getDigestSize()) {
            throw new IllegalArgumentException("size of messageDigest needs to be equal to size of digest");
        }
        if (oTSHashAddress == null) {
            throw new NullPointerException("otsHashAddress == null");
        }
        this.f.a(this.f.b(this.a.getSecretKeySeed(), oTSHashAddress), this.a.getPublicSeed());
        return this.f.a(byArray, oTSHashAddress);
    }

    @Override
    public AsymmetricKeyParameter getUpdatedPrivateKey() {
        if (this.g) {
            XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = this.a;
            this.a = null;
            this.b = null;
            return xMSSMTPrivateKeyParameters;
        }
        XMSSMTPrivateKeyParameters xMSSMTPrivateKeyParameters = this.b.getNextKey();
        this.b = null;
        return xMSSMTPrivateKeyParameters;
    }
}

