/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.xmss;

import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.BDS;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSStoreableObjectInterface;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Pack;
import java.io.IOException;

public final class XMSSPrivateKeyParameters
extends AsymmetricKeyParameter
implements XMSSStoreableObjectInterface {
    private final XMSSParameters b;
    private final byte[] c;
    private final byte[] d;
    private final byte[] e;
    private final byte[] f;
    private final BDS g;

    private XMSSPrivateKeyParameters(Builder builder) {
        super(true);
        this.b = builder.a;
        if (this.b == null) {
            throw new NullPointerException("params == null");
        }
        int n2 = this.b.getDigestSize();
        byte[] byArray = builder.h;
        if (byArray != null) {
            if (builder.i == null) {
                throw new NullPointerException("xmss == null");
            }
            int n3 = this.b.getHeight();
            int n4 = 4;
            int n5 = n2;
            int n6 = n2;
            int n7 = n2;
            int n8 = n2;
            int n9 = 0;
            int n10 = Pack.bigEndianToInt(byArray, n9);
            if (!XMSSUtil.isIndexValid(n3, n10)) {
                throw new IllegalArgumentException("index out of bounds");
            }
            this.c = XMSSUtil.extractBytesAtOffset(byArray, n9 += n4, n5);
            this.d = XMSSUtil.extractBytesAtOffset(byArray, n9 += n5, n6);
            this.e = XMSSUtil.extractBytesAtOffset(byArray, n9 += n6, n7);
            this.f = XMSSUtil.extractBytesAtOffset(byArray, n9 += n7, n8);
            byte[] byArray2 = XMSSUtil.extractBytesAtOffset(byArray, n9 += n8, byArray.length - n9);
            try {
                BDS bDS = (BDS)XMSSUtil.deserialize(byArray2, BDS.class);
                bDS.setXMSS(builder.i);
                bDS.validate();
                if (bDS.getIndex() != n10) {
                    throw new IllegalStateException("serialized BDS has wrong index");
                }
                this.g = bDS;
            }
            catch (IOException iOException) {
                throw new IllegalArgumentException(iOException.getMessage(), iOException);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalArgumentException(classNotFoundException.getMessage(), classNotFoundException);
            }
        } else {
            byte[] byArray3 = builder.c;
            if (byArray3 != null) {
                if (byArray3.length != n2) {
                    throw new IllegalArgumentException("size of secretKeySeed needs to be equal size of digest");
                }
                this.c = byArray3;
            } else {
                this.c = new byte[n2];
            }
            byte[] byArray4 = builder.d;
            if (byArray4 != null) {
                if (byArray4.length != n2) {
                    throw new IllegalArgumentException("size of secretKeyPRF needs to be equal size of digest");
                }
                this.d = byArray4;
            } else {
                this.d = new byte[n2];
            }
            byte[] byArray5 = builder.e;
            if (byArray5 != null) {
                if (byArray5.length != n2) {
                    throw new IllegalArgumentException("size of publicSeed needs to be equal size of digest");
                }
                this.e = byArray5;
            } else {
                this.e = new byte[n2];
            }
            byte[] byArray6 = builder.f;
            if (byArray6 != null) {
                if (byArray6.length != n2) {
                    throw new IllegalArgumentException("size of root needs to be equal size of digest");
                }
                this.f = byArray6;
            } else {
                this.f = new byte[n2];
            }
            BDS bDS = builder.g;
            this.g = bDS != null ? bDS : (builder.b < (1 << this.b.getHeight()) - 2 && byArray5 != null && byArray3 != null ? new BDS(this.b, byArray5, byArray3, (OTSHashAddress)new OTSHashAddress.Builder().build(), builder.b) : new BDS(this.b, builder.b));
        }
    }

    @Override
    public byte[] toByteArray() {
        int n2 = this.b.getDigestSize();
        int n3 = 4;
        int n4 = n2;
        int n5 = n2;
        int n6 = n2;
        int n7 = n2;
        int n8 = n3 + n4 + n5 + n6 + n7;
        byte[] byArray = new byte[n8];
        int n9 = 0;
        Pack.intToBigEndian(this.g.getIndex(), byArray, n9);
        XMSSUtil.copyBytesAtOffset(byArray, this.c, n9 += n3);
        XMSSUtil.copyBytesAtOffset(byArray, this.d, n9 += n4);
        XMSSUtil.copyBytesAtOffset(byArray, this.e, n9 += n5);
        XMSSUtil.copyBytesAtOffset(byArray, this.f, n9 += n6);
        byte[] byArray2 = null;
        try {
            byArray2 = XMSSUtil.serialize(this.g);
        }
        catch (IOException iOException) {
            throw new RuntimeException("error serializing bds state: " + iOException.getMessage());
        }
        return Arrays.concatenate(byArray, byArray2);
    }

    public int getIndex() {
        return this.g.getIndex();
    }

    public byte[] getSecretKeySeed() {
        return XMSSUtil.cloneArray(this.c);
    }

    public byte[] getSecretKeyPRF() {
        return XMSSUtil.cloneArray(this.d);
    }

    public byte[] getPublicSeed() {
        return XMSSUtil.cloneArray(this.e);
    }

    public byte[] getRoot() {
        return XMSSUtil.cloneArray(this.f);
    }

    BDS a() {
        return this.g;
    }

    public XMSSParameters getParameters() {
        return this.b;
    }

    public XMSSPrivateKeyParameters getNextKey() {
        int n2 = this.b.getHeight();
        if (this.getIndex() < (1 << n2) - 1) {
            return new Builder(this.b).withSecretKeySeed(this.c).withSecretKeyPRF(this.d).withPublicSeed(this.e).withRoot(this.f).withBDSState(this.g.getNextState(this.e, this.c, (OTSHashAddress)new OTSHashAddress.Builder().build())).build();
        }
        return new Builder(this.b).withSecretKeySeed(this.c).withSecretKeyPRF(this.d).withPublicSeed(this.e).withRoot(this.f).withBDSState(new BDS(this.b, this.getIndex() + 1)).build();
    }

    public static class Builder {
        private final XMSSParameters a;
        private int b = 0;
        private byte[] c = null;
        private byte[] d = null;
        private byte[] e = null;
        private byte[] f = null;
        private BDS g = null;
        private byte[] h = null;
        private XMSSParameters i = null;

        public Builder(XMSSParameters params) {
            this.a = params;
        }

        public Builder withIndex(int val) {
            this.b = val;
            return this;
        }

        public Builder withSecretKeySeed(byte[] val) {
            this.c = XMSSUtil.cloneArray(val);
            return this;
        }

        public Builder withSecretKeyPRF(byte[] val) {
            this.d = XMSSUtil.cloneArray(val);
            return this;
        }

        public Builder withPublicSeed(byte[] val) {
            this.e = XMSSUtil.cloneArray(val);
            return this;
        }

        public Builder withRoot(byte[] val) {
            this.f = XMSSUtil.cloneArray(val);
            return this;
        }

        public Builder withBDSState(BDS valBDS) {
            this.g = valBDS;
            return this;
        }

        public Builder withPrivateKey(byte[] privateKeyVal, XMSSParameters xmssParameters) {
            this.h = XMSSUtil.cloneArray(privateKeyVal);
            this.i = xmssParameters;
            return this;
        }

        public XMSSPrivateKeyParameters build() {
            return new XMSSPrivateKeyParameters(this);
        }
    }
}

