/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.xmss;

import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSStoreableObjectInterface;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSUtil;

public final class XMSSPublicKeyParameters
extends AsymmetricKeyParameter
implements XMSSStoreableObjectInterface {
    private final XMSSParameters b;
    private final byte[] c;
    private final byte[] d;

    private XMSSPublicKeyParameters(Builder builder) {
        super(false);
        this.b = builder.a;
        if (this.b == null) {
            throw new NullPointerException("params == null");
        }
        int n2 = this.b.getDigestSize();
        byte[] byArray = builder.d;
        if (byArray != null) {
            int n3 = n2;
            int n4 = n2;
            int n5 = n3 + n4;
            if (byArray.length != n5) {
                throw new IllegalArgumentException("public key has wrong size");
            }
            int n6 = 0;
            this.c = XMSSUtil.extractBytesAtOffset(byArray, n6, n3);
            this.d = XMSSUtil.extractBytesAtOffset(byArray, n6 += n3, n4);
        } else {
            byte[] byArray2 = builder.b;
            if (byArray2 != null) {
                if (byArray2.length != n2) {
                    throw new IllegalArgumentException("length of root must be equal to length of digest");
                }
                this.c = byArray2;
            } else {
                this.c = new byte[n2];
            }
            byte[] byArray3 = builder.c;
            if (byArray3 != null) {
                if (byArray3.length != n2) {
                    throw new IllegalArgumentException("length of publicSeed must be equal to length of digest");
                }
                this.d = byArray3;
            } else {
                this.d = new byte[n2];
            }
        }
    }

    @Override
    public byte[] toByteArray() {
        int n2;
        int n3 = n2 = this.b.getDigestSize();
        int n4 = n2;
        int n5 = n3 + n4;
        byte[] byArray = new byte[n5];
        int n6 = 0;
        XMSSUtil.copyBytesAtOffset(byArray, this.c, n6);
        XMSSUtil.copyBytesAtOffset(byArray, this.d, n6 += n3);
        return byArray;
    }

    public byte[] getRoot() {
        return XMSSUtil.cloneArray(this.c);
    }

    public byte[] getPublicSeed() {
        return XMSSUtil.cloneArray(this.d);
    }

    public XMSSParameters getParameters() {
        return this.b;
    }

    public static class Builder {
        private final XMSSParameters a;
        private byte[] b = null;
        private byte[] c = null;
        private byte[] d = null;

        public Builder(XMSSParameters params) {
            this.a = params;
        }

        public Builder withRoot(byte[] val) {
            this.b = XMSSUtil.cloneArray(val);
            return this;
        }

        public Builder withPublicSeed(byte[] val) {
            this.c = XMSSUtil.cloneArray(val);
            return this;
        }

        public Builder withPublicKey(byte[] val) {
            this.d = XMSSUtil.cloneArray(val);
            return this;
        }

        public XMSSPublicKeyParameters build() {
            return new XMSSPublicKeyParameters(this);
        }
    }
}

