/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.xmss;

import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSNode;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSStoreableObjectInterface;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.g;
import java.util.ArrayList;
import java.util.List;

public class XMSSReducedSignature
implements XMSSStoreableObjectInterface {
    private final XMSSParameters a;
    private final g b;
    private final List<XMSSNode> c;

    protected XMSSReducedSignature(Builder builder) {
        this.a = builder.a;
        if (this.a == null) {
            throw new NullPointerException("params == null");
        }
        int n2 = this.a.getDigestSize();
        int n3 = this.a.a().a().d();
        int n4 = this.a.getHeight();
        byte[] byArray = builder.d;
        if (byArray != null) {
            int n5 = n3 * n2;
            int n6 = n4 * n2;
            int n7 = n5 + n6;
            if (byArray.length != n7) {
                throw new IllegalArgumentException("signature has wrong size");
            }
            int n8 = 0;
            byte[][] byArrayArray = new byte[n3][];
            for (int i2 = 0; i2 < byArrayArray.length; ++i2) {
                byArrayArray[i2] = XMSSUtil.extractBytesAtOffset(byArray, n8, n2);
                n8 += n2;
            }
            this.b = new g(this.a.a().a(), byArrayArray);
            ArrayList<XMSSNode> arrayList = new ArrayList<XMSSNode>();
            for (int i3 = 0; i3 < n4; ++i3) {
                arrayList.add(new XMSSNode(i3, XMSSUtil.extractBytesAtOffset(byArray, n8, n2)));
                n8 += n2;
            }
            this.c = arrayList;
        } else {
            g g2 = builder.b;
            this.b = g2 != null ? g2 : new g(this.a.a().a(), new byte[n3][n2]);
            List list = builder.c;
            if (list != null) {
                if (list.size() != n4) {
                    throw new IllegalArgumentException("size of authPath needs to be equal to height of tree");
                }
                this.c = list;
            } else {
                this.c = new ArrayList<XMSSNode>();
            }
        }
    }

    @Override
    public byte[] toByteArray() {
        int n2;
        int n3 = this.a.getDigestSize();
        int n4 = this.a.a().a().d() * n3;
        int n5 = this.a.getHeight() * n3;
        int n6 = n4 + n5;
        byte[] byArray = new byte[n6];
        int n7 = 0;
        byte[][] byArray2 = this.b.a();
        for (n2 = 0; n2 < byArray2.length; ++n2) {
            XMSSUtil.copyBytesAtOffset(byArray, byArray2[n2], n7);
            n7 += n3;
        }
        for (n2 = 0; n2 < this.c.size(); ++n2) {
            byte[] byArray3 = this.c.get(n2).getValue();
            XMSSUtil.copyBytesAtOffset(byArray, byArray3, n7);
            n7 += n3;
        }
        return byArray;
    }

    public XMSSParameters getParams() {
        return this.a;
    }

    public g getWOTSPlusSignature() {
        return this.b;
    }

    public List<XMSSNode> getAuthPath() {
        return this.c;
    }

    public static class Builder {
        private final XMSSParameters a;
        private g b = null;
        private List<XMSSNode> c = null;
        private byte[] d = null;

        public Builder(XMSSParameters params) {
            this.a = params;
        }

        public Builder withWOTSPlusSignature(g val) {
            this.b = val;
            return this;
        }

        public Builder withAuthPath(List<XMSSNode> val) {
            this.c = val;
            return this;
        }

        public Builder withReducedSignature(byte[] val) {
            this.d = XMSSUtil.cloneArray(val);
            return this;
        }

        public XMSSReducedSignature build() {
            return new XMSSReducedSignature(this);
        }
    }
}

