/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.crypto.xmss;

import com.enterprisedt.bouncycastle.crypto.CipherParameters;
import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.pqc.crypto.StateAwareMessageSigner;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.OTSHashAddress;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSNode;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSPrivateKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSPublicKeyParameters;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSSignature;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.XMSSUtil;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.b;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.g;
import com.enterprisedt.bouncycastle.pqc.crypto.xmss.i;
import com.enterprisedt.bouncycastle.util.Arrays;

public class XMSSSigner
implements StateAwareMessageSigner {
    private XMSSPrivateKeyParameters a;
    private XMSSPrivateKeyParameters b;
    private XMSSPublicKeyParameters c;
    private XMSSParameters d;
    private b e;
    private boolean f;
    private boolean g;

    @Override
    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            this.f = true;
            this.g = false;
            this.b = this.a = (XMSSPrivateKeyParameters)param;
            this.d = this.a.getParameters();
            this.e = this.d.a().b();
        } else {
            this.f = false;
            this.c = (XMSSPublicKeyParameters)param;
            this.d = this.c.getParameters();
            this.e = this.d.a().b();
        }
    }

    @Override
    public byte[] generateSignature(byte[] message) {
        if (message == null) {
            throw new NullPointerException("message == null");
        }
        if (this.f) {
            if (this.a == null) {
                throw new IllegalStateException("signing key no longer usable");
            }
        } else {
            throw new IllegalStateException("signer not initialized for signature generation");
        }
        if (this.a.a().getAuthenticationPath().isEmpty()) {
            throw new IllegalStateException("not initialized");
        }
        int n2 = this.a.getIndex();
        if (!XMSSUtil.isIndexValid(this.d.getHeight(), n2)) {
            throw new IllegalStateException("index out of bounds");
        }
        byte[] byArray = this.e.d(this.a.getSecretKeyPRF(), XMSSUtil.toBytesBigEndian(n2, 32));
        byte[] byArray2 = Arrays.concatenate(byArray, this.a.getRoot(), XMSSUtil.toBytesBigEndian(n2, this.d.getDigestSize()));
        byte[] byArray3 = this.e.c(byArray2, message);
        OTSHashAddress oTSHashAddress = (OTSHashAddress)new OTSHashAddress.Builder().withOTSAddress(n2).build();
        g g2 = this.a(byArray3, oTSHashAddress);
        XMSSSignature xMSSSignature = (XMSSSignature)new XMSSSignature.Builder(this.d).withIndex(n2).withRandom(byArray).withWOTSPlusSignature(g2).withAuthPath(this.a.a().getAuthenticationPath()).build();
        this.g = true;
        if (this.b != null) {
            this.b = this.a = this.b.getNextKey();
        } else {
            this.a = null;
        }
        return xMSSSignature.toByteArray();
    }

    @Override
    public boolean verifySignature(byte[] message, byte[] signature) {
        XMSSSignature xMSSSignature = new XMSSSignature.Builder(this.d).withSignature(signature).build();
        int n2 = xMSSSignature.getIndex();
        this.d.a().a(new byte[this.d.getDigestSize()], this.c.getPublicSeed());
        byte[] byArray = Arrays.concatenate(xMSSSignature.getRandom(), this.c.getRoot(), XMSSUtil.toBytesBigEndian(n2, this.d.getDigestSize()));
        byte[] byArray2 = this.e.c(byArray, message);
        int n3 = this.d.getHeight();
        int n4 = XMSSUtil.getLeafIndex(n2, n3);
        OTSHashAddress oTSHashAddress = (OTSHashAddress)new OTSHashAddress.Builder().withOTSAddress(n2).build();
        XMSSNode xMSSNode = i.a(this.d.a(), n3, byArray2, xMSSSignature, oTSHashAddress, n4);
        return Arrays.constantTimeAreEqual(xMSSNode.getValue(), this.c.getRoot());
    }

    @Override
    public AsymmetricKeyParameter getUpdatedPrivateKey() {
        if (this.g) {
            XMSSPrivateKeyParameters xMSSPrivateKeyParameters = this.a;
            this.a = null;
            this.b = null;
            return xMSSPrivateKeyParameters;
        }
        XMSSPrivateKeyParameters xMSSPrivateKeyParameters = this.b.getNextKey();
        this.b = null;
        return xMSSPrivateKeyParameters;
    }

    private g a(byte[] byArray, OTSHashAddress oTSHashAddress) {
        if (byArray.length != this.d.getDigestSize()) {
            throw new IllegalArgumentException("size of messageDigest needs to be equal to size of digest");
        }
        if (oTSHashAddress == null) {
            throw new NullPointerException("otsHashAddress == null");
        }
        this.d.a().a(this.d.a().b(this.a.getSecretKeySeed(), oTSHashAddress), this.a.getPublicSeed());
        return this.d.a().a(byArray, oTSHashAddress);
    }
}

