/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.math.linearalgebra;

import com.enterprisedt.bouncycastle.pqc.math.linearalgebra.IntegerFunctions;

public final class BigEndianConversions {
    private BigEndianConversions() {
    }

    public static byte[] I2OSP(int x2) {
        byte[] byArray = new byte[]{(byte)(x2 >>> 24), (byte)(x2 >>> 16), (byte)(x2 >>> 8), (byte)x2};
        return byArray;
    }

    public static byte[] I2OSP(int x2, int oLen) throws ArithmeticException {
        if (x2 < 0) {
            return null;
        }
        int n2 = IntegerFunctions.ceilLog256(x2);
        if (n2 > oLen) {
            throw new ArithmeticException("Cannot encode given integer into specified number of octets.");
        }
        byte[] byArray = new byte[oLen];
        for (int i2 = oLen - 1; i2 >= oLen - n2; --i2) {
            byArray[i2] = (byte)(x2 >>> 8 * (oLen - 1 - i2));
        }
        return byArray;
    }

    public static void I2OSP(int input, byte[] output, int outOff) {
        output[outOff++] = (byte)(input >>> 24);
        output[outOff++] = (byte)(input >>> 16);
        output[outOff++] = (byte)(input >>> 8);
        output[outOff] = (byte)input;
    }

    public static byte[] I2OSP(long input) {
        byte[] byArray = new byte[]{(byte)(input >>> 56), (byte)(input >>> 48), (byte)(input >>> 40), (byte)(input >>> 32), (byte)(input >>> 24), (byte)(input >>> 16), (byte)(input >>> 8), (byte)input};
        return byArray;
    }

    public static void I2OSP(long input, byte[] output, int outOff) {
        output[outOff++] = (byte)(input >>> 56);
        output[outOff++] = (byte)(input >>> 48);
        output[outOff++] = (byte)(input >>> 40);
        output[outOff++] = (byte)(input >>> 32);
        output[outOff++] = (byte)(input >>> 24);
        output[outOff++] = (byte)(input >>> 16);
        output[outOff++] = (byte)(input >>> 8);
        output[outOff] = (byte)input;
    }

    public static void I2OSP(int input, byte[] output, int outOff, int length) {
        for (int i2 = length - 1; i2 >= 0; --i2) {
            output[outOff + i2] = (byte)(input >>> 8 * (length - 1 - i2));
        }
    }

    public static int OS2IP(byte[] input) {
        if (input.length > 4) {
            throw new ArithmeticException("invalid input length");
        }
        if (input.length == 0) {
            return 0;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < input.length; ++i2) {
            n2 |= (input[i2] & 0xFF) << 8 * (input.length - 1 - i2);
        }
        return n2;
    }

    public static int OS2IP(byte[] input, int inOff) {
        int n2 = (input[inOff++] & 0xFF) << 24;
        n2 |= (input[inOff++] & 0xFF) << 16;
        n2 |= (input[inOff++] & 0xFF) << 8;
        return n2 |= input[inOff] & 0xFF;
    }

    public static int OS2IP(byte[] input, int inOff, int inLen) {
        if (input.length == 0 || input.length < inOff + inLen - 1) {
            return 0;
        }
        int n2 = 0;
        for (int i2 = 0; i2 < inLen; ++i2) {
            n2 |= (input[inOff + i2] & 0xFF) << 8 * (inLen - i2 - 1);
        }
        return n2;
    }

    public static long OS2LIP(byte[] input, int inOff) {
        long l2 = ((long)input[inOff++] & 0xFFL) << 56;
        l2 |= ((long)input[inOff++] & 0xFFL) << 48;
        l2 |= ((long)input[inOff++] & 0xFFL) << 40;
        l2 |= ((long)input[inOff++] & 0xFFL) << 32;
        l2 |= ((long)input[inOff++] & 0xFFL) << 24;
        l2 |= (long)((input[inOff++] & 0xFF) << 16);
        l2 |= (long)((input[inOff++] & 0xFF) << 8);
        return l2 |= (long)(input[inOff] & 0xFF);
    }

    public static byte[] toByteArray(int[] input) {
        byte[] byArray = new byte[input.length << 2];
        for (int i2 = 0; i2 < input.length; ++i2) {
            BigEndianConversions.I2OSP(input[i2], byArray, i2 << 2);
        }
        return byArray;
    }

    public static byte[] toByteArray(int[] input, int length) {
        int n2 = input.length;
        byte[] byArray = new byte[length];
        int n3 = 0;
        int n4 = 0;
        while (n4 <= n2 - 2) {
            BigEndianConversions.I2OSP(input[n4], byArray, n3);
            ++n4;
            n3 += 4;
        }
        BigEndianConversions.I2OSP(input[n2 - 1], byArray, n3, length - n3);
        return byArray;
    }

    public static int[] toIntArray(byte[] input) {
        int n2 = (input.length + 3) / 4;
        int n3 = input.length & 3;
        int[] nArray = new int[n2];
        int n4 = 0;
        int n5 = 0;
        while (n5 <= n2 - 2) {
            nArray[n5] = BigEndianConversions.OS2IP(input, n4);
            ++n5;
            n4 += 4;
        }
        nArray[n2 - 1] = n3 != 0 ? BigEndianConversions.OS2IP(input, n4, n3) : BigEndianConversions.OS2IP(input, n4);
        return nArray;
    }
}

