/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.pqc.math.ntru.polynomial;

import com.enterprisedt.bouncycastle.pqc.math.ntru.polynomial.BigIntPolynomial;
import com.enterprisedt.bouncycastle.pqc.math.ntru.polynomial.IntegerPolynomial;
import com.enterprisedt.bouncycastle.pqc.math.ntru.polynomial.TernaryPolynomial;
import com.enterprisedt.bouncycastle.pqc.math.ntru.util.ArrayEncoder;
import com.enterprisedt.bouncycastle.pqc.math.ntru.util.Util;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.SecureRandom;

public class SparseTernaryPolynomial
implements TernaryPolynomial {
    private int a;
    private int[] b;
    private int[] c;

    SparseTernaryPolynomial(int N, int[] ones, int[] negOnes) {
        this.a = N;
        this.b = ones;
        this.c = negOnes;
    }

    public SparseTernaryPolynomial(IntegerPolynomial intPoly) {
        this(intPoly.coeffs);
    }

    public SparseTernaryPolynomial(int[] coeffs) {
        this.a = coeffs.length;
        this.b = new int[this.a];
        this.c = new int[this.a];
        int n2 = 0;
        int n3 = 0;
        block5: for (int i2 = 0; i2 < this.a; ++i2) {
            int n4 = coeffs[i2];
            switch (n4) {
                case 1: {
                    this.b[n2++] = i2;
                    continue block5;
                }
                case -1: {
                    this.c[n3++] = i2;
                    continue block5;
                }
                case 0: {
                    continue block5;
                }
                default: {
                    throw new IllegalArgumentException("Illegal value: " + n4 + ", must be one of {-1, 0, 1}");
                }
            }
        }
        this.b = Arrays.copyOf(this.b, n2);
        this.c = Arrays.copyOf(this.c, n3);
    }

    public static SparseTernaryPolynomial fromBinary(InputStream is, int N, int numOnes, int numNegOnes) throws IOException {
        int n2 = 2048;
        int n3 = 32 - Integer.numberOfLeadingZeros(n2 - 1);
        int n4 = (numOnes * n3 + 7) / 8;
        byte[] byArray = Util.readFullLength(is, n4);
        int[] nArray = ArrayEncoder.decodeModQ(byArray, numOnes, n2);
        int n5 = (numNegOnes * n3 + 7) / 8;
        byte[] byArray2 = Util.readFullLength(is, n5);
        int[] nArray2 = ArrayEncoder.decodeModQ(byArray2, numNegOnes, n2);
        return new SparseTernaryPolynomial(N, nArray, nArray2);
    }

    public static SparseTernaryPolynomial generateRandom(int N, int numOnes, int numNegOnes, SecureRandom random) {
        int[] nArray = Util.generateRandomTernary(N, numOnes, numNegOnes, random);
        return new SparseTernaryPolynomial(nArray);
    }

    @Override
    public IntegerPolynomial mult(IntegerPolynomial poly2) {
        int n2;
        int n3;
        int n4;
        int n5;
        int[] nArray = poly2.coeffs;
        if (nArray.length != this.a) {
            throw new IllegalArgumentException("Number of coefficients must be the same");
        }
        int[] nArray2 = new int[this.a];
        for (n5 = 0; n5 != this.b.length; ++n5) {
            n4 = this.b[n5];
            n3 = this.a - 1 - n4;
            for (n2 = this.a - 1; n2 >= 0; --n2) {
                int n6 = n2;
                nArray2[n6] = nArray2[n6] + nArray[n3];
                if (--n3 >= 0) continue;
                n3 = this.a - 1;
            }
        }
        for (n5 = 0; n5 != this.c.length; ++n5) {
            n4 = this.c[n5];
            n3 = this.a - 1 - n4;
            for (n2 = this.a - 1; n2 >= 0; --n2) {
                int n7 = n2;
                nArray2[n7] = nArray2[n7] - nArray[n3];
                if (--n3 >= 0) continue;
                n3 = this.a - 1;
            }
        }
        return new IntegerPolynomial(nArray2);
    }

    @Override
    public IntegerPolynomial mult(IntegerPolynomial poly2, int modulus) {
        IntegerPolynomial integerPolynomial = this.mult(poly2);
        integerPolynomial.mod(modulus);
        return integerPolynomial;
    }

    @Override
    public BigIntPolynomial mult(BigIntPolynomial poly2) {
        int n2;
        int n3;
        int n4;
        int n5;
        BigInteger[] bigIntegerArray = poly2.a;
        if (bigIntegerArray.length != this.a) {
            throw new IllegalArgumentException("Number of coefficients must be the same");
        }
        BigInteger[] bigIntegerArray2 = new BigInteger[this.a];
        for (n5 = 0; n5 < this.a; ++n5) {
            bigIntegerArray2[n5] = BigInteger.ZERO;
        }
        for (n5 = 0; n5 != this.b.length; ++n5) {
            n4 = this.b[n5];
            n3 = this.a - 1 - n4;
            for (n2 = this.a - 1; n2 >= 0; --n2) {
                bigIntegerArray2[n2] = bigIntegerArray2[n2].add(bigIntegerArray[n3]);
                if (--n3 >= 0) continue;
                n3 = this.a - 1;
            }
        }
        for (n5 = 0; n5 != this.c.length; ++n5) {
            n4 = this.c[n5];
            n3 = this.a - 1 - n4;
            for (n2 = this.a - 1; n2 >= 0; --n2) {
                bigIntegerArray2[n2] = bigIntegerArray2[n2].subtract(bigIntegerArray[n3]);
                if (--n3 >= 0) continue;
                n3 = this.a - 1;
            }
        }
        return new BigIntPolynomial(bigIntegerArray2);
    }

    @Override
    public int[] getOnes() {
        return this.b;
    }

    @Override
    public int[] getNegOnes() {
        return this.c;
    }

    public byte[] toBinary() {
        int n2 = 2048;
        byte[] byArray = ArrayEncoder.encodeModQ(this.b, n2);
        byte[] byArray2 = ArrayEncoder.encodeModQ(this.c, n2);
        byte[] byArray3 = Arrays.copyOf(byArray, byArray.length + byArray2.length);
        System.arraycopy(byArray2, 0, byArray3, byArray.length, byArray2.length);
        return byArray3;
    }

    @Override
    public IntegerPolynomial toIntegerPolynomial() {
        int n2;
        int n3;
        int[] nArray = new int[this.a];
        for (n3 = 0; n3 != this.b.length; ++n3) {
            n2 = this.b[n3];
            nArray[n2] = 1;
        }
        for (n3 = 0; n3 != this.c.length; ++n3) {
            n2 = this.c[n3];
            nArray[n2] = -1;
        }
        return new IntegerPolynomial(nArray);
    }

    @Override
    public int size() {
        return this.a;
    }

    @Override
    public void clear() {
        int n2;
        for (n2 = 0; n2 < this.b.length; ++n2) {
            this.b[n2] = 0;
        }
        for (n2 = 0; n2 < this.c.length; ++n2) {
            this.c[n2] = 0;
        }
    }

    public int hashCode() {
        int n2 = 31;
        int n3 = 1;
        n3 = 31 * n3 + this.a;
        n3 = 31 * n3 + Arrays.hashCode(this.c);
        n3 = 31 * n3 + Arrays.hashCode(this.b);
        return n3;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SparseTernaryPolynomial sparseTernaryPolynomial = (SparseTernaryPolynomial)obj;
        if (this.a != sparseTernaryPolynomial.a) {
            return false;
        }
        if (!Arrays.areEqual(this.c, sparseTernaryPolynomial.c)) {
            return false;
        }
        return Arrays.areEqual(this.b, sparseTernaryPolynomial.b);
    }
}

