/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.asn1.ocsp.OCSPResponse;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class CertificateStatus {
    protected short statusType;
    protected Object response;

    public CertificateStatus(short statusType, Object response) {
        if (!CertificateStatus.isCorrectType(statusType, response)) {
            throw new IllegalArgumentException("'response' is not an instance of the correct type");
        }
        this.statusType = statusType;
        this.response = response;
    }

    public short getStatusType() {
        return this.statusType;
    }

    public Object getResponse() {
        return this.response;
    }

    public OCSPResponse getOCSPResponse() {
        if (!CertificateStatus.isCorrectType((short)1, this.response)) {
            throw new IllegalStateException("'response' is not an OCSPResponse");
        }
        return (OCSPResponse)this.response;
    }

    public void encode(OutputStream output) throws IOException {
        TlsUtils.writeUint8(this.statusType, output);
        switch (this.statusType) {
            case 1: {
                byte[] byArray = ((OCSPResponse)this.response).getEncoded("DER");
                TlsUtils.writeOpaque24(byArray, output);
                break;
            }
            default: {
                throw new TlsFatalAlert(80);
            }
        }
    }

    public static CertificateStatus parse(InputStream input) throws IOException {
        OCSPResponse oCSPResponse;
        short s2 = TlsUtils.readUint8(input);
        switch (s2) {
            case 1: {
                byte[] byArray = TlsUtils.readOpaque24(input);
                oCSPResponse = OCSPResponse.getInstance(TlsUtils.readDERObject(byArray));
                break;
            }
            default: {
                throw new TlsFatalAlert(50);
            }
        }
        return new CertificateStatus(s2, oCSPResponse);
    }

    protected static boolean isCorrectType(short statusType, Object response) {
        switch (statusType) {
            case 1: {
                return response instanceof OCSPResponse;
            }
        }
        throw new IllegalArgumentException("'statusType' is an unsupported CertificateStatusType");
    }
}

