/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.Certificate;
import com.enterprisedt.bouncycastle.tls.CertificateRequest;
import com.enterprisedt.bouncycastle.tls.CertificateStatus;
import com.enterprisedt.bouncycastle.tls.CipherSuite;
import com.enterprisedt.bouncycastle.tls.DTLSProtocol;
import com.enterprisedt.bouncycastle.tls.DTLSTransport;
import com.enterprisedt.bouncycastle.tls.DatagramTransport;
import com.enterprisedt.bouncycastle.tls.DigitallySigned;
import com.enterprisedt.bouncycastle.tls.NewSessionTicket;
import com.enterprisedt.bouncycastle.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.tls.SecurityParameters;
import com.enterprisedt.bouncycastle.tls.SessionParameters;
import com.enterprisedt.bouncycastle.tls.TlsAuthentication;
import com.enterprisedt.bouncycastle.tls.TlsClient;
import com.enterprisedt.bouncycastle.tls.TlsClientContextImpl;
import com.enterprisedt.bouncycastle.tls.TlsContext;
import com.enterprisedt.bouncycastle.tls.TlsCredentialedSigner;
import com.enterprisedt.bouncycastle.tls.TlsCredentials;
import com.enterprisedt.bouncycastle.tls.TlsExtensionsUtils;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsHandshakeHash;
import com.enterprisedt.bouncycastle.tls.TlsKeyExchange;
import com.enterprisedt.bouncycastle.tls.TlsProtocol;
import com.enterprisedt.bouncycastle.tls.TlsSession;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsStreamSigner;
import com.enterprisedt.bouncycastle.tls.e;
import com.enterprisedt.bouncycastle.tls.f;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.util.Hashtable;
import java.util.Vector;

public class DTLSClientProtocol
extends DTLSProtocol {
    public DTLSTransport connect(TlsClient client, DatagramTransport transport) throws IOException {
        Object object;
        if (client == null) {
            throw new IllegalArgumentException("'client' cannot be null");
        }
        if (transport == null) {
            throw new IllegalArgumentException("'transport' cannot be null");
        }
        SecurityParameters securityParameters = new SecurityParameters();
        securityParameters.a = 1;
        ClientHandshakeState clientHandshakeState = new ClientHandshakeState();
        clientHandshakeState.a = client;
        clientHandshakeState.b = new TlsClientContextImpl(client.getCrypto(), securityParameters);
        securityParameters.clientRandom = TlsProtocol.createRandomBlock(client.shouldUseGMTUnixTime(), clientHandshakeState.b);
        securityParameters.l = client.shouldUseExtendedPadding();
        client.init(clientHandshakeState.b);
        e e2 = new e(transport, clientHandshakeState.b, client, 22);
        TlsSession tlsSession = clientHandshakeState.a.getSessionToResume();
        if (tlsSession != null && tlsSession.isResumable() && (object = tlsSession.exportSessionParameters()) != null) {
            clientHandshakeState.c = tlsSession;
            clientHandshakeState.d = object;
        }
        try {
            object = this.clientHandshake(clientHandshakeState, e2);
            return object;
        }
        catch (TlsFatalAlert tlsFatalAlert) {
            this.abortClientHandshake(clientHandshakeState, e2, tlsFatalAlert.getAlertDescription());
            throw tlsFatalAlert;
        }
        catch (IOException iOException) {
            this.abortClientHandshake(clientHandshakeState, e2, (short)80);
            throw iOException;
        }
        catch (RuntimeException runtimeException) {
            this.abortClientHandshake(clientHandshakeState, e2, (short)80);
            throw new TlsFatalAlert(80, (Throwable)runtimeException);
        }
        finally {
            securityParameters.a();
        }
    }

    protected void abortClientHandshake(ClientHandshakeState state, e recordLayer, short alertDescription) {
        recordLayer.a(alertDescription);
        this.invalidateSession(state);
    }

    protected DTLSTransport clientHandshake(ClientHandshakeState state, e recordLayer) throws IOException {
        byte[] byArray;
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        SecurityParameters securityParameters = state.b.getSecurityParameters();
        f f2 = new f(state.b, recordLayer);
        byte[] byArray2 = this.generateClientHello(state, state.a);
        recordLayer.b(ProtocolVersion.DTLSv10);
        f2.a((short)1, byArray2);
        f.a a2 = f2.d();
        while (a2.b() == 3) {
            object5 = recordLayer.b();
            if (!((ProtocolVersion)object5).isEqualOrEarlierVersionOf((ProtocolVersion)(object4 = state.b.getClientVersion()))) {
                throw new TlsFatalAlert(47);
            }
            recordLayer.a((ProtocolVersion)null);
            object3 = this.processHelloVerifyRequest(state, a2.c());
            object2 = DTLSClientProtocol.patchClientHelloWithCookie(byArray2, object3);
            f2.f();
            f2.a((short)1, (byte[])object2);
            a2 = f2.d();
        }
        if (a2.b() != 2) {
            throw new TlsFatalAlert(10);
        }
        object5 = recordLayer.b();
        this.reportServerVersion(state, (ProtocolVersion)object5);
        recordLayer.b((ProtocolVersion)object5);
        this.processServerHello(state, a2.c());
        f2.a();
        DTLSClientProtocol.applyMaxFragmentLengthExtension(recordLayer, securityParameters.getMaxFragmentLength());
        if (state.k) {
            securityParameters.d = state.b.getCrypto().adoptSecret(state.d.getMasterSecret());
            recordLayer.a(state.a.getCipher());
            object5 = this.createVerifyData(state.b, f2, true);
            this.processFinished(f2.a((short)20), (byte[])object5);
            object4 = this.createVerifyData(state.b, f2, false);
            f2.a((short)20, (byte[])object4);
            f2.e();
            securityParameters.i = (byte[])object5;
            state.b.a(state.c);
            state.a.notifyHandshakeComplete();
            return new DTLSTransport(recordLayer);
        }
        this.invalidateSession(state);
        state.c = TlsUtils.importSession(state.j, null);
        state.d = null;
        a2 = f2.d();
        if (a2.b() == 23) {
            this.processServerSupplementalData(state, a2.c());
            a2 = f2.d();
        } else {
            state.a.processServerSupplementalData(null);
        }
        state.o = state.a.getKeyExchange();
        state.o.init(state.b);
        object5 = null;
        if (a2.b() == 11) {
            object5 = this.processServerCertificate(state, a2.c());
            a2 = f2.d();
        } else {
            state.p = null;
        }
        if (object5 == null || ((Certificate)object5).isEmpty()) {
            state.m = false;
        }
        if (a2.b() == 22) {
            this.processCertificateStatus(state, a2.c());
            a2 = f2.d();
        }
        if (state.p == null) {
            state.b.getSecurityParameters().h = TlsUtils.EMPTY_BYTES;
            state.o.skipServerCredentials();
        } else {
            TlsUtils.a((Certificate)object5, state.q, state.o, state.p, state.h, state.i);
        }
        if (a2.b() == 12) {
            this.processServerKeyExchange(state, a2.c());
            a2 = f2.d();
        } else {
            state.o.skipServerKeyExchange();
        }
        if (a2.b() == 13) {
            this.processCertificateRequest(state, a2.c());
            TlsUtils.a(f2.b(), state.r.getSupportedSignatureAlgorithms());
            a2 = f2.d();
        }
        if (a2.b() == 14) {
            if (a2.c().length != 0) {
                throw new TlsFatalAlert(50);
            }
        } else {
            throw new TlsFatalAlert(10);
        }
        object4 = state.a.getClientSupplementalData();
        if (object4 != null) {
            object3 = DTLSClientProtocol.generateSupplementalData((Vector)object4);
            f2.a((short)23, (byte[])object3);
        }
        object3 = null;
        if (state.r != null) {
            state.s = TlsProtocol.validateCredentials(state.p.getClientCredentials(state.r));
            if (state.s != null) {
                object3 = state.s.getCertificate();
            }
            if (object3 == null) {
                object3 = Certificate.EMPTY_CHAIN;
            }
            object2 = DTLSClientProtocol.generateCertificate(state.b, (Certificate)object3, null);
            f2.a((short)11, (byte[])object2);
        }
        object2 = null;
        TlsStreamSigner tlsStreamSigner = null;
        if (state.s != null) {
            state.o.processClientCredentials(state.s);
            if (state.s instanceof TlsCredentialedSigner) {
                object2 = (TlsCredentialedSigner)state.s;
                tlsStreamSigner = object2.getStreamSigner();
            }
        } else {
            state.o.skipClientCredentials();
        }
        boolean bl = tlsStreamSigner != null;
        TlsUtils.b(state.b, f2.b(), bl);
        byte[] byArray3 = this.generateClientKeyExchange(state);
        f2.a((short)16, byArray3);
        TlsHandshakeHash tlsHandshakeHash = f2.c();
        securityParameters.e = TlsUtils.a(tlsHandshakeHash);
        TlsProtocol.establishMasterSecret(state.b, state.o);
        recordLayer.a(state.a.getCipher());
        if (object2 != null) {
            object = TlsUtils.a((TlsContext)state.b, (TlsCredentialedSigner)object2, tlsStreamSigner, tlsHandshakeHash);
            byArray = this.generateCertificateVerify(state, (DigitallySigned)object);
            f2.a((short)15, byArray);
        }
        object = this.createVerifyData(state.b, f2, false);
        f2.a((short)20, (byte[])object);
        if (state.n) {
            a2 = f2.d();
            if (a2.b() == 4) {
                this.processNewSessionTicket(state, a2.c());
            } else {
                throw new TlsFatalAlert(10);
            }
        }
        byArray = this.createVerifyData(state.b, f2, true);
        this.processFinished(f2.a((short)20), byArray);
        f2.e();
        state.d = new SessionParameters.Builder().setCipherSuite(securityParameters.getCipherSuite()).setCompressionAlgorithm(securityParameters.getCompressionAlgorithm()).setLocalCertificate((Certificate)object3).setMasterSecret(state.b.getCrypto().adoptSecret(securityParameters.getMasterSecret())).setNegotiatedVersion(state.b.getServerVersion()).setPeerCertificate((Certificate)object5).setPSKIdentity(securityParameters.getPSKIdentity()).setSRPIdentity(securityParameters.getSRPIdentity()).setServerExtensions(state.i).build();
        state.c = TlsUtils.importSession(state.c.getSessionID(), state.d);
        securityParameters.i = (byte[])object;
        state.b.a(state.c);
        state.a.notifyHandshakeComplete();
        return new DTLSTransport(recordLayer);
    }

    protected byte[] generateCertificateVerify(ClientHandshakeState state, DigitallySigned certificateVerify) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        certificateVerify.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateClientHello(ClientHandshakeState state, TlsClient client) throws IOException {
        boolean bl;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        ProtocolVersion protocolVersion = client.getClientVersion();
        if (!protocolVersion.isDTLS()) {
            throw new TlsFatalAlert(80);
        }
        TlsClientContextImpl tlsClientContextImpl = state.b;
        tlsClientContextImpl.setClientVersion(protocolVersion);
        TlsUtils.writeVersion(protocolVersion, byteArrayOutputStream);
        SecurityParameters securityParameters = tlsClientContextImpl.getSecurityParameters();
        byteArrayOutputStream.write(securityParameters.getClientRandom());
        byte[] byArray = TlsUtils.EMPTY_BYTES;
        if (state.c != null && ((byArray = state.c.getSessionID()) == null || byArray.length > 32)) {
            byArray = TlsUtils.EMPTY_BYTES;
        }
        TlsUtils.writeOpaque8(byArray, byteArrayOutputStream);
        TlsUtils.writeOpaque8(TlsUtils.EMPTY_BYTES, byteArrayOutputStream);
        boolean bl2 = client.isFallback();
        state.f = client.getCipherSuites();
        state.h = client.getClientExtensions();
        byte[] byArray2 = TlsUtils.getExtensionData(state.h, TlsProtocol.EXT_RenegotiationInfo);
        boolean bl3 = null == byArray2;
        boolean bl4 = bl = !Arrays.contains(state.f, 255);
        if (bl3 && bl) {
            state.f = Arrays.append(state.f, 255);
        }
        if (bl2 && !Arrays.contains(state.f, 22016)) {
            state.f = Arrays.append(state.f, 22016);
        }
        TlsUtils.writeUint16ArrayWithUint16Length(state.f, byteArrayOutputStream);
        state.g = new short[]{0};
        TlsUtils.writeUint8ArrayWithUint8Length(state.g, byteArrayOutputStream);
        if (state.h != null) {
            TlsProtocol.writeExtensions(byteArrayOutputStream, state.h);
        }
        return byteArrayOutputStream.toByteArray();
    }

    protected byte[] generateClientKeyExchange(ClientHandshakeState state) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        state.o.generateClientKeyExchange(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    protected void invalidateSession(ClientHandshakeState state) {
        if (state.d != null) {
            state.d.clear();
            state.d = null;
        }
        if (state.c != null) {
            state.c.invalidate();
            state.c = null;
        }
    }

    protected void processCertificateRequest(ClientHandshakeState state, byte[] body) throws IOException {
        if (state.p == null) {
            throw new TlsFatalAlert(40);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        state.r = CertificateRequest.parse(state.b, byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        state.r = TlsUtils.a(state.r, state.o);
    }

    protected void processCertificateStatus(ClientHandshakeState state, byte[] body) throws IOException {
        if (!state.m) {
            throw new TlsFatalAlert(10);
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        state.q = CertificateStatus.parse(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
    }

    protected byte[] processHelloVerifyRequest(ClientHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        ProtocolVersion protocolVersion = TlsUtils.readVersion(byteArrayInputStream);
        byte[] byArray = TlsUtils.readOpaque8(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        if (!protocolVersion.isEqualOrEarlierVersionOf(state.b.getClientVersion())) {
            throw new TlsFatalAlert(47);
        }
        if (!ProtocolVersion.DTLSv12.isEqualOrEarlierVersionOf(protocolVersion) && byArray.length > 32) {
            throw new TlsFatalAlert(47);
        }
        return byArray;
    }

    protected void processNewSessionTicket(ClientHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        NewSessionTicket newSessionTicket = NewSessionTicket.parse(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        state.a.notifyNewSessionTicket(newSessionTicket);
    }

    protected Certificate processServerCertificate(ClientHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Certificate certificate = Certificate.parse(state.b, byteArrayInputStream, byteArrayOutputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        state.b.getSecurityParameters().h = byteArrayOutputStream.toByteArray();
        state.p = state.a.getAuthentication();
        if (state.p == null) {
            throw new TlsFatalAlert(80);
        }
        return certificate;
    }

    protected void processServerHello(ClientHandshakeState state, byte[] body) throws IOException {
        Serializable serializable;
        Object object;
        SecurityParameters securityParameters = state.b.getSecurityParameters();
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        ProtocolVersion protocolVersion = TlsUtils.readVersion(byteArrayInputStream);
        this.reportServerVersion(state, protocolVersion);
        securityParameters.serverRandom = TlsUtils.readFully(32, (InputStream)byteArrayInputStream);
        state.j = TlsUtils.readOpaque8(byteArrayInputStream);
        if (state.j.length > 32) {
            throw new TlsFatalAlert(47);
        }
        state.a.notifySessionID(state.j);
        state.k = state.j.length > 0 && state.c != null && Arrays.areEqual(state.j, state.c.getSessionID());
        int n2 = TlsUtils.readUint16(byteArrayInputStream);
        if (!Arrays.contains(state.f, n2) || n2 == 0 || CipherSuite.isSCSV(n2) || !TlsUtils.isValidCipherSuiteForVersion(n2, state.b.getServerVersion())) {
            throw new TlsFatalAlert(47);
        }
        DTLSClientProtocol.validateSelectedCipherSuite(n2, (short)47);
        state.a.notifySelectedCipherSuite(n2);
        short s2 = TlsUtils.readUint8(byteArrayInputStream);
        if (!Arrays.contains(state.g, s2)) {
            throw new TlsFatalAlert(47);
        }
        state.a.notifySelectedCompressionMethod(s2);
        state.i = TlsProtocol.readExtensions(byteArrayInputStream);
        if (state.i != null) {
            object = state.i.keys();
            while (object.hasMoreElements()) {
                serializable = (Integer)object.nextElement();
                if (serializable.equals(TlsProtocol.EXT_RenegotiationInfo)) continue;
                if (null == TlsUtils.getExtensionData(state.h, serializable)) {
                    throw new TlsFatalAlert(110);
                }
                if (!state.k) continue;
            }
        }
        if ((object = (Object)TlsUtils.getExtensionData(state.i, TlsProtocol.EXT_RenegotiationInfo)) != null) {
            state.l = true;
            if (!Arrays.constantTimeAreEqual((byte[])object, TlsProtocol.createRenegotiationInfo(TlsUtils.EMPTY_BYTES))) {
                throw new TlsFatalAlert(40);
            }
        }
        state.a.notifySecureRenegotiation(state.l);
        object = state.h;
        serializable = state.i;
        if (state.k) {
            if (n2 != state.d.getCipherSuite() || s2 != state.d.getCompressionAlgorithm() || !protocolVersion.equals(state.d.getNegotiatedVersion())) {
                throw new TlsFatalAlert(47);
            }
            object = null;
            serializable = state.d.readServerExtensions();
        }
        securityParameters.cipherSuite = n2;
        securityParameters.b = s2;
        if (serializable != null) {
            boolean bl = TlsExtensionsUtils.hasEncryptThenMACExtension((Hashtable)serializable);
            if (bl && !TlsUtils.isBlockCipherSuite(securityParameters.getCipherSuite())) {
                throw new TlsFatalAlert(47);
            }
            securityParameters.j = bl;
            securityParameters.k = TlsExtensionsUtils.hasExtendedMasterSecretExtension((Hashtable)serializable);
            securityParameters.c = DTLSClientProtocol.evaluateMaxFragmentLengthExtension(state.k, (Hashtable)object, (Hashtable)serializable, (short)47);
            securityParameters.m = TlsExtensionsUtils.hasTruncatedHMacExtension((Hashtable)serializable);
            state.m = !state.k && TlsUtils.hasExpectedEmptyExtensionData((Hashtable)serializable, TlsExtensionsUtils.EXT_status_request, (short)47);
            boolean bl2 = state.n = !state.k && TlsUtils.hasExpectedEmptyExtensionData((Hashtable)serializable, TlsProtocol.EXT_SessionTicket, (short)47);
        }
        if (object != null) {
            state.a.processServerExtensions((Hashtable)serializable);
        }
        securityParameters.prfAlgorithm = TlsProtocol.getPRFAlgorithm(state.b, securityParameters.getCipherSuite());
        securityParameters.verifyDataLength = 12;
    }

    protected void processServerKeyExchange(ClientHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        state.o.processServerKeyExchange(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
    }

    protected void processServerSupplementalData(ClientHandshakeState state, byte[] body) throws IOException {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(body);
        Vector vector = TlsProtocol.readSupplementalDataMessage(byteArrayInputStream);
        state.a.processServerSupplementalData(vector);
    }

    protected void reportServerVersion(ClientHandshakeState state, ProtocolVersion server_version) throws IOException {
        TlsClientContextImpl tlsClientContextImpl = state.b;
        ProtocolVersion protocolVersion = tlsClientContextImpl.getServerVersion();
        if (null == protocolVersion) {
            tlsClientContextImpl.setServerVersion(server_version);
            state.a.notifyServerVersion(server_version);
        } else if (!protocolVersion.equals(server_version)) {
            throw new TlsFatalAlert(47);
        }
    }

    protected static byte[] patchClientHelloWithCookie(byte[] clientHelloBody, byte[] cookie) throws IOException {
        int n2 = 34;
        short s2 = TlsUtils.readUint8(clientHelloBody, n2);
        int n3 = n2 + 1 + s2;
        int n4 = n3 + 1;
        byte[] byArray = new byte[clientHelloBody.length + cookie.length];
        System.arraycopy(clientHelloBody, 0, byArray, 0, n3);
        TlsUtils.checkUint8(cookie.length);
        TlsUtils.writeUint8(cookie.length, byArray, n3);
        System.arraycopy(cookie, 0, byArray, n4, cookie.length);
        System.arraycopy(clientHelloBody, n4, byArray, n4 + cookie.length, clientHelloBody.length - n4);
        return byArray;
    }

    protected static class ClientHandshakeState {
        TlsClient a = null;
        TlsClientContextImpl b = null;
        TlsSession c = null;
        SessionParameters d = null;
        SessionParameters.Builder e = null;
        int[] f = null;
        short[] g = null;
        Hashtable h = null;
        Hashtable i = null;
        byte[] j = null;
        boolean k = false;
        boolean l = false;
        boolean m = false;
        boolean n = false;
        TlsKeyExchange o = null;
        TlsAuthentication p = null;
        CertificateStatus q = null;
        CertificateRequest r = null;
        TlsCredentials s = null;

        protected ClientHandshakeState() {
        }
    }
}

