/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.AbstractTlsClient;
import com.enterprisedt.bouncycastle.tls.DefaultTlsDHConfigVerifier;
import com.enterprisedt.bouncycastle.tls.DefaultTlsKeyExchangeFactory;
import com.enterprisedt.bouncycastle.tls.TlsDHConfigVerifier;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsKeyExchange;
import com.enterprisedt.bouncycastle.tls.TlsKeyExchangeFactory;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCrypto;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;

public abstract class DefaultTlsClient
extends AbstractTlsClient {
    protected static final int[] BASE_CIPHER_SUITES = new int[]{52393, 49195, 49187, 49161, 52392, 49199, 49191, 49171, 52394, 158, 103, 51, 156, 60, 47};
    protected TlsDHConfigVerifier dhConfigVerifier;
    protected int[] supportedCipherSuites;

    public DefaultTlsClient(TlsCrypto crypto) {
        this(crypto, new DefaultTlsKeyExchangeFactory(), new DefaultTlsDHConfigVerifier());
    }

    public DefaultTlsClient(TlsCrypto crypto, TlsKeyExchangeFactory keyExchangeFactory, TlsDHConfigVerifier dhConfigVerifier) {
        super(crypto, keyExchangeFactory);
        this.dhConfigVerifier = dhConfigVerifier;
        this.supportedCipherSuites = TlsUtils.getSupportedCipherSuites(crypto, BASE_CIPHER_SUITES);
    }

    @Override
    public int[] getCipherSuites() {
        return Arrays.clone(this.supportedCipherSuites);
    }

    @Override
    public TlsKeyExchange getKeyExchange() throws IOException {
        int n2 = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (n2) {
            case 7: 
            case 9: 
            case 11: {
                return this.createDHKeyExchange(n2);
            }
            case 3: 
            case 5: {
                return this.createDHEKeyExchange(n2);
            }
            case 16: 
            case 18: 
            case 20: {
                return this.createECDHKeyExchange(n2);
            }
            case 17: 
            case 19: {
                return this.createECDHEKeyExchange(n2);
            }
            case 1: {
                return this.createRSAKeyExchange();
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createDHKeyExchange(int keyExchange) throws IOException {
        return this.keyExchangeFactory.createDHKeyExchangeClient(keyExchange, this.supportedSignatureAlgorithms, this.dhConfigVerifier);
    }

    protected TlsKeyExchange createDHEKeyExchange(int keyExchange) throws IOException {
        return this.keyExchangeFactory.createDHEKeyExchangeClient(keyExchange, this.supportedSignatureAlgorithms, this.dhConfigVerifier);
    }

    protected TlsKeyExchange createECDHKeyExchange(int keyExchange) throws IOException {
        return this.keyExchangeFactory.createECDHKeyExchangeClient(keyExchange, this.supportedSignatureAlgorithms, this.createECConfigVerifier(), this.clientECPointFormats, this.serverECPointFormats);
    }

    protected TlsKeyExchange createECDHEKeyExchange(int keyExchange) throws IOException {
        return this.keyExchangeFactory.createECDHEKeyExchangeClient(keyExchange, this.supportedSignatureAlgorithms, this.createECConfigVerifier(), this.clientECPointFormats, this.serverECPointFormats);
    }

    protected TlsKeyExchange createRSAKeyExchange() throws IOException {
        return this.keyExchangeFactory.createRSAKeyExchange(this.supportedSignatureAlgorithms);
    }
}

