/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.TlsSRPConfigVerifier;
import com.enterprisedt.bouncycastle.tls.crypto.SRP6Group;
import com.enterprisedt.bouncycastle.tls.crypto.SRP6StandardGroups;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSRPConfig;
import java.math.BigInteger;
import java.util.Vector;

public class DefaultTlsSRPConfigVerifier
implements TlsSRPConfigVerifier {
    protected static final Vector DEFAULT_GROUPS = new Vector();
    protected Vector groups;

    public DefaultTlsSRPConfigVerifier() {
        this(DEFAULT_GROUPS);
    }

    public DefaultTlsSRPConfigVerifier(Vector groups) {
        this.groups = groups;
    }

    @Override
    public boolean accept(TlsSRPConfig srpConfig) {
        for (int i2 = 0; i2 < this.groups.size(); ++i2) {
            if (!this.areGroupsEqual(srpConfig, (SRP6Group)this.groups.elementAt(i2))) continue;
            return true;
        }
        return false;
    }

    protected boolean areGroupsEqual(TlsSRPConfig a2, SRP6Group b2) {
        BigInteger[] bigIntegerArray = a2.getExplicitNG();
        return this.areParametersEqual(bigIntegerArray[0], b2.getN()) && this.areParametersEqual(bigIntegerArray[1], b2.getG());
    }

    protected boolean areParametersEqual(BigInteger a2, BigInteger b2) {
        return a2 == b2 || a2.equals(b2);
    }

    static {
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_1024);
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_1536);
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_2048);
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_3072);
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_4096);
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_6144);
        DEFAULT_GROUPS.addElement(SRP6StandardGroups.rfc5054_8192);
    }
}

