/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.AbstractTlsClient;
import com.enterprisedt.bouncycastle.tls.DefaultTlsDHConfigVerifier;
import com.enterprisedt.bouncycastle.tls.DefaultTlsKeyExchangeFactory;
import com.enterprisedt.bouncycastle.tls.TlsAuthentication;
import com.enterprisedt.bouncycastle.tls.TlsDHConfigVerifier;
import com.enterprisedt.bouncycastle.tls.TlsECConfigVerifier;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsKeyExchange;
import com.enterprisedt.bouncycastle.tls.TlsKeyExchangeFactory;
import com.enterprisedt.bouncycastle.tls.TlsPSKIdentity;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCrypto;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;

public class PSKTlsClient
extends AbstractTlsClient {
    protected static final int[] BASE_CIPHER_SUITES = new int[]{52396, 49207, 49205, 52397, 170, 178, 144};
    protected TlsDHConfigVerifier dhConfigVerifier;
    protected TlsPSKIdentity pskIdentity;
    protected int[] supportedCipherSuites;

    public PSKTlsClient(TlsCrypto crypto, TlsPSKIdentity pskIdentity) {
        this(crypto, new DefaultTlsKeyExchangeFactory(), new DefaultTlsDHConfigVerifier(), pskIdentity);
    }

    public PSKTlsClient(TlsCrypto crypto, TlsKeyExchangeFactory keyExchangeFactory, TlsDHConfigVerifier dhConfigVerifier, TlsPSKIdentity pskIdentity) {
        super(crypto, keyExchangeFactory);
        this.dhConfigVerifier = dhConfigVerifier;
        this.pskIdentity = pskIdentity;
        this.supportedCipherSuites = TlsUtils.getSupportedCipherSuites(crypto, BASE_CIPHER_SUITES);
    }

    @Override
    public int[] getCipherSuites() {
        return Arrays.clone(this.supportedCipherSuites);
    }

    @Override
    public TlsKeyExchange getKeyExchange() throws IOException {
        int n2 = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (n2) {
            case 14: {
                return this.createPSKKeyExchange(n2, this.dhConfigVerifier, null);
            }
            case 24: {
                return this.createPSKKeyExchange(n2, null, this.createECConfigVerifier());
            }
            case 13: 
            case 15: {
                return this.createPSKKeyExchange(n2, null, null);
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsAuthentication getAuthentication() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createPSKKeyExchange(int keyExchange, TlsDHConfigVerifier dhConfigVerifier, TlsECConfigVerifier ecConfigVerifier) throws IOException {
        return this.keyExchangeFactory.createPSKKeyExchangeClient(keyExchange, this.supportedSignatureAlgorithms, this.pskIdentity, dhConfigVerifier, ecConfigVerifier, this.clientECPointFormats, this.serverECPointFormats);
    }
}

