/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.AbstractTlsServer;
import com.enterprisedt.bouncycastle.tls.DefaultTlsKeyExchangeFactory;
import com.enterprisedt.bouncycastle.tls.TlsCredentialedDecryptor;
import com.enterprisedt.bouncycastle.tls.TlsCredentials;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsKeyExchange;
import com.enterprisedt.bouncycastle.tls.TlsKeyExchangeFactory;
import com.enterprisedt.bouncycastle.tls.TlsPSKIdentityManager;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCrypto;
import com.enterprisedt.bouncycastle.tls.crypto.TlsDHConfig;
import com.enterprisedt.bouncycastle.tls.crypto.TlsECConfig;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;

public class PSKTlsServer
extends AbstractTlsServer {
    public static final int[] BASE_CIPHER_SUITES = new int[]{52396, 49208, 49207, 49206, 49205, 52397, 171, 170, 179, 178, 145, 144};
    protected TlsPSKIdentityManager pskIdentityManager;
    protected int[] supportedCipherSuites;

    public PSKTlsServer(TlsCrypto crypto, TlsPSKIdentityManager pskIdentityManager) {
        this(crypto, new DefaultTlsKeyExchangeFactory(), pskIdentityManager);
    }

    public PSKTlsServer(TlsCrypto crypto, TlsKeyExchangeFactory keyExchangeFactory, TlsPSKIdentityManager pskIdentityManager) {
        super(crypto, keyExchangeFactory);
        this.pskIdentityManager = pskIdentityManager;
        this.supportedCipherSuites = TlsUtils.getSupportedCipherSuites(crypto, BASE_CIPHER_SUITES);
    }

    protected TlsCredentialedDecryptor getRSAEncryptionCredentials() throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    protected int[] getCipherSuites() {
        return Arrays.clone(this.supportedCipherSuites);
    }

    @Override
    public TlsCredentials getCredentials() throws IOException {
        int n2 = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (n2) {
            case 13: 
            case 14: 
            case 24: {
                return null;
            }
            case 15: {
                return this.getRSAEncryptionCredentials();
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsKeyExchange getKeyExchange() throws IOException {
        int n2 = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (n2) {
            case 14: {
                return this.createPSKKeyExchange(n2, this.selectDHConfig(), null);
            }
            case 24: {
                return this.createPSKKeyExchange(n2, null, this.selectECConfig());
            }
            case 13: 
            case 15: {
                return this.createPSKKeyExchange(n2, null, null);
            }
        }
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createPSKKeyExchange(int keyExchange, TlsDHConfig dhConfig, TlsECConfig ecConfig) throws IOException {
        return this.keyExchangeFactory.createPSKKeyExchangeServer(keyExchange, this.supportedSignatureAlgorithms, this.pskIdentityManager, dhConfig, ecConfig, this.serverECPointFormats);
    }
}

