/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.AbstractTlsClient;
import com.enterprisedt.bouncycastle.tls.DefaultTlsKeyExchangeFactory;
import com.enterprisedt.bouncycastle.tls.DefaultTlsSRPConfigVerifier;
import com.enterprisedt.bouncycastle.tls.TlsAuthentication;
import com.enterprisedt.bouncycastle.tls.TlsExtensionsUtils;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsKeyExchange;
import com.enterprisedt.bouncycastle.tls.TlsKeyExchangeFactory;
import com.enterprisedt.bouncycastle.tls.TlsSRPConfigVerifier;
import com.enterprisedt.bouncycastle.tls.TlsSRPUtils;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCrypto;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;
import java.util.Hashtable;

public class SRPTlsClient
extends AbstractTlsClient {
    public static final int[] BASE_CIPHER_SUITES = new int[]{49182};
    protected TlsSRPConfigVerifier srpConfigVerifier;
    protected byte[] identity;
    protected byte[] password;
    protected int[] supportedCipherSuites;

    public SRPTlsClient(TlsCrypto crypto, byte[] identity, byte[] password) {
        this(crypto, new DefaultTlsKeyExchangeFactory(), new DefaultTlsSRPConfigVerifier(), identity, password);
    }

    public SRPTlsClient(TlsCrypto crypto, TlsKeyExchangeFactory keyExchangeFactory, TlsSRPConfigVerifier srpConfigVerifier, byte[] identity, byte[] password) {
        super(crypto, keyExchangeFactory);
        this.srpConfigVerifier = srpConfigVerifier;
        this.identity = Arrays.clone(identity);
        this.password = Arrays.clone(password);
        this.supportedCipherSuites = TlsUtils.getSupportedCipherSuites(crypto, BASE_CIPHER_SUITES);
    }

    protected boolean requireSRPServerExtension() {
        return false;
    }

    @Override
    public int[] getCipherSuites() {
        return Arrays.clone(this.supportedCipherSuites);
    }

    @Override
    public Hashtable getClientExtensions() throws IOException {
        Hashtable hashtable = TlsExtensionsUtils.ensureExtensionsInitialised(super.getClientExtensions());
        TlsSRPUtils.addSRPExtension(hashtable, this.identity);
        return hashtable;
    }

    @Override
    public void processServerExtensions(Hashtable serverExtensions) throws IOException {
        if (!TlsUtils.hasExpectedEmptyExtensionData(serverExtensions, TlsSRPUtils.EXT_SRP, (short)47) && this.requireSRPServerExtension()) {
            throw new TlsFatalAlert(47);
        }
        super.processServerExtensions(serverExtensions);
    }

    @Override
    public TlsKeyExchange getKeyExchange() throws IOException {
        int n2 = TlsUtils.getKeyExchangeAlgorithm(this.selectedCipherSuite);
        switch (n2) {
            case 21: 
            case 22: 
            case 23: {
                return this.createSRPKeyExchange(n2);
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsAuthentication getAuthentication() throws IOException {
        throw new TlsFatalAlert(80);
    }

    protected TlsKeyExchange createSRPKeyExchange(int keyExchange) throws IOException {
        return this.keyExchangeFactory.createSRPKeyExchangeClient(keyExchange, this.supportedSignatureAlgorithms, this.srpConfigVerifier, this.identity, this.password);
    }
}

