/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.Certificate;
import com.enterprisedt.bouncycastle.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.tls.TlsProtocol;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSecret;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Hashtable;

public final class SessionParameters {
    private int a;
    private short b;
    private Certificate c;
    private TlsSecret d;
    private ProtocolVersion e;
    private Certificate f;
    private byte[] g = null;
    private byte[] h = null;
    private byte[] i;

    private SessionParameters(int cipherSuite, short compressionAlgorithm, Certificate localCertificate, TlsSecret masterSecret, ProtocolVersion negotiatedVersion, Certificate peerCertificate, byte[] pskIdentity, byte[] srpIdentity, byte[] encodedServerExtensions) {
        this.a = cipherSuite;
        this.b = compressionAlgorithm;
        this.c = localCertificate;
        this.d = masterSecret;
        this.e = negotiatedVersion;
        this.f = peerCertificate;
        this.g = Arrays.clone(pskIdentity);
        this.h = Arrays.clone(srpIdentity);
        this.i = encodedServerExtensions;
    }

    public void clear() {
        if (this.d != null) {
            this.d.destroy();
        }
    }

    public SessionParameters copy() {
        return new SessionParameters(this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h, this.i);
    }

    public int getCipherSuite() {
        return this.a;
    }

    public short getCompressionAlgorithm() {
        return this.b;
    }

    public Certificate getLocalCertificate() {
        return this.c;
    }

    public TlsSecret getMasterSecret() {
        return this.d;
    }

    public ProtocolVersion getNegotiatedVersion() {
        return this.e;
    }

    public Certificate getPeerCertificate() {
        return this.f;
    }

    public byte[] getPskIdentity() {
        return this.g;
    }

    public byte[] getPSKIdentity() {
        return this.g;
    }

    public byte[] getSRPIdentity() {
        return this.h;
    }

    public Hashtable readServerExtensions() throws IOException {
        if (this.i == null) {
            return null;
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(this.i);
        return TlsProtocol.readExtensions(byteArrayInputStream);
    }

    public static final class Builder {
        private int a = -1;
        private short b = (short)-1;
        private Certificate c = null;
        private TlsSecret d = null;
        private ProtocolVersion e;
        private Certificate f = null;
        private byte[] g = null;
        private byte[] h = null;
        private byte[] i = null;

        public SessionParameters build() {
            this.a(this.a >= 0, "cipherSuite");
            this.a(this.b >= 0, "compressionAlgorithm");
            this.a(this.d != null, "masterSecret");
            return new SessionParameters(this.a, this.b, this.c, this.d, this.e, this.f, this.g, this.h, this.i);
        }

        public Builder setCipherSuite(int cipherSuite) {
            this.a = cipherSuite;
            return this;
        }

        public Builder setCompressionAlgorithm(short compressionAlgorithm) {
            this.b = compressionAlgorithm;
            return this;
        }

        public Builder setLocalCertificate(Certificate localCertificate) {
            this.c = localCertificate;
            return this;
        }

        public Builder setMasterSecret(TlsSecret masterSecret) {
            this.d = masterSecret;
            return this;
        }

        public Builder setNegotiatedVersion(ProtocolVersion negotiatedVersion) {
            this.e = negotiatedVersion;
            return this;
        }

        public Builder setPeerCertificate(Certificate peerCertificate) {
            this.f = peerCertificate;
            return this;
        }

        public Builder setPskIdentity(byte[] pskIdentity) {
            this.g = pskIdentity;
            return this;
        }

        public Builder setPSKIdentity(byte[] pskIdentity) {
            this.g = pskIdentity;
            return this;
        }

        public Builder setSRPIdentity(byte[] srpIdentity) {
            this.h = srpIdentity;
            return this;
        }

        public Builder setServerExtensions(Hashtable serverExtensions) throws IOException {
            if (serverExtensions == null) {
                this.i = null;
            } else {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
                TlsProtocol.writeExtensions(byteArrayOutputStream, serverExtensions);
                this.i = byteArrayOutputStream.toByteArray();
            }
            return this;
        }

        private void a(boolean bl, String string) {
            if (!bl) {
                throw new IllegalStateException("Required session parameter '" + string + "' not configured");
            }
        }
    }
}

