/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.Certificate;
import com.enterprisedt.bouncycastle.tls.DigitallySigned;
import com.enterprisedt.bouncycastle.tls.TlsCredentialedSigner;
import com.enterprisedt.bouncycastle.tls.TlsCredentials;
import com.enterprisedt.bouncycastle.tls.TlsDHConfigVerifier;
import com.enterprisedt.bouncycastle.tls.TlsDHKeyExchange;
import com.enterprisedt.bouncycastle.tls.TlsDHUtils;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsDHConfig;
import com.enterprisedt.bouncycastle.tls.crypto.TlsVerifier;
import com.enterprisedt.bouncycastle.tls.i;
import com.enterprisedt.bouncycastle.util.io.TeeInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class TlsDHEKeyExchange
extends TlsDHKeyExchange {
    protected TlsCredentialedSigner serverCredentials = null;
    protected TlsVerifier verifier = null;

    private static int a(int n2) {
        switch (n2) {
            case 3: 
            case 5: {
                return n2;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsDHEKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, TlsDHConfigVerifier dhConfigVerifier) {
        super(TlsDHEKeyExchange.a(keyExchange), supportedSignatureAlgorithms, dhConfigVerifier);
    }

    public TlsDHEKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, TlsDHConfig dhConfig) {
        super(TlsDHEKeyExchange.a(keyExchange), supportedSignatureAlgorithms, dhConfig);
    }

    @Override
    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        if (!(serverCredentials instanceof TlsCredentialedSigner)) {
            throw new TlsFatalAlert(80);
        }
        this.serverCredentials = (TlsCredentialedSigner)serverCredentials;
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        if (serverCertificate.isEmpty()) {
            throw new TlsFatalAlert(42);
        }
        this.checkServerCertSigAlg(serverCertificate);
        this.verifier = serverCertificate.getCertificateAt(0).createVerifier(TlsUtils.getSignatureAlgorithm(this.keyExchange));
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        if (this.dhConfig == null) {
            throw new TlsFatalAlert(80);
        }
        i i2 = new i();
        TlsDHUtils.writeDHConfig(this.dhConfig, i2);
        this.agreement = this.context.getCrypto().createDHDomain(this.dhConfig).createDH();
        this.generateEphemeral(i2);
        DigitallySigned digitallySigned = TlsUtils.a(this.context, this.serverCredentials, i2);
        digitallySigned.encode(i2);
        return i2.toByteArray();
    }

    @Override
    public void processServerKeyExchange(InputStream input) throws IOException {
        i i2 = new i();
        TeeInputStream teeInputStream = new TeeInputStream(input, i2);
        this.dhConfig = TlsDHUtils.receiveDHConfig(this.dhConfigVerifier, teeInputStream);
        byte[] byArray = TlsUtils.readOpaque16(teeInputStream);
        DigitallySigned digitallySigned = this.parseSignature(input);
        TlsUtils.a(this.context, this.verifier, i2, digitallySigned);
        this.agreement = this.context.getCrypto().createDHDomain(this.dhConfig).createDH();
        this.processEphemeral(byArray);
    }

    @Override
    public short[] getClientCertificateTypes() {
        return new short[]{2, 64, 1};
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        if (!(clientCredentials instanceof TlsCredentialedSigner)) {
            throw new TlsFatalAlert(80);
        }
    }
}

