/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.Certificate;
import com.enterprisedt.bouncycastle.tls.DigitallySigned;
import com.enterprisedt.bouncycastle.tls.TlsCredentialedSigner;
import com.enterprisedt.bouncycastle.tls.TlsCredentials;
import com.enterprisedt.bouncycastle.tls.TlsECCUtils;
import com.enterprisedt.bouncycastle.tls.TlsECConfigVerifier;
import com.enterprisedt.bouncycastle.tls.TlsECDHKeyExchange;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsECConfig;
import com.enterprisedt.bouncycastle.tls.crypto.TlsVerifier;
import com.enterprisedt.bouncycastle.tls.i;
import com.enterprisedt.bouncycastle.util.io.TeeInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class TlsECDHEKeyExchange
extends TlsECDHKeyExchange {
    protected TlsCredentialedSigner serverCredentials = null;
    protected TlsVerifier verifier = null;

    private static int a(int n2) {
        switch (n2) {
            case 17: 
            case 19: {
                return n2;
            }
        }
        throw new IllegalArgumentException("unsupported key exchange algorithm");
    }

    public TlsECDHEKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, TlsECConfigVerifier ecConfigVerifier, short[] clientECPointFormats, short[] serverECPointFormats) {
        super(TlsECDHEKeyExchange.a(keyExchange), supportedSignatureAlgorithms, ecConfigVerifier, clientECPointFormats, serverECPointFormats);
    }

    public TlsECDHEKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, TlsECConfig ecConfig, short[] serverECPointFormats) {
        super(TlsECDHEKeyExchange.a(keyExchange), supportedSignatureAlgorithms, ecConfig, serverECPointFormats);
    }

    @Override
    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        if (!(serverCredentials instanceof TlsCredentialedSigner)) {
            throw new TlsFatalAlert(80);
        }
        this.serverCredentials = (TlsCredentialedSigner)serverCredentials;
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        if (serverCertificate.isEmpty()) {
            throw new TlsFatalAlert(42);
        }
        this.checkServerCertSigAlg(serverCertificate);
        this.verifier = serverCertificate.getCertificateAt(0).createVerifier(TlsUtils.getSignatureAlgorithm(this.keyExchange));
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        i i2 = new i();
        TlsECCUtils.writeECConfig(this.ecConfig, i2);
        this.agreement = this.context.getCrypto().createECDomain(this.ecConfig).createECDH();
        this.generateEphemeral(i2);
        DigitallySigned digitallySigned = TlsUtils.a(this.context, this.serverCredentials, i2);
        digitallySigned.encode(i2);
        return i2.toByteArray();
    }

    @Override
    public void processServerKeyExchange(InputStream input) throws IOException {
        i i2 = new i();
        TeeInputStream teeInputStream = new TeeInputStream(input, i2);
        this.ecConfig = TlsECCUtils.receiveECConfig(this.ecConfigVerifier, this.serverECPointFormats, teeInputStream);
        byte[] byArray = TlsUtils.readOpaque8(teeInputStream);
        DigitallySigned digitallySigned = this.parseSignature(input);
        TlsUtils.a(this.context, this.verifier, i2, digitallySigned);
        this.agreement = this.context.getCrypto().createECDomain(this.ecConfig).createECDH();
        this.processEphemeral(this.clientECPointFormats, byArray);
    }

    @Override
    public short[] getClientCertificateTypes() {
        return new short[]{2, 64, 1};
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        if (!(clientCredentials instanceof TlsCredentialedSigner)) {
            throw new TlsFatalAlert(80);
        }
    }
}

