/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.CertificateStatusRequest;
import com.enterprisedt.bouncycastle.tls.HeartbeatExtension;
import com.enterprisedt.bouncycastle.tls.ProtocolName;
import com.enterprisedt.bouncycastle.tls.ServerNameList;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsProtocol;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.TrustedAuthority;
import com.enterprisedt.bouncycastle.util.Integers;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.Vector;

public class TlsExtensionsUtils {
    public static final Integer EXT_application_layer_protocol_negotiation = Integers.valueOf(16);
    public static final Integer EXT_client_certificate_type = Integers.valueOf(19);
    public static final Integer EXT_client_certificate_url = Integers.valueOf(2);
    public static final Integer EXT_encrypt_then_mac = Integers.valueOf(22);
    public static final Integer EXT_extended_master_secret = Integers.valueOf(23);
    public static final Integer EXT_heartbeat = Integers.valueOf(15);
    public static final Integer EXT_max_fragment_length = Integers.valueOf(1);
    public static final Integer EXT_padding = Integers.valueOf(21);
    public static final Integer EXT_server_certificate_type = Integers.valueOf(20);
    public static final Integer EXT_server_name = Integers.valueOf(0);
    public static final Integer EXT_status_request = Integers.valueOf(5);
    public static final Integer EXT_supported_groups = Integers.valueOf(10);
    public static final Integer EXT_truncated_hmac = Integers.valueOf(4);
    public static final Integer EXT_trusted_ca_keys = Integers.valueOf(3);

    public static Hashtable ensureExtensionsInitialised(Hashtable extensions) {
        return extensions == null ? new Hashtable() : extensions;
    }

    public static void addALPNExtensionClient(Hashtable extensions, Vector protocolNameList) throws IOException {
        extensions.put(EXT_application_layer_protocol_negotiation, TlsExtensionsUtils.createALPNExtensionClient(protocolNameList));
    }

    public static void addALPNExtensionServer(Hashtable extensions, ProtocolName protocolName) throws IOException {
        extensions.put(EXT_application_layer_protocol_negotiation, TlsExtensionsUtils.createALPNExtensionServer(protocolName));
    }

    public static void addClientCertificateTypeExtensionClient(Hashtable extensions, short[] certificateTypes) throws IOException {
        extensions.put(EXT_client_certificate_type, TlsExtensionsUtils.createCertificateTypeExtensionClient(certificateTypes));
    }

    public static void addClientCertificateTypeExtensionServer(Hashtable extensions, short certificateType) throws IOException {
        extensions.put(EXT_client_certificate_type, TlsExtensionsUtils.createCertificateTypeExtensionServer(certificateType));
    }

    public static void addClientCertificateURLExtension(Hashtable extensions) {
        extensions.put(EXT_client_certificate_url, TlsExtensionsUtils.createClientCertificateURLExtension());
    }

    public static void addEncryptThenMACExtension(Hashtable extensions) {
        extensions.put(EXT_encrypt_then_mac, TlsExtensionsUtils.createEncryptThenMACExtension());
    }

    public static void addExtendedMasterSecretExtension(Hashtable extensions) {
        extensions.put(EXT_extended_master_secret, TlsExtensionsUtils.createExtendedMasterSecretExtension());
    }

    public static void addHeartbeatExtension(Hashtable extensions, HeartbeatExtension heartbeatExtension) throws IOException {
        extensions.put(EXT_heartbeat, TlsExtensionsUtils.createHeartbeatExtension(heartbeatExtension));
    }

    public static void addMaxFragmentLengthExtension(Hashtable extensions, short maxFragmentLength) throws IOException {
        extensions.put(EXT_max_fragment_length, TlsExtensionsUtils.createMaxFragmentLengthExtension(maxFragmentLength));
    }

    public static void addPaddingExtension(Hashtable extensions, int dataLength) throws IOException {
        extensions.put(EXT_padding, TlsExtensionsUtils.createPaddingExtension(dataLength));
    }

    public static void addServerCertificateTypeExtensionClient(Hashtable extensions, short[] certificateTypes) throws IOException {
        extensions.put(EXT_server_certificate_type, TlsExtensionsUtils.createCertificateTypeExtensionClient(certificateTypes));
    }

    public static void addServerCertificateTypeExtensionServer(Hashtable extensions, short certificateType) throws IOException {
        extensions.put(EXT_server_certificate_type, TlsExtensionsUtils.createCertificateTypeExtensionServer(certificateType));
    }

    public static void addServerNameExtension(Hashtable extensions, ServerNameList serverNameList) throws IOException {
        extensions.put(EXT_server_name, TlsExtensionsUtils.createServerNameExtension(serverNameList));
    }

    public static void addStatusRequestExtension(Hashtable extensions, CertificateStatusRequest statusRequest) throws IOException {
        extensions.put(EXT_status_request, TlsExtensionsUtils.createStatusRequestExtension(statusRequest));
    }

    public static void addSupportedGroupsExtension(Hashtable extensions, Vector namedGroups) throws IOException {
        extensions.put(EXT_supported_groups, TlsExtensionsUtils.createSupportedGroupsExtension(namedGroups));
    }

    public static void addTruncatedHMacExtension(Hashtable extensions) {
        extensions.put(EXT_truncated_hmac, TlsExtensionsUtils.createTruncatedHMacExtension());
    }

    public static void addTrustedCAKeysExtensionClient(Hashtable extensions, Vector trustedAuthoritiesList) throws IOException {
        extensions.put(EXT_trusted_ca_keys, TlsExtensionsUtils.createTrustedCAKeysExtensionClient(trustedAuthoritiesList));
    }

    public static void addTrustedCAKeysExtensionServer(Hashtable extensions) {
        extensions.put(EXT_trusted_ca_keys, TlsExtensionsUtils.createTrustedCAKeysExtensionServer());
    }

    public static Vector getALPNExtensionClient(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_application_layer_protocol_negotiation);
        return byArray == null ? null : TlsExtensionsUtils.readALPNExtensionClient(byArray);
    }

    public static ProtocolName getALPNExtensionServer(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_application_layer_protocol_negotiation);
        return byArray == null ? null : TlsExtensionsUtils.readALPNExtensionServer(byArray);
    }

    public static short[] getClientCertificateTypeExtensionClient(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_client_certificate_type);
        return byArray == null ? null : TlsExtensionsUtils.readCertificateTypeExtensionClient(byArray);
    }

    public static short getClientCertificateTypeExtensionServer(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_client_certificate_type);
        return byArray == null ? (short)-1 : (short)TlsExtensionsUtils.readCertificateTypeExtensionServer(byArray);
    }

    public static HeartbeatExtension getHeartbeatExtension(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_heartbeat);
        return byArray == null ? null : TlsExtensionsUtils.readHeartbeatExtension(byArray);
    }

    public static short getMaxFragmentLengthExtension(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_max_fragment_length);
        return byArray == null ? (short)-1 : (short)TlsExtensionsUtils.readMaxFragmentLengthExtension(byArray);
    }

    public static int getPaddingExtension(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_padding);
        return byArray == null ? -1 : TlsExtensionsUtils.readPaddingExtension(byArray);
    }

    public static short[] getServerCertificateTypeExtensionClient(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_server_certificate_type);
        return byArray == null ? null : TlsExtensionsUtils.readCertificateTypeExtensionClient(byArray);
    }

    public static short getServerCertificateTypeExtensionServer(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_server_certificate_type);
        return byArray == null ? (short)-1 : (short)TlsExtensionsUtils.readCertificateTypeExtensionServer(byArray);
    }

    public static ServerNameList getServerNameExtension(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_server_name);
        return byArray == null ? null : TlsExtensionsUtils.readServerNameExtension(byArray);
    }

    public static CertificateStatusRequest getStatusRequestExtension(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_status_request);
        return byArray == null ? null : TlsExtensionsUtils.readStatusRequestExtension(byArray);
    }

    public static int[] getSupportedGroupsExtension(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_supported_groups);
        return byArray == null ? null : TlsExtensionsUtils.readSupportedGroupsExtension(byArray);
    }

    public static Vector getTrustedCAKeysExtensionClient(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_trusted_ca_keys);
        return byArray == null ? null : TlsExtensionsUtils.readTrustedCAKeysExtensionClient(byArray);
    }

    public static boolean hasClientCertificateURLExtension(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_client_certificate_url);
        return byArray == null ? false : TlsExtensionsUtils.readClientCertificateURLExtension(byArray);
    }

    public static boolean hasEncryptThenMACExtension(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_encrypt_then_mac);
        return byArray == null ? false : TlsExtensionsUtils.readEncryptThenMACExtension(byArray);
    }

    public static boolean hasExtendedMasterSecretExtension(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_extended_master_secret);
        return byArray == null ? false : TlsExtensionsUtils.readExtendedMasterSecretExtension(byArray);
    }

    public static boolean hasTruncatedHMacExtension(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_truncated_hmac);
        return byArray == null ? false : TlsExtensionsUtils.readTruncatedHMacExtension(byArray);
    }

    public static boolean hasTrustedCAKeysExtensionServer(Hashtable extensions) throws IOException {
        byte[] byArray = TlsUtils.getExtensionData(extensions, EXT_trusted_ca_keys);
        return byArray == null ? false : TlsExtensionsUtils.readTrustedCAKeysExtensionServer(byArray);
    }

    public static byte[] createALPNExtensionClient(Vector protocolNameList) throws IOException {
        Object object;
        int n2;
        if (protocolNameList == null || protocolNameList.size() < 1) {
            throw new TlsFatalAlert(80);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.writeUint16(0, byteArrayOutputStream);
        for (n2 = 0; n2 < protocolNameList.size(); ++n2) {
            object = (ProtocolName)protocolNameList.elementAt(n2);
            ((ProtocolName)object).encode(byteArrayOutputStream);
        }
        n2 = byteArrayOutputStream.size() - 2;
        TlsUtils.checkUint16(n2);
        object = byteArrayOutputStream.toByteArray();
        TlsUtils.writeUint16(n2, (byte[])object, 0);
        return object;
    }

    public static byte[] createALPNExtensionServer(ProtocolName protocolName) throws IOException {
        Vector<ProtocolName> vector = new Vector<ProtocolName>();
        vector.addElement(protocolName);
        return TlsExtensionsUtils.createALPNExtensionClient(vector);
    }

    public static byte[] createCertificateTypeExtensionClient(short[] certificateTypes) throws IOException {
        if (certificateTypes == null || certificateTypes.length < 1 || certificateTypes.length > 255) {
            throw new TlsFatalAlert(80);
        }
        return TlsUtils.encodeUint8ArrayWithUint8Length(certificateTypes);
    }

    public static byte[] createCertificateTypeExtensionServer(short certificateType) throws IOException {
        return TlsUtils.encodeUint8(certificateType);
    }

    public static byte[] createClientCertificateURLExtension() {
        return TlsExtensionsUtils.createEmptyExtensionData();
    }

    public static byte[] createEmptyExtensionData() {
        return TlsUtils.EMPTY_BYTES;
    }

    public static byte[] createEncryptThenMACExtension() {
        return TlsExtensionsUtils.createEmptyExtensionData();
    }

    public static byte[] createExtendedMasterSecretExtension() {
        return TlsExtensionsUtils.createEmptyExtensionData();
    }

    public static byte[] createHeartbeatExtension(HeartbeatExtension heartbeatExtension) throws IOException {
        if (heartbeatExtension == null) {
            throw new TlsFatalAlert(80);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        heartbeatExtension.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] createMaxFragmentLengthExtension(short maxFragmentLength) throws IOException {
        return TlsUtils.encodeUint8(maxFragmentLength);
    }

    public static byte[] createPaddingExtension(int dataLength) throws IOException {
        TlsUtils.checkUint16(dataLength);
        return new byte[dataLength];
    }

    public static byte[] createServerNameExtension(ServerNameList serverNameList) throws IOException {
        if (serverNameList == null) {
            throw new TlsFatalAlert(80);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        serverNameList.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] createStatusRequestExtension(CertificateStatusRequest statusRequest) throws IOException {
        if (statusRequest == null) {
            throw new TlsFatalAlert(80);
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        statusRequest.encode(byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] createSupportedGroupsExtension(Vector namedGroups) throws IOException {
        if (namedGroups == null || namedGroups.isEmpty()) {
            throw new TlsFatalAlert(80);
        }
        int n2 = namedGroups.size();
        int[] nArray = new int[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            nArray[i2] = (Integer)namedGroups.elementAt(i2);
        }
        return TlsUtils.encodeUint16ArrayWithUint16Length(nArray);
    }

    public static byte[] createTruncatedHMacExtension() {
        return TlsExtensionsUtils.createEmptyExtensionData();
    }

    public static byte[] createTrustedCAKeysExtensionClient(Vector trustedAuthoritiesList) throws IOException {
        Object object;
        int n2;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        TlsUtils.writeUint16(0, byteArrayOutputStream);
        for (n2 = 0; n2 < trustedAuthoritiesList.size(); ++n2) {
            object = (TrustedAuthority)trustedAuthoritiesList.elementAt(n2);
            ((TrustedAuthority)object).encode(byteArrayOutputStream);
        }
        n2 = byteArrayOutputStream.size() - 2;
        TlsUtils.checkUint16(n2);
        object = byteArrayOutputStream.toByteArray();
        TlsUtils.writeUint16(n2, (byte[])object, 0);
        return object;
    }

    public static byte[] createTrustedCAKeysExtensionServer() {
        return TlsExtensionsUtils.createEmptyExtensionData();
    }

    private static boolean a(byte[] byArray) throws IOException {
        if (byArray == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        if (byArray.length != 0) {
            throw new TlsFatalAlert(47);
        }
        return true;
    }

    public static Vector readALPNExtensionClient(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(extensionData);
        int n2 = TlsUtils.readUint16(byteArrayInputStream);
        if (n2 != extensionData.length - 2) {
            throw new TlsFatalAlert(50);
        }
        Vector<ProtocolName> vector = new Vector<ProtocolName>();
        while (byteArrayInputStream.available() > 0) {
            ProtocolName protocolName = ProtocolName.parse(byteArrayInputStream);
            vector.addElement(protocolName);
        }
        return vector;
    }

    public static ProtocolName readALPNExtensionServer(byte[] extensionData) throws IOException {
        Vector vector = TlsExtensionsUtils.readALPNExtensionClient(extensionData);
        if (vector.size() != 1) {
            throw new TlsFatalAlert(50);
        }
        return (ProtocolName)vector.elementAt(0);
    }

    public static short[] readCertificateTypeExtensionClient(byte[] extensionData) throws IOException {
        short[] sArray = TlsUtils.decodeUint8ArrayWithUint8Length(extensionData);
        if (sArray.length < 1) {
            throw new TlsFatalAlert(50);
        }
        return sArray;
    }

    public static short readCertificateTypeExtensionServer(byte[] extensionData) throws IOException {
        return TlsUtils.decodeUint8(extensionData);
    }

    public static boolean readClientCertificateURLExtension(byte[] extensionData) throws IOException {
        return TlsExtensionsUtils.a(extensionData);
    }

    public static boolean readEncryptThenMACExtension(byte[] extensionData) throws IOException {
        return TlsExtensionsUtils.a(extensionData);
    }

    public static boolean readExtendedMasterSecretExtension(byte[] extensionData) throws IOException {
        return TlsExtensionsUtils.a(extensionData);
    }

    public static HeartbeatExtension readHeartbeatExtension(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(extensionData);
        HeartbeatExtension heartbeatExtension = HeartbeatExtension.parse(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        return heartbeatExtension;
    }

    public static short readMaxFragmentLengthExtension(byte[] extensionData) throws IOException {
        return TlsUtils.decodeUint8(extensionData);
    }

    public static int readPaddingExtension(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        for (int i2 = 0; i2 < extensionData.length; ++i2) {
            if (extensionData[i2] == 0) continue;
            throw new TlsFatalAlert(47);
        }
        return extensionData.length;
    }

    public static ServerNameList readServerNameExtension(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(extensionData);
        ServerNameList serverNameList = ServerNameList.parse(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        return serverNameList;
    }

    public static CertificateStatusRequest readStatusRequestExtension(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(extensionData);
        CertificateStatusRequest certificateStatusRequest = CertificateStatusRequest.parse(byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        return certificateStatusRequest;
    }

    public static int[] readSupportedGroupsExtension(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(extensionData);
        int n2 = TlsUtils.readUint16(byteArrayInputStream);
        if (n2 < 2 || (n2 & 1) != 0) {
            throw new TlsFatalAlert(50);
        }
        int[] nArray = TlsUtils.readUint16Array(n2 / 2, byteArrayInputStream);
        TlsProtocol.assertEmpty(byteArrayInputStream);
        return nArray;
    }

    public static boolean readTruncatedHMacExtension(byte[] extensionData) throws IOException {
        return TlsExtensionsUtils.a(extensionData);
    }

    public static Vector readTrustedCAKeysExtensionClient(byte[] extensionData) throws IOException {
        if (extensionData == null) {
            throw new IllegalArgumentException("'extensionData' cannot be null");
        }
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(extensionData);
        int n2 = TlsUtils.readUint16(byteArrayInputStream);
        if (n2 != extensionData.length - 2) {
            throw new TlsFatalAlert(50);
        }
        Vector<TrustedAuthority> vector = new Vector<TrustedAuthority>();
        while (byteArrayInputStream.available() > 0) {
            TrustedAuthority trustedAuthority = TrustedAuthority.parse(byteArrayInputStream);
            vector.addElement(trustedAuthority);
        }
        return vector;
    }

    public static boolean readTrustedCAKeysExtensionServer(byte[] extensionData) throws IOException {
        return TlsExtensionsUtils.a(extensionData);
    }
}

