/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls;

import com.enterprisedt.bouncycastle.tls.AbstractTlsKeyExchange;
import com.enterprisedt.bouncycastle.tls.Certificate;
import com.enterprisedt.bouncycastle.tls.TlsCredentialedDecryptor;
import com.enterprisedt.bouncycastle.tls.TlsCredentials;
import com.enterprisedt.bouncycastle.tls.TlsDHConfigVerifier;
import com.enterprisedt.bouncycastle.tls.TlsDHUtils;
import com.enterprisedt.bouncycastle.tls.TlsECCUtils;
import com.enterprisedt.bouncycastle.tls.TlsECConfigVerifier;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsPSKIdentity;
import com.enterprisedt.bouncycastle.tls.TlsPSKIdentityManager;
import com.enterprisedt.bouncycastle.tls.TlsRSAUtils;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsAgreement;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCertificate;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCryptoParameters;
import com.enterprisedt.bouncycastle.tls.crypto.TlsDHConfig;
import com.enterprisedt.bouncycastle.tls.crypto.TlsECConfig;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSecret;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Vector;

public class TlsPSKKeyExchange
extends AbstractTlsKeyExchange {
    protected TlsPSKIdentity pskIdentity;
    protected TlsPSKIdentityManager pskIdentityManager;
    protected TlsDHConfigVerifier dhConfigVerifier;
    protected TlsECConfigVerifier ecConfigVerifier;
    protected short[] clientECPointFormats;
    protected short[] serverECPointFormats;
    protected byte[] psk_identity_hint = null;
    protected byte[] psk = null;
    protected TlsDHConfig dhConfig;
    protected TlsECConfig ecConfig;
    protected TlsAgreement agreement;
    protected TlsCredentialedDecryptor serverCredentials = null;
    protected TlsCertificate serverCertificate;
    protected TlsSecret preMasterSecret;

    public TlsPSKKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, TlsPSKIdentity pskIdentity, TlsDHConfigVerifier dhConfigVerifier, TlsECConfigVerifier ecConfigVerifier, short[] clientECPointFormats, short[] serverECPointFormats) {
        this(keyExchange, supportedSignatureAlgorithms, pskIdentity, null, dhConfigVerifier, null, ecConfigVerifier, null, clientECPointFormats, serverECPointFormats);
    }

    public TlsPSKKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, TlsPSKIdentity pskIdentity, TlsPSKIdentityManager pskIdentityManager, TlsDHConfig dhConfig, TlsECConfig ecConfig, short[] serverECPointFormats) {
        this(keyExchange, supportedSignatureAlgorithms, pskIdentity, pskIdentityManager, null, dhConfig, null, ecConfig, null, serverECPointFormats);
    }

    private TlsPSKKeyExchange(int keyExchange, Vector supportedSignatureAlgorithms, TlsPSKIdentity pskIdentity, TlsPSKIdentityManager pskIdentityManager, TlsDHConfigVerifier dhConfigVerifier, TlsDHConfig dhConfig, TlsECConfigVerifier ecConfigVerifier, TlsECConfig ecConfig, short[] clientECPointFormats, short[] serverECPointFormats) {
        super(keyExchange, supportedSignatureAlgorithms);
        switch (keyExchange) {
            case 13: 
            case 14: 
            case 15: 
            case 24: {
                break;
            }
            default: {
                throw new IllegalArgumentException("unsupported key exchange algorithm");
            }
        }
        this.pskIdentity = pskIdentity;
        this.pskIdentityManager = pskIdentityManager;
        this.dhConfigVerifier = dhConfigVerifier;
        this.dhConfig = dhConfig;
        this.ecConfigVerifier = ecConfigVerifier;
        this.ecConfig = ecConfig;
        this.clientECPointFormats = clientECPointFormats;
        this.serverECPointFormats = serverECPointFormats;
    }

    @Override
    public void skipServerCredentials() throws IOException {
        if (this.keyExchange == 15) {
            throw new TlsFatalAlert(80);
        }
    }

    @Override
    public void processServerCredentials(TlsCredentials serverCredentials) throws IOException {
        if (this.keyExchange != 15) {
            throw new TlsFatalAlert(80);
        }
        if (!(serverCredentials instanceof TlsCredentialedDecryptor)) {
            throw new TlsFatalAlert(80);
        }
        this.serverCredentials = (TlsCredentialedDecryptor)serverCredentials;
    }

    @Override
    public void processServerCertificate(Certificate serverCertificate) throws IOException {
        if (this.keyExchange != 15) {
            throw new TlsFatalAlert(10);
        }
        if (serverCertificate.isEmpty()) {
            throw new TlsFatalAlert(42);
        }
        this.checkServerCertSigAlg(serverCertificate);
        this.serverCertificate = serverCertificate.getCertificateAt(0).useInRole(0, this.keyExchange);
    }

    @Override
    public byte[] generateServerKeyExchange() throws IOException {
        this.psk_identity_hint = this.pskIdentityManager.getHint();
        if (this.psk_identity_hint == null && !this.requiresServerKeyExchange()) {
            return null;
        }
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        if (this.psk_identity_hint == null) {
            TlsUtils.writeOpaque16(TlsUtils.EMPTY_BYTES, byteArrayOutputStream);
        } else {
            TlsUtils.writeOpaque16(this.psk_identity_hint, byteArrayOutputStream);
        }
        if (this.keyExchange == 14) {
            if (this.dhConfig == null) {
                throw new TlsFatalAlert(80);
            }
            TlsDHUtils.writeDHConfig(this.dhConfig, byteArrayOutputStream);
            this.agreement = this.context.getCrypto().createDHDomain(this.dhConfig).createDH();
            this.generateEphemeralDH(byteArrayOutputStream);
        } else if (this.keyExchange == 24) {
            if (this.ecConfig == null) {
                throw new TlsFatalAlert(80);
            }
            TlsECCUtils.writeECConfig(this.ecConfig, byteArrayOutputStream);
            this.agreement = this.context.getCrypto().createECDomain(this.ecConfig).createECDH();
            this.generateEphemeralECDH(byteArrayOutputStream);
        }
        return byteArrayOutputStream.toByteArray();
    }

    @Override
    public boolean requiresServerKeyExchange() {
        switch (this.keyExchange) {
            case 14: 
            case 24: {
                return true;
            }
        }
        return false;
    }

    @Override
    public void processServerKeyExchange(InputStream input) throws IOException {
        this.psk_identity_hint = TlsUtils.readOpaque16(input);
        if (this.keyExchange == 14) {
            this.dhConfig = TlsDHUtils.receiveDHConfig(this.dhConfigVerifier, input);
            byte[] byArray = TlsUtils.readOpaque16(input);
            this.agreement = this.context.getCrypto().createDHDomain(this.dhConfig).createDH();
            this.processEphemeralDH(byArray);
        } else if (this.keyExchange == 24) {
            this.ecConfig = TlsECCUtils.receiveECConfig(this.ecConfigVerifier, this.serverECPointFormats, input);
            byte[] byArray = TlsUtils.readOpaque8(input);
            this.agreement = this.context.getCrypto().createECDomain(this.ecConfig).createECDH();
            this.processEphemeralECDH(this.clientECPointFormats, byArray);
        }
    }

    @Override
    public void processClientCredentials(TlsCredentials clientCredentials) throws IOException {
        throw new TlsFatalAlert(80);
    }

    @Override
    public void generateClientKeyExchange(OutputStream output) throws IOException {
        if (this.psk_identity_hint == null) {
            this.pskIdentity.skipIdentityHint();
        } else {
            this.pskIdentity.notifyIdentityHint(this.psk_identity_hint);
        }
        byte[] byArray = this.pskIdentity.getPSKIdentity();
        if (byArray == null) {
            throw new TlsFatalAlert(80);
        }
        this.psk = this.pskIdentity.getPSK();
        if (this.psk == null) {
            throw new TlsFatalAlert(80);
        }
        TlsUtils.writeOpaque16(byArray, output);
        this.context.getSecurityParameters().f = Arrays.clone(byArray);
        if (this.keyExchange == 14) {
            this.generateEphemeralDH(output);
        } else if (this.keyExchange == 24) {
            this.generateEphemeralECDH(output);
        } else if (this.keyExchange == 15) {
            this.preMasterSecret = TlsRSAUtils.generateEncryptedPreMasterSecret(this.context, this.serverCertificate, output);
        }
    }

    @Override
    public void processClientKeyExchange(InputStream input) throws IOException {
        byte[] byArray = TlsUtils.readOpaque16(input);
        this.psk = this.pskIdentityManager.getPSK(byArray);
        if (this.psk == null) {
            throw new TlsFatalAlert(115);
        }
        this.context.getSecurityParameters().f = byArray;
        if (this.keyExchange == 14) {
            byte[] byArray2 = TlsUtils.readOpaque16(input);
            this.processEphemeralDH(byArray2);
        } else if (this.keyExchange == 24) {
            byte[] byArray3 = TlsUtils.readOpaque8(input);
            this.processEphemeralECDH(this.serverECPointFormats, byArray3);
        } else if (this.keyExchange == 15) {
            byte[] byArray4 = TlsUtils.readOpaque16(input);
            this.preMasterSecret = this.serverCredentials.decrypt(new TlsCryptoParameters(this.context), byArray4);
        }
    }

    @Override
    public TlsSecret generatePreMasterSecret() throws IOException {
        byte[] byArray = this.generateOtherSecret(this.psk.length);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(4 + byArray.length + this.psk.length);
        TlsUtils.writeOpaque16(byArray, byteArrayOutputStream);
        TlsUtils.writeOpaque16(this.psk, byteArrayOutputStream);
        Arrays.fill(this.psk, (byte)0);
        this.psk = null;
        return this.context.getCrypto().createSecret(byteArrayOutputStream.toByteArray());
    }

    protected void generateEphemeralDH(OutputStream output) throws IOException {
        byte[] byArray = this.agreement.generateEphemeral();
        TlsUtils.writeOpaque16(byArray, output);
    }

    protected void generateEphemeralECDH(OutputStream output) throws IOException {
        byte[] byArray = this.agreement.generateEphemeral();
        TlsUtils.writeOpaque8(byArray, output);
    }

    protected byte[] generateOtherSecret(int pskLength) throws IOException {
        if (this.keyExchange == 13) {
            return new byte[pskLength];
        }
        if ((this.keyExchange == 14 || this.keyExchange == 24) && this.agreement != null) {
            return this.agreement.calculateSecret().extract();
        }
        if (this.keyExchange == 15 && this.preMasterSecret != null) {
            return this.preMasterSecret.extract();
        }
        throw new TlsFatalAlert(80);
    }

    protected void processEphemeralDH(byte[] y2) throws IOException {
        this.agreement.receivePeerValue(y2);
    }

    protected void processEphemeralECDH(short[] localECPointFormats, byte[] point) throws IOException {
        TlsECCUtils.checkPointEncoding(localECPointFormats, this.ecConfig.getNamedGroup(), point);
        this.agreement.receivePeerValue(point);
    }
}

