/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls.crypto.impl;

import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCipher;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCryptoParameters;
import com.enterprisedt.bouncycastle.tls.crypto.TlsHMAC;
import com.enterprisedt.bouncycastle.tls.crypto.impl.TlsImplUtils;
import com.enterprisedt.bouncycastle.tls.crypto.impl.a;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;

public class TlsNullCipher
implements TlsCipher {
    protected final TlsCryptoParameters cryptoParameters;
    protected final a readMac;
    protected final a writeMac;

    public TlsNullCipher(TlsCryptoParameters cryptoParameters, TlsHMAC clientMac, TlsHMAC serverMac) throws IOException {
        this.cryptoParameters = cryptoParameters;
        int n2 = clientMac.getMacLength() + serverMac.getMacLength();
        byte[] byArray = TlsImplUtils.calculateKeyBlock(cryptoParameters, n2);
        int n3 = 0;
        clientMac.setKey(byArray, n3, clientMac.getMacLength());
        serverMac.setKey(byArray, n3 += clientMac.getMacLength(), serverMac.getMacLength());
        if ((n3 += serverMac.getMacLength()) != n2) {
            throw new TlsFatalAlert(80);
        }
        if (cryptoParameters.isServer()) {
            this.writeMac = new a(cryptoParameters, serverMac);
            this.readMac = new a(cryptoParameters, clientMac);
        } else {
            this.writeMac = new a(cryptoParameters, clientMac);
            this.readMac = new a(cryptoParameters, serverMac);
        }
    }

    @Override
    public int getCiphertextLimit(int plaintextLimit) {
        return plaintextLimit + this.writeMac.getSize();
    }

    @Override
    public int getPlaintextLimit(int ciphertextLimit) {
        return ciphertextLimit - this.writeMac.getSize();
    }

    @Override
    public byte[] encodePlaintext(long seqNo, short type, byte[] plaintext, int offset, int len) throws IOException {
        byte[] byArray = this.writeMac.calculateMac(seqNo, type, plaintext, offset, len);
        byte[] byArray2 = new byte[len + byArray.length];
        System.arraycopy(plaintext, offset, byArray2, 0, len);
        System.arraycopy(byArray, 0, byArray2, len, byArray.length);
        return byArray2;
    }

    @Override
    public byte[] decodeCiphertext(long seqNo, short type, byte[] ciphertext, int offset, int len) throws IOException {
        byte[] byArray;
        int n2 = this.readMac.getSize();
        if (len < n2) {
            throw new TlsFatalAlert(50);
        }
        int n3 = len - n2;
        byte[] byArray2 = Arrays.copyOfRange(ciphertext, offset + n3, offset + len);
        if (!Arrays.constantTimeAreEqual(byArray2, byArray = this.readMac.calculateMac(seqNo, type, ciphertext, offset, n3))) {
            throw new TlsFatalAlert(20);
        }
        return Arrays.copyOfRange(ciphertext, offset, offset + n3);
    }
}

