/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls.crypto.impl.bc;

import com.enterprisedt.bouncycastle.crypto.params.AsymmetricKeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.DHPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.DHPublicKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.enterprisedt.bouncycastle.tls.Certificate;
import com.enterprisedt.bouncycastle.tls.TlsCredentialedAgreement;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCertificate;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSecret;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsCertificate;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsDHDomain;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsECDomain;
import java.io.IOException;

public class BcDefaultTlsCredentialedAgreement
implements TlsCredentialedAgreement {
    protected TlsCredentialedAgreement agreementCredentials;

    public BcDefaultTlsCredentialedAgreement(BcTlsCrypto crypto, Certificate certificate, AsymmetricKeyParameter privateKey) {
        if (crypto == null) {
            throw new IllegalArgumentException("'crypto' cannot be null");
        }
        if (certificate == null) {
            throw new IllegalArgumentException("'certificate' cannot be null");
        }
        if (certificate.isEmpty()) {
            throw new IllegalArgumentException("'certificate' cannot be empty");
        }
        if (privateKey == null) {
            throw new IllegalArgumentException("'privateKey' cannot be null");
        }
        if (!privateKey.isPrivate()) {
            throw new IllegalArgumentException("'privateKey' must be private");
        }
        if (privateKey instanceof DHPrivateKeyParameters) {
            this.agreementCredentials = new a(crypto, certificate, (DHPrivateKeyParameters)privateKey);
        } else if (privateKey instanceof ECPrivateKeyParameters) {
            this.agreementCredentials = new b(crypto, certificate, (ECPrivateKeyParameters)privateKey);
        } else {
            throw new IllegalArgumentException("'privateKey' type not supported: " + privateKey.getClass().getName());
        }
    }

    @Override
    public Certificate getCertificate() {
        return this.agreementCredentials.getCertificate();
    }

    @Override
    public TlsSecret generateAgreement(TlsCertificate peerCertificate) throws IOException {
        return this.agreementCredentials.generateAgreement(peerCertificate);
    }

    private class b
    implements TlsCredentialedAgreement {
        final BcTlsCrypto a;
        final Certificate b;
        final ECPrivateKeyParameters c;

        b(BcTlsCrypto bcTlsCrypto, Certificate certificate, ECPrivateKeyParameters eCPrivateKeyParameters) {
            this.a = bcTlsCrypto;
            this.b = certificate;
            this.c = eCPrivateKeyParameters;
        }

        @Override
        public TlsSecret generateAgreement(TlsCertificate peerCertificate) throws IOException {
            ECPublicKeyParameters eCPublicKeyParameters = BcTlsCertificate.convert(this.a, peerCertificate).getPubKeyEC();
            return this.a.a(BcTlsECDomain.calculateBasicAgreement(this.c, eCPublicKeyParameters));
        }

        @Override
        public Certificate getCertificate() {
            return this.b;
        }
    }

    private class a
    implements TlsCredentialedAgreement {
        final BcTlsCrypto a;
        final Certificate b;
        final DHPrivateKeyParameters c;

        a(BcTlsCrypto bcTlsCrypto, Certificate certificate, DHPrivateKeyParameters dHPrivateKeyParameters) {
            this.a = bcTlsCrypto;
            this.b = certificate;
            this.c = dHPrivateKeyParameters;
        }

        @Override
        public TlsSecret generateAgreement(TlsCertificate peerCertificate) throws IOException {
            DHPublicKeyParameters dHPublicKeyParameters = BcTlsCertificate.convert(this.a, peerCertificate).getPubKeyDH();
            return this.a.a(BcTlsDHDomain.calculateBasicAgreement(this.c, dHPublicKeyParameters));
        }

        @Override
        public Certificate getCertificate() {
            return this.b;
        }
    }
}

