/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls.crypto.impl.bc;

import com.enterprisedt.bouncycastle.crypto.BlockCipher;
import com.enterprisedt.bouncycastle.crypto.CryptoException;
import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.ExtendedDigest;
import com.enterprisedt.bouncycastle.crypto.InvalidCipherTextException;
import com.enterprisedt.bouncycastle.crypto.RuntimeCryptoException;
import com.enterprisedt.bouncycastle.crypto.StreamCipher;
import com.enterprisedt.bouncycastle.crypto.agreement.srp.SRP6Client;
import com.enterprisedt.bouncycastle.crypto.agreement.srp.SRP6Server;
import com.enterprisedt.bouncycastle.crypto.agreement.srp.SRP6VerifierGenerator;
import com.enterprisedt.bouncycastle.crypto.digests.MD5Digest;
import com.enterprisedt.bouncycastle.crypto.digests.NullDigest;
import com.enterprisedt.bouncycastle.crypto.digests.SHA1Digest;
import com.enterprisedt.bouncycastle.crypto.digests.SHA224Digest;
import com.enterprisedt.bouncycastle.crypto.digests.SHA256Digest;
import com.enterprisedt.bouncycastle.crypto.digests.SHA384Digest;
import com.enterprisedt.bouncycastle.crypto.digests.SHA512Digest;
import com.enterprisedt.bouncycastle.crypto.encodings.PKCS1Encoding;
import com.enterprisedt.bouncycastle.crypto.engines.AESEngine;
import com.enterprisedt.bouncycastle.crypto.engines.ARIAEngine;
import com.enterprisedt.bouncycastle.crypto.engines.CamelliaEngine;
import com.enterprisedt.bouncycastle.crypto.engines.DESedeEngine;
import com.enterprisedt.bouncycastle.crypto.engines.RC4Engine;
import com.enterprisedt.bouncycastle.crypto.engines.RSABlindedEngine;
import com.enterprisedt.bouncycastle.crypto.engines.SEEDEngine;
import com.enterprisedt.bouncycastle.crypto.macs.HMac;
import com.enterprisedt.bouncycastle.crypto.modes.AEADBlockCipher;
import com.enterprisedt.bouncycastle.crypto.modes.CBCBlockCipher;
import com.enterprisedt.bouncycastle.crypto.modes.CCMBlockCipher;
import com.enterprisedt.bouncycastle.crypto.modes.GCMBlockCipher;
import com.enterprisedt.bouncycastle.crypto.modes.OCBBlockCipher;
import com.enterprisedt.bouncycastle.crypto.params.AEADParameters;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithIV;
import com.enterprisedt.bouncycastle.crypto.params.ParametersWithRandom;
import com.enterprisedt.bouncycastle.crypto.params.RSAKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.SRP6GroupParameters;
import com.enterprisedt.bouncycastle.crypto.prng.DigestRandomGenerator;
import com.enterprisedt.bouncycastle.tls.HashAlgorithm;
import com.enterprisedt.bouncycastle.tls.NamedGroup;
import com.enterprisedt.bouncycastle.tls.ProtocolVersion;
import com.enterprisedt.bouncycastle.tls.SignatureAndHashAlgorithm;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCertificate;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCipher;
import com.enterprisedt.bouncycastle.tls.crypto.TlsCryptoParameters;
import com.enterprisedt.bouncycastle.tls.crypto.TlsDHConfig;
import com.enterprisedt.bouncycastle.tls.crypto.TlsDHDomain;
import com.enterprisedt.bouncycastle.tls.crypto.TlsECConfig;
import com.enterprisedt.bouncycastle.tls.crypto.TlsECDomain;
import com.enterprisedt.bouncycastle.tls.crypto.TlsHMAC;
import com.enterprisedt.bouncycastle.tls.crypto.TlsHash;
import com.enterprisedt.bouncycastle.tls.crypto.TlsNonceGenerator;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSRP6Client;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSRP6Server;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSRP6VerifierGenerator;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSRPConfig;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSecret;
import com.enterprisedt.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import com.enterprisedt.bouncycastle.tls.crypto.impl.TlsAEADCipher;
import com.enterprisedt.bouncycastle.tls.crypto.impl.TlsAEADCipherImpl;
import com.enterprisedt.bouncycastle.tls.crypto.impl.TlsBlockCipher;
import com.enterprisedt.bouncycastle.tls.crypto.impl.TlsBlockCipherImpl;
import com.enterprisedt.bouncycastle.tls.crypto.impl.TlsEncryptor;
import com.enterprisedt.bouncycastle.tls.crypto.impl.TlsNullCipher;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcChaCha20Poly1305;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsCertificate;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsDHDomain;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsECDomain;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsSecret;
import com.enterprisedt.bouncycastle.util.Arrays;
import java.io.IOException;
import java.math.BigInteger;
import java.security.SecureRandom;

public class BcTlsCrypto
extends AbstractTlsCrypto {
    private final SecureRandom a;

    public BcTlsCrypto(SecureRandom entropySource) {
        this.a = entropySource;
    }

    BcTlsSecret a(byte[] byArray) {
        return new BcTlsSecret(this, byArray);
    }

    @Override
    public SecureRandom getSecureRandom() {
        return this.a;
    }

    @Override
    public TlsCertificate createCertificate(byte[] encoding) throws IOException {
        return new BcTlsCertificate(this, encoding);
    }

    @Override
    protected TlsCipher createCipher(TlsCryptoParameters cryptoParams, int encryptionAlgorithm, int macAlgorithm) throws IOException {
        switch (encryptionAlgorithm) {
            case 7: {
                return this.createDESedeCipher(cryptoParams, macAlgorithm);
            }
            case 8: {
                return this.createAESCipher(cryptoParams, 16, macAlgorithm);
            }
            case 15: {
                return this.createCipher_AES_CCM(cryptoParams, 16, 16);
            }
            case 16: {
                return this.createCipher_AES_CCM(cryptoParams, 16, 8);
            }
            case 10: {
                return this.createCipher_AES_GCM(cryptoParams, 16, 16);
            }
            case 103: {
                return this.createCipher_AES_OCB(cryptoParams, 16, 12);
            }
            case 9: {
                return this.createAESCipher(cryptoParams, 32, macAlgorithm);
            }
            case 17: {
                return this.createCipher_AES_CCM(cryptoParams, 32, 16);
            }
            case 18: {
                return this.createCipher_AES_CCM(cryptoParams, 32, 8);
            }
            case 11: {
                return this.createCipher_AES_GCM(cryptoParams, 32, 16);
            }
            case 104: {
                return this.createCipher_AES_OCB(cryptoParams, 32, 12);
            }
            case 22: {
                return this.createARIACipher(cryptoParams, 16, macAlgorithm);
            }
            case 24: {
                return this.createCipher_ARIA_GCM(cryptoParams, 16, 16);
            }
            case 23: {
                return this.createARIACipher(cryptoParams, 32, macAlgorithm);
            }
            case 25: {
                return this.createCipher_ARIA_GCM(cryptoParams, 32, 16);
            }
            case 12: {
                return this.createCamelliaCipher(cryptoParams, 16, macAlgorithm);
            }
            case 19: {
                return this.createCipher_Camellia_GCM(cryptoParams, 16, 16);
            }
            case 13: {
                return this.createCamelliaCipher(cryptoParams, 32, macAlgorithm);
            }
            case 20: {
                return this.createCipher_Camellia_GCM(cryptoParams, 32, 16);
            }
            case 21: {
                return this.createChaCha20Poly1305(cryptoParams);
            }
            case 0: {
                return this.createNullCipher(cryptoParams, macAlgorithm);
            }
            case 14: {
                return this.createSEEDCipher(cryptoParams, macAlgorithm);
            }
        }
        throw new TlsFatalAlert(80);
    }

    @Override
    public TlsDHDomain createDHDomain(TlsDHConfig dhConfig) {
        return new BcTlsDHDomain(this, dhConfig);
    }

    @Override
    public TlsECDomain createECDomain(TlsECConfig ecConfig) {
        return new BcTlsECDomain(this, ecConfig);
    }

    @Override
    protected TlsEncryptor createEncryptor(TlsCertificate certificate) throws IOException {
        BcTlsCertificate bcTlsCertificate = BcTlsCertificate.convert(this, certificate);
        bcTlsCertificate.validateKeyUsage(32);
        final RSAKeyParameters rSAKeyParameters = bcTlsCertificate.getPubKeyRSA();
        return new TlsEncryptor(){

            @Override
            public byte[] encrypt(byte[] input, int inOff, int length) throws IOException {
                try {
                    PKCS1Encoding pKCS1Encoding = new PKCS1Encoding(new RSABlindedEngine());
                    pKCS1Encoding.init(true, new ParametersWithRandom(rSAKeyParameters, BcTlsCrypto.this.getSecureRandom()));
                    return pKCS1Encoding.processBlock(input, inOff, length);
                }
                catch (InvalidCipherTextException invalidCipherTextException) {
                    throw new TlsFatalAlert(80, (Throwable)invalidCipherTextException);
                }
            }
        };
    }

    @Override
    public TlsNonceGenerator createNonceGenerator(byte[] additionalSeedMaterial) {
        final DigestRandomGenerator digestRandomGenerator = new DigestRandomGenerator(this.createDigest((short)4));
        if (additionalSeedMaterial != null && additionalSeedMaterial.length > 0) {
            digestRandomGenerator.addSeedMaterial(additionalSeedMaterial);
        }
        byte[] byArray = new byte[this.createDigest((short)4).getDigestSize()];
        this.a.nextBytes(byArray);
        digestRandomGenerator.addSeedMaterial(byArray);
        return new TlsNonceGenerator(){

            @Override
            public byte[] generateNonce(int size) {
                byte[] byArray = new byte[size];
                digestRandomGenerator.nextBytes(byArray);
                return byArray;
            }
        };
    }

    @Override
    public boolean hasAllRawSignatureAlgorithms() {
        return true;
    }

    @Override
    public boolean hasDHAgreement() {
        return true;
    }

    @Override
    public boolean hasECDHAgreement() {
        return true;
    }

    @Override
    public boolean hasEncryptionAlgorithm(int encryptionAlgorithm) {
        switch (encryptionAlgorithm) {
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean hasHashAlgorithm(short hashAlgorithm) {
        return true;
    }

    @Override
    public boolean hasMacAlgorithm(int macAlgorithm) {
        return true;
    }

    @Override
    public boolean hasNamedGroup(int namedGroup) {
        return NamedGroup.refersToASpecificGroup(namedGroup);
    }

    @Override
    public boolean hasRSAEncryption() {
        return true;
    }

    @Override
    public boolean hasSignatureAlgorithm(int signatureAlgorithm) {
        return true;
    }

    @Override
    public boolean hasSignatureAndHashAlgorithm(SignatureAndHashAlgorithm sigAndHashAlgorithm) {
        return true;
    }

    @Override
    public boolean hasSRPAuthentication() {
        return true;
    }

    @Override
    public TlsSecret createSecret(byte[] data) {
        return this.a(Arrays.clone(data));
    }

    @Override
    public TlsSecret generateRSAPreMasterSecret(ProtocolVersion version) {
        byte[] byArray = new byte[48];
        this.a.nextBytes(byArray);
        TlsUtils.writeVersion(version, byArray, 0);
        return this.a(byArray);
    }

    public Digest createDigest(short hashAlgorithm) {
        switch (hashAlgorithm) {
            case 0: {
                return new NullDigest();
            }
            case 1: {
                return new MD5Digest();
            }
            case 2: {
                return new SHA1Digest();
            }
            case 3: {
                return new SHA224Digest();
            }
            case 4: {
                return new SHA256Digest();
            }
            case 5: {
                return new SHA384Digest();
            }
            case 6: {
                return new SHA512Digest();
            }
        }
        throw new IllegalArgumentException("unknown HashAlgorithm: " + HashAlgorithm.getText(hashAlgorithm));
    }

    @Override
    public TlsHash createHash(short algorithm) {
        return new a(algorithm, this.createDigest(algorithm));
    }

    public static Digest cloneDigest(short hashAlgorithm, Digest hash) {
        switch (hashAlgorithm) {
            case 1: {
                return new MD5Digest((MD5Digest)hash);
            }
            case 2: {
                return new SHA1Digest((SHA1Digest)hash);
            }
            case 3: {
                return new SHA224Digest((SHA224Digest)hash);
            }
            case 4: {
                return new SHA256Digest((SHA256Digest)hash);
            }
            case 5: {
                return new SHA384Digest((SHA384Digest)hash);
            }
            case 6: {
                return new SHA512Digest((SHA512Digest)hash);
            }
        }
        throw new IllegalArgumentException("unknown HashAlgorithm: " + HashAlgorithm.getText(hashAlgorithm));
    }

    protected TlsCipher createAESCipher(TlsCryptoParameters cryptoParams, int cipherKeySize, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(this, cryptoParams, new b(this.createAESBlockCipher(), true), new b(this.createAESBlockCipher(), false), this.createHMAC(macAlgorithm), this.createHMAC(macAlgorithm), cipherKeySize);
    }

    protected TlsCipher createARIACipher(TlsCryptoParameters cryptoParams, int cipherKeySize, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(this, cryptoParams, new b(this.createARIABlockCipher(), true), new b(this.createARIABlockCipher(), false), this.createHMAC(macAlgorithm), this.createHMAC(macAlgorithm), cipherKeySize);
    }

    protected TlsCipher createCamelliaCipher(TlsCryptoParameters cryptoParams, int cipherKeySize, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(this, cryptoParams, new b(this.createCamelliaBlockCipher(), true), new b(this.createCamelliaBlockCipher(), false), this.createHMAC(macAlgorithm), this.createHMAC(macAlgorithm), cipherKeySize);
    }

    protected TlsCipher createChaCha20Poly1305(TlsCryptoParameters cryptoParams) throws IOException {
        return new TlsAEADCipher(cryptoParams, new BcChaCha20Poly1305(true), new BcChaCha20Poly1305(false), 32, 16, 2);
    }

    protected TlsAEADCipher createCipher_AES_CCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException {
        return new TlsAEADCipher(cryptoParams, new AeadOperator(this.createAEADBlockCipher_AES_CCM(), true), new AeadOperator(this.createAEADBlockCipher_AES_CCM(), false), cipherKeySize, macSize);
    }

    protected TlsAEADCipher createCipher_AES_GCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException {
        return new TlsAEADCipher(cryptoParams, new AeadOperator(this.createAEADBlockCipher_AES_GCM(), true), new AeadOperator(this.createAEADBlockCipher_AES_GCM(), false), cipherKeySize, macSize);
    }

    protected TlsAEADCipher createCipher_AES_OCB(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException {
        return new TlsAEADCipher(cryptoParams, new AeadOperator(this.createAEADBlockCipher_AES_OCB(), true), new AeadOperator(this.createAEADBlockCipher_AES_OCB(), false), cipherKeySize, macSize, 2);
    }

    protected TlsAEADCipher createCipher_ARIA_GCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException {
        return new TlsAEADCipher(cryptoParams, new AeadOperator(this.createAEADBlockCipher_ARIA_GCM(), true), new AeadOperator(this.createAEADBlockCipher_ARIA_GCM(), false), cipherKeySize, macSize);
    }

    protected TlsAEADCipher createCipher_Camellia_GCM(TlsCryptoParameters cryptoParams, int cipherKeySize, int macSize) throws IOException {
        return new TlsAEADCipher(cryptoParams, new AeadOperator(this.createAEADBlockCipher_Camellia_GCM(), true), new AeadOperator(this.createAEADBlockCipher_Camellia_GCM(), false), cipherKeySize, macSize);
    }

    protected TlsBlockCipher createDESedeCipher(TlsCryptoParameters cryptoParams, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(this, cryptoParams, new b(this.createDESedeBlockCipher(), true), new b(this.createDESedeBlockCipher(), false), this.createHMAC(macAlgorithm), this.createHMAC(macAlgorithm), 24);
    }

    protected TlsNullCipher createNullCipher(TlsCryptoParameters cryptoParams, int macAlgorithm) throws IOException {
        return new TlsNullCipher(cryptoParams, this.createHMAC(macAlgorithm), this.createHMAC(macAlgorithm));
    }

    protected TlsBlockCipher createSEEDCipher(TlsCryptoParameters cryptoParams, int macAlgorithm) throws IOException {
        return new TlsBlockCipher(this, cryptoParams, new b(this.createSEEDBlockCipher(), true), new b(this.createSEEDBlockCipher(), false), this.createHMAC(macAlgorithm), this.createHMAC(macAlgorithm), 16);
    }

    protected BlockCipher createAESEngine() {
        return new AESEngine();
    }

    protected BlockCipher createARIAEngine() {
        return new ARIAEngine();
    }

    protected BlockCipher createCamelliaEngine() {
        return new CamelliaEngine();
    }

    protected BlockCipher createAESBlockCipher() {
        return new CBCBlockCipher(this.createAESEngine());
    }

    protected BlockCipher createARIABlockCipher() {
        return new CBCBlockCipher(this.createARIAEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_AES_CCM() {
        return new CCMBlockCipher(this.createAESEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_AES_GCM() {
        return new GCMBlockCipher(this.createAESEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_AES_OCB() {
        return new OCBBlockCipher(this.createAESEngine(), this.createAESEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_ARIA_GCM() {
        return new GCMBlockCipher(this.createARIAEngine());
    }

    protected AEADBlockCipher createAEADBlockCipher_Camellia_GCM() {
        return new GCMBlockCipher(this.createCamelliaEngine());
    }

    protected BlockCipher createCamelliaBlockCipher() {
        return new CBCBlockCipher(this.createCamelliaEngine());
    }

    protected BlockCipher createDESedeBlockCipher() {
        return new CBCBlockCipher(new DESedeEngine());
    }

    protected StreamCipher createRC4StreamCipher() {
        return new RC4Engine();
    }

    protected BlockCipher createSEEDBlockCipher() {
        return new CBCBlockCipher(new SEEDEngine());
    }

    @Override
    public TlsHMAC createHMAC(int macAlgorithm) {
        return new c(this.createDigest(TlsUtils.getHashAlgorithmForHMACAlgorithm(macAlgorithm)));
    }

    @Override
    public TlsSRP6Client createSRP6Client(TlsSRPConfig srpConfig) {
        final SRP6Client sRP6Client = new SRP6Client();
        BigInteger[] bigIntegerArray = srpConfig.getExplicitNG();
        SRP6GroupParameters sRP6GroupParameters = new SRP6GroupParameters(bigIntegerArray[0], bigIntegerArray[1]);
        sRP6Client.init(sRP6GroupParameters, new SHA1Digest(), this.getSecureRandom());
        return new TlsSRP6Client(){

            @Override
            public BigInteger calculateSecret(BigInteger serverB) throws TlsFatalAlert {
                try {
                    return sRP6Client.calculateSecret(serverB);
                }
                catch (CryptoException cryptoException) {
                    throw new TlsFatalAlert(47, (Throwable)cryptoException);
                }
            }

            @Override
            public BigInteger generateClientCredentials(byte[] srpSalt, byte[] identity, byte[] password) {
                return sRP6Client.generateClientCredentials(srpSalt, identity, password);
            }
        };
    }

    @Override
    public TlsSRP6Server createSRP6Server(TlsSRPConfig srpConfig, BigInteger srpVerifier) {
        final SRP6Server sRP6Server = new SRP6Server();
        BigInteger[] bigIntegerArray = srpConfig.getExplicitNG();
        SRP6GroupParameters sRP6GroupParameters = new SRP6GroupParameters(bigIntegerArray[0], bigIntegerArray[1]);
        sRP6Server.init(sRP6GroupParameters, srpVerifier, new SHA1Digest(), this.getSecureRandom());
        return new TlsSRP6Server(){

            @Override
            public BigInteger generateServerCredentials() {
                return sRP6Server.generateServerCredentials();
            }

            @Override
            public BigInteger calculateSecret(BigInteger clientA) throws IOException {
                try {
                    return sRP6Server.calculateSecret(clientA);
                }
                catch (CryptoException cryptoException) {
                    throw new TlsFatalAlert(47, (Throwable)cryptoException);
                }
            }
        };
    }

    @Override
    public TlsSRP6VerifierGenerator createSRP6VerifierGenerator(TlsSRPConfig srpConfig) {
        BigInteger[] bigIntegerArray = srpConfig.getExplicitNG();
        final SRP6VerifierGenerator sRP6VerifierGenerator = new SRP6VerifierGenerator();
        sRP6VerifierGenerator.init(bigIntegerArray[0], bigIntegerArray[1], new SHA1Digest());
        return new TlsSRP6VerifierGenerator(){

            @Override
            public BigInteger generateVerifier(byte[] salt, byte[] identity, byte[] password) {
                return sRP6VerifierGenerator.generateVerifier(salt, identity, password);
            }
        };
    }

    private class c
    implements TlsHMAC {
        private final HMac b;

        c(Digest digest) {
            this.b = new HMac(digest);
        }

        @Override
        public void setKey(byte[] key, int keyOff, int keyLen) {
            this.b.init(new KeyParameter(key, keyOff, keyLen));
        }

        @Override
        public void update(byte[] input, int inOff, int length) {
            this.b.update(input, inOff, length);
        }

        @Override
        public byte[] calculateMAC() {
            byte[] byArray = new byte[this.b.getMacSize()];
            this.b.doFinal(byArray, 0);
            return byArray;
        }

        @Override
        public int getInternalBlockSize() {
            return ((ExtendedDigest)this.b.getUnderlyingDigest()).getByteLength();
        }

        @Override
        public int getMacLength() {
            return this.b.getMacSize();
        }

        @Override
        public void reset() {
            this.b.reset();
        }
    }

    public class AeadOperator
    implements TlsAEADCipherImpl {
        private final boolean b;
        private final AEADBlockCipher c;
        private KeyParameter d;

        public AeadOperator(AEADBlockCipher cipher, boolean isEncrypting) {
            this.c = cipher;
            this.b = isEncrypting;
        }

        @Override
        public void setKey(byte[] key, int keyOff, int keyLen) {
            this.d = new KeyParameter(key, keyOff, keyLen);
        }

        @Override
        public void init(byte[] nonce, int macSize, byte[] additionalData) {
            this.c.init(this.b, new AEADParameters(this.d, macSize * 8, nonce, additionalData));
        }

        @Override
        public int getOutputSize(int inputLength) {
            return this.c.getOutputSize(inputLength);
        }

        @Override
        public int doFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) {
            int n2 = this.c.processBytes(input, inputOffset, inputLength, output, outputOffset);
            try {
                return n2 + this.c.doFinal(output, outputOffset + n2);
            }
            catch (InvalidCipherTextException invalidCipherTextException) {
                throw new RuntimeCryptoException(invalidCipherTextException.toString());
            }
        }
    }

    private class b
    implements TlsBlockCipherImpl {
        private final boolean b;
        private final BlockCipher c;
        private KeyParameter d;

        b(BlockCipher blockCipher, boolean bl) {
            this.c = blockCipher;
            this.b = bl;
        }

        @Override
        public void setKey(byte[] key, int keyOff, int keyLen) {
            this.d = new KeyParameter(key, keyOff, keyLen);
            this.c.init(this.b, new ParametersWithIV(this.d, new byte[this.c.getBlockSize()]));
        }

        @Override
        public void init(byte[] iv, int ivOff, int ivLen) {
            this.c.init(this.b, new ParametersWithIV(null, iv, ivOff, ivLen));
        }

        @Override
        public int doFinal(byte[] input, int inputOffset, int inputLength, byte[] output, int outputOffset) {
            int n2 = this.c.getBlockSize();
            for (int i2 = 0; i2 < inputLength; i2 += n2) {
                this.c.processBlock(input, inputOffset + i2, output, outputOffset + i2);
            }
            return inputLength;
        }

        @Override
        public int getBlockSize() {
            return this.c.getBlockSize();
        }
    }

    private static class a
    implements TlsHash {
        private final short a;
        private final Digest b;

        a(short s2, Digest digest) {
            this.a = s2;
            this.b = digest;
        }

        @Override
        public void update(byte[] data, int offSet, int length) {
            this.b.update(data, offSet, length);
        }

        @Override
        public byte[] calculateHash() {
            byte[] byArray = new byte[this.b.getDigestSize()];
            this.b.doFinal(byArray, 0);
            return byArray;
        }

        @Override
        public Object clone() {
            return new a(this.a, BcTlsCrypto.cloneDigest(this.a, this.b));
        }

        @Override
        public void reset() {
            this.b.reset();
        }
    }
}

