/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls.crypto.impl.bc;

import com.enterprisedt.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.enterprisedt.bouncycastle.crypto.agreement.DHBasicAgreement;
import com.enterprisedt.bouncycastle.crypto.generators.DHBasicKeyPairGenerator;
import com.enterprisedt.bouncycastle.crypto.params.DHKeyGenerationParameters;
import com.enterprisedt.bouncycastle.crypto.params.DHParameters;
import com.enterprisedt.bouncycastle.crypto.params.DHPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.DHPublicKeyParameters;
import com.enterprisedt.bouncycastle.tls.TlsDHUtils;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.crypto.DHGroup;
import com.enterprisedt.bouncycastle.tls.crypto.TlsAgreement;
import com.enterprisedt.bouncycastle.tls.crypto.TlsDHConfig;
import com.enterprisedt.bouncycastle.tls.crypto.TlsDHDomain;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsDH;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsSecret;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import java.io.IOException;
import java.math.BigInteger;

public class BcTlsDHDomain
implements TlsDHDomain {
    protected BcTlsCrypto crypto;
    protected TlsDHConfig dhConfig;
    protected DHParameters dhParameters;

    public static byte[] calculateBasicAgreement(DHPrivateKeyParameters privateKey, DHPublicKeyParameters publicKey) {
        DHBasicAgreement dHBasicAgreement = new DHBasicAgreement();
        dHBasicAgreement.init(privateKey);
        BigInteger bigInteger = dHBasicAgreement.calculateAgreement(publicKey);
        return BigIntegers.asUnsignedByteArray(bigInteger);
    }

    public static DHParameters getParameters(TlsDHConfig dhConfig) {
        DHGroup dHGroup = TlsDHUtils.getDHGroup(dhConfig);
        if (dHGroup == null) {
            throw new IllegalArgumentException("No DH configuration provided");
        }
        return new DHParameters(dHGroup.getP(), dHGroup.getG(), dHGroup.getQ(), dHGroup.getL());
    }

    public BcTlsDHDomain(BcTlsCrypto crypto, TlsDHConfig dhConfig) {
        this.crypto = crypto;
        this.dhConfig = dhConfig;
        this.dhParameters = BcTlsDHDomain.getParameters(dhConfig);
    }

    public BcTlsSecret calculateDHAgreement(DHPrivateKeyParameters privateKey, DHPublicKeyParameters publicKey) {
        return this.crypto.a(BcTlsDHDomain.calculateBasicAgreement(privateKey, publicKey));
    }

    @Override
    public TlsAgreement createDH() {
        return new BcTlsDH(this);
    }

    public BigInteger decodeParameter(byte[] encoding) throws IOException {
        return new BigInteger(1, encoding);
    }

    public DHPublicKeyParameters decodePublicKey(byte[] encoding) throws IOException {
        try {
            BigInteger bigInteger = this.decodeParameter(encoding);
            return new DHPublicKeyParameters(bigInteger, this.dhParameters);
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(40, (Throwable)runtimeException);
        }
    }

    public byte[] encodeParameter(BigInteger x2) throws IOException {
        return BigIntegers.asUnsignedByteArray(x2);
    }

    public byte[] encodePublicKey(DHPublicKeyParameters publicKey) throws IOException {
        return this.encodeParameter(publicKey.getY());
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        DHBasicKeyPairGenerator dHBasicKeyPairGenerator = new DHBasicKeyPairGenerator();
        dHBasicKeyPairGenerator.init(new DHKeyGenerationParameters(this.crypto.getSecureRandom(), this.dhParameters));
        return dHBasicKeyPairGenerator.generateKeyPair();
    }
}

