/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls.crypto.impl.bc;

import com.enterprisedt.bouncycastle.asn1.x9.ECNamedCurveTable;
import com.enterprisedt.bouncycastle.asn1.x9.X9ECParameters;
import com.enterprisedt.bouncycastle.crypto.AsymmetricCipherKeyPair;
import com.enterprisedt.bouncycastle.crypto.agreement.ECDHBasicAgreement;
import com.enterprisedt.bouncycastle.crypto.ec.CustomNamedCurves;
import com.enterprisedt.bouncycastle.crypto.generators.ECKeyPairGenerator;
import com.enterprisedt.bouncycastle.crypto.params.ECDomainParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECKeyGenerationParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPrivateKeyParameters;
import com.enterprisedt.bouncycastle.crypto.params.ECPublicKeyParameters;
import com.enterprisedt.bouncycastle.math.ec.ECPoint;
import com.enterprisedt.bouncycastle.tls.NamedGroup;
import com.enterprisedt.bouncycastle.tls.TlsFatalAlert;
import com.enterprisedt.bouncycastle.tls.crypto.TlsAgreement;
import com.enterprisedt.bouncycastle.tls.crypto.TlsECConfig;
import com.enterprisedt.bouncycastle.tls.crypto.TlsECDomain;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsECDH;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsSecret;
import com.enterprisedt.bouncycastle.util.BigIntegers;
import java.io.IOException;
import java.math.BigInteger;

public class BcTlsECDomain
implements TlsECDomain {
    protected final BcTlsCrypto crypto;
    protected final TlsECConfig ecConfig;
    protected final ECDomainParameters ecDomainParameters;

    public static byte[] calculateBasicAgreement(ECPrivateKeyParameters privateKey, ECPublicKeyParameters publicKey) {
        ECDHBasicAgreement eCDHBasicAgreement = new ECDHBasicAgreement();
        eCDHBasicAgreement.init(privateKey);
        BigInteger bigInteger = eCDHBasicAgreement.calculateAgreement(publicKey);
        return BigIntegers.asUnsignedByteArray(eCDHBasicAgreement.getFieldSize(), bigInteger);
    }

    public static ECDomainParameters getDomainParameters(TlsECConfig ecConfig) {
        return BcTlsECDomain.getDomainParameters(ecConfig.getNamedGroup());
    }

    public static ECDomainParameters getDomainParameters(int namedGroup) {
        if (!NamedGroup.refersToASpecificCurve(namedGroup)) {
            return null;
        }
        String string = NamedGroup.getName(namedGroup);
        if (string == null) {
            return null;
        }
        X9ECParameters x9ECParameters = CustomNamedCurves.getByName(string);
        if (x9ECParameters == null && (x9ECParameters = ECNamedCurveTable.getByName(string)) == null) {
            return null;
        }
        return new ECDomainParameters(x9ECParameters.getCurve(), x9ECParameters.getG(), x9ECParameters.getN(), x9ECParameters.getH(), x9ECParameters.getSeed());
    }

    public BcTlsECDomain(BcTlsCrypto crypto, TlsECConfig ecConfig) {
        this.crypto = crypto;
        this.ecConfig = ecConfig;
        this.ecDomainParameters = BcTlsECDomain.getDomainParameters(ecConfig);
    }

    public BcTlsSecret calculateECDHAgreement(ECPrivateKeyParameters privateKey, ECPublicKeyParameters publicKey) {
        return this.crypto.a(BcTlsECDomain.calculateBasicAgreement(privateKey, publicKey));
    }

    @Override
    public TlsAgreement createECDH() {
        return new BcTlsECDH(this);
    }

    public ECPoint decodePoint(byte[] encoding) throws IOException {
        return this.ecDomainParameters.getCurve().decodePoint(encoding);
    }

    public ECPublicKeyParameters decodePublicKey(byte[] encoding) throws IOException {
        try {
            ECPoint eCPoint = this.decodePoint(encoding);
            return new ECPublicKeyParameters(eCPoint, this.ecDomainParameters);
        }
        catch (RuntimeException runtimeException) {
            throw new TlsFatalAlert(47, (Throwable)runtimeException);
        }
    }

    public byte[] encodePoint(ECPoint point) throws IOException {
        return point.getEncoded(this.ecConfig.getPointCompression());
    }

    public byte[] encodePublicKey(ECPublicKeyParameters publicKey) throws IOException {
        return this.encodePoint(publicKey.getQ());
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        ECKeyPairGenerator eCKeyPairGenerator = new ECKeyPairGenerator();
        eCKeyPairGenerator.init(new ECKeyGenerationParameters(this.ecDomainParameters, this.crypto.getSecureRandom()));
        return eCKeyPairGenerator.generateKeyPair();
    }
}

