/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.tls.crypto.impl.bc;

import com.enterprisedt.bouncycastle.crypto.Digest;
import com.enterprisedt.bouncycastle.crypto.macs.HMac;
import com.enterprisedt.bouncycastle.crypto.params.KeyParameter;
import com.enterprisedt.bouncycastle.tls.TlsUtils;
import com.enterprisedt.bouncycastle.tls.crypto.TlsSecret;
import com.enterprisedt.bouncycastle.tls.crypto.impl.AbstractTlsCrypto;
import com.enterprisedt.bouncycastle.tls.crypto.impl.AbstractTlsSecret;
import com.enterprisedt.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import com.enterprisedt.bouncycastle.util.Arrays;
import com.enterprisedt.bouncycastle.util.Strings;

public class BcTlsSecret
extends AbstractTlsSecret {
    protected final BcTlsCrypto crypto;

    public BcTlsSecret(BcTlsCrypto crypto, byte[] data) {
        super(data);
        this.crypto = crypto;
    }

    @Override
    public synchronized TlsSecret deriveUsingPRF(int prfAlgorithm, String label, byte[] seed, int length) {
        this.checkAlive();
        byte[] byArray = Arrays.concatenate(Strings.toByteArray(label), seed);
        byte[] byArray2 = prfAlgorithm == 0 ? this.prf_1_0(this.data, byArray, length) : this.prf_1_2(prfAlgorithm, this.data, byArray, length);
        return this.crypto.a(byArray2);
    }

    @Override
    protected AbstractTlsCrypto getCrypto() {
        return this.crypto;
    }

    protected void hmacHash(Digest digest, byte[] secret, int secretOff, int secretLen, byte[] seed, byte[] output) {
        HMac hMac = new HMac(digest);
        hMac.init(new KeyParameter(secret, secretOff, secretLen));
        byte[] byArray = seed;
        int n2 = hMac.getMacSize();
        byte[] byArray2 = new byte[n2];
        byte[] byArray3 = new byte[n2];
        for (int i2 = 0; i2 < output.length; i2 += n2) {
            hMac.update(byArray, 0, byArray.length);
            hMac.doFinal(byArray2, 0);
            byArray = byArray2;
            hMac.update(byArray, 0, byArray.length);
            hMac.update(seed, 0, seed.length);
            hMac.doFinal(byArray3, 0);
            System.arraycopy(byArray3, 0, output, i2, Math.min(n2, output.length - i2));
        }
    }

    protected byte[] prf_1_0(byte[] secret, byte[] labelSeed, int length) {
        int n2 = (secret.length + 1) / 2;
        byte[] byArray = new byte[length];
        this.hmacHash(this.crypto.createDigest((short)1), secret, 0, n2, labelSeed, byArray);
        byte[] byArray2 = new byte[length];
        this.hmacHash(this.crypto.createDigest((short)2), secret, secret.length - n2, n2, labelSeed, byArray2);
        for (int i2 = 0; i2 < length; ++i2) {
            int n3 = i2;
            byArray[n3] = (byte)(byArray[n3] ^ byArray2[i2]);
        }
        return byArray;
    }

    protected byte[] prf_1_2(int prfAlgorithm, byte[] secret, byte[] labelSeed, int length) {
        Digest digest = this.crypto.createDigest(TlsUtils.getHashAlgorithmForPRFAlgorithm(prfAlgorithm));
        byte[] byArray = new byte[length];
        this.hmacHash(digest, secret, 0, secret.length, labelSeed, byArray);
        return byArray;
    }
}

