/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.util;

import java.math.BigInteger;
import java.util.NoSuchElementException;

public final class Arrays {
    private Arrays() {
    }

    public static boolean areEqual(boolean[] a2, boolean[] b2) {
        if (a2 == b2) {
            return true;
        }
        if (a2 == null || b2 == null) {
            return false;
        }
        if (a2.length != b2.length) {
            return false;
        }
        for (int i2 = 0; i2 != a2.length; ++i2) {
            if (a2[i2] == b2[i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean areEqual(char[] a2, char[] b2) {
        if (a2 == b2) {
            return true;
        }
        if (a2 == null || b2 == null) {
            return false;
        }
        if (a2.length != b2.length) {
            return false;
        }
        for (int i2 = 0; i2 != a2.length; ++i2) {
            if (a2[i2] == b2[i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean areEqual(byte[] a2, byte[] b2) {
        if (a2 == b2) {
            return true;
        }
        if (a2 == null || b2 == null) {
            return false;
        }
        if (a2.length != b2.length) {
            return false;
        }
        for (int i2 = 0; i2 != a2.length; ++i2) {
            if (a2[i2] == b2[i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean areEqual(short[] a2, short[] b2) {
        if (a2 == b2) {
            return true;
        }
        if (a2 == null || b2 == null) {
            return false;
        }
        if (a2.length != b2.length) {
            return false;
        }
        for (int i2 = 0; i2 != a2.length; ++i2) {
            if (a2[i2] == b2[i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean constantTimeAreEqual(byte[] expected, byte[] supplied) {
        if (expected == supplied) {
            return true;
        }
        if (expected == null || supplied == null) {
            return false;
        }
        if (expected.length != supplied.length) {
            return !Arrays.constantTimeAreEqual(expected, expected);
        }
        int n2 = 0;
        for (int i2 = 0; i2 != expected.length; ++i2) {
            n2 |= expected[i2] ^ supplied[i2];
        }
        return n2 == 0;
    }

    public static boolean areEqual(int[] a2, int[] b2) {
        if (a2 == b2) {
            return true;
        }
        if (a2 == null || b2 == null) {
            return false;
        }
        if (a2.length != b2.length) {
            return false;
        }
        for (int i2 = 0; i2 != a2.length; ++i2) {
            if (a2[i2] == b2[i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean areEqual(long[] a2, long[] b2) {
        if (a2 == b2) {
            return true;
        }
        if (a2 == null || b2 == null) {
            return false;
        }
        if (a2.length != b2.length) {
            return false;
        }
        for (int i2 = 0; i2 != a2.length; ++i2) {
            if (a2[i2] == b2[i2]) continue;
            return false;
        }
        return true;
    }

    public static boolean areEqual(Object[] a2, Object[] b2) {
        if (a2 == b2) {
            return true;
        }
        if (a2 == null || b2 == null) {
            return false;
        }
        if (a2.length != b2.length) {
            return false;
        }
        for (int i2 = 0; i2 != a2.length; ++i2) {
            Object object = a2[i2];
            Object object2 = b2[i2];
            if (!(object == null ? object2 != null : !object.equals(object2))) continue;
            return false;
        }
        return true;
    }

    public static int compareUnsigned(byte[] a2, byte[] b2) {
        if (a2 == b2) {
            return 0;
        }
        if (a2 == null) {
            return -1;
        }
        if (b2 == null) {
            return 1;
        }
        int n2 = Math.min(a2.length, b2.length);
        for (int i2 = 0; i2 < n2; ++i2) {
            int n3 = a2[i2] & 0xFF;
            int n4 = b2[i2] & 0xFF;
            if (n3 < n4) {
                return -1;
            }
            if (n3 <= n4) continue;
            return 1;
        }
        if (a2.length < b2.length) {
            return -1;
        }
        if (a2.length > b2.length) {
            return 1;
        }
        return 0;
    }

    public static boolean contains(short[] a2, short n2) {
        for (int i2 = 0; i2 < a2.length; ++i2) {
            if (a2[i2] != n2) continue;
            return true;
        }
        return false;
    }

    public static boolean contains(int[] a2, int n2) {
        for (int i2 = 0; i2 < a2.length; ++i2) {
            if (a2[i2] != n2) continue;
            return true;
        }
        return false;
    }

    public static void fill(byte[] array, byte value) {
        for (int i2 = 0; i2 < array.length; ++i2) {
            array[i2] = value;
        }
    }

    public static void fill(char[] array, char value) {
        for (int i2 = 0; i2 < array.length; ++i2) {
            array[i2] = value;
        }
    }

    public static void fill(long[] array, long value) {
        for (int i2 = 0; i2 < array.length; ++i2) {
            array[i2] = value;
        }
    }

    public static void fill(short[] array, short value) {
        for (int i2 = 0; i2 < array.length; ++i2) {
            array[i2] = value;
        }
    }

    public static void fill(int[] array, int value) {
        for (int i2 = 0; i2 < array.length; ++i2) {
            array[i2] = value;
        }
    }

    public static void fill(byte[] array, int out, byte value) {
        if (out < array.length) {
            for (int i2 = out; i2 < array.length; ++i2) {
                array[i2] = value;
            }
        }
    }

    public static void fill(int[] array, int out, int value) {
        if (out < array.length) {
            for (int i2 = out; i2 < array.length; ++i2) {
                array[i2] = value;
            }
        }
    }

    public static void fill(short[] array, int out, short value) {
        if (out < array.length) {
            for (int i2 = out; i2 < array.length; ++i2) {
                array[i2] = value;
            }
        }
    }

    public static void fill(long[] array, int out, long value) {
        if (out < array.length) {
            for (int i2 = out; i2 < array.length; ++i2) {
                array[i2] = value;
            }
        }
    }

    public static int hashCode(byte[] data) {
        if (data == null) {
            return 0;
        }
        int n2 = data.length;
        int n3 = n2 + 1;
        while (--n2 >= 0) {
            n3 *= 257;
            n3 ^= data[n2];
        }
        return n3;
    }

    public static int hashCode(byte[] data, int off, int len) {
        if (data == null) {
            return 0;
        }
        int n2 = len;
        int n3 = n2 + 1;
        while (--n2 >= 0) {
            n3 *= 257;
            n3 ^= data[off + n2];
        }
        return n3;
    }

    public static int hashCode(char[] data) {
        if (data == null) {
            return 0;
        }
        int n2 = data.length;
        int n3 = n2 + 1;
        while (--n2 >= 0) {
            n3 *= 257;
            n3 ^= data[n2];
        }
        return n3;
    }

    public static int hashCode(int[][] ints) {
        int n2 = 0;
        for (int i2 = 0; i2 != ints.length; ++i2) {
            n2 = n2 * 257 + Arrays.hashCode(ints[i2]);
        }
        return n2;
    }

    public static int hashCode(int[] data) {
        if (data == null) {
            return 0;
        }
        int n2 = data.length;
        int n3 = n2 + 1;
        while (--n2 >= 0) {
            n3 *= 257;
            n3 ^= data[n2];
        }
        return n3;
    }

    public static int hashCode(int[] data, int off, int len) {
        if (data == null) {
            return 0;
        }
        int n2 = len;
        int n3 = n2 + 1;
        while (--n2 >= 0) {
            n3 *= 257;
            n3 ^= data[off + n2];
        }
        return n3;
    }

    public static int hashCode(long[] data) {
        if (data == null) {
            return 0;
        }
        int n2 = data.length;
        int n3 = n2 + 1;
        while (--n2 >= 0) {
            long l2 = data[n2];
            n3 *= 257;
            n3 ^= (int)l2;
            n3 *= 257;
            n3 ^= (int)(l2 >>> 32);
        }
        return n3;
    }

    public static int hashCode(long[] data, int off, int len) {
        if (data == null) {
            return 0;
        }
        int n2 = len;
        int n3 = n2 + 1;
        while (--n2 >= 0) {
            long l2 = data[off + n2];
            n3 *= 257;
            n3 ^= (int)l2;
            n3 *= 257;
            n3 ^= (int)(l2 >>> 32);
        }
        return n3;
    }

    public static int hashCode(short[][][] shorts) {
        int n2 = 0;
        for (int i2 = 0; i2 != shorts.length; ++i2) {
            n2 = n2 * 257 + Arrays.hashCode(shorts[i2]);
        }
        return n2;
    }

    public static int hashCode(short[][] shorts) {
        int n2 = 0;
        for (int i2 = 0; i2 != shorts.length; ++i2) {
            n2 = n2 * 257 + Arrays.hashCode(shorts[i2]);
        }
        return n2;
    }

    public static int hashCode(short[] data) {
        if (data == null) {
            return 0;
        }
        int n2 = data.length;
        int n3 = n2 + 1;
        while (--n2 >= 0) {
            n3 *= 257;
            n3 ^= data[n2] & 0xFF;
        }
        return n3;
    }

    public static int hashCode(Object[] data) {
        if (data == null) {
            return 0;
        }
        int n2 = data.length;
        int n3 = n2 + 1;
        while (--n2 >= 0) {
            n3 *= 257;
            n3 ^= data[n2].hashCode();
        }
        return n3;
    }

    public static byte[] clone(byte[] data) {
        if (data == null) {
            return null;
        }
        byte[] byArray = new byte[data.length];
        System.arraycopy(data, 0, byArray, 0, data.length);
        return byArray;
    }

    public static char[] clone(char[] data) {
        if (data == null) {
            return null;
        }
        char[] cArray = new char[data.length];
        System.arraycopy(data, 0, cArray, 0, data.length);
        return cArray;
    }

    public static byte[] clone(byte[] data, byte[] existing) {
        if (data == null) {
            return null;
        }
        if (existing == null || existing.length != data.length) {
            return Arrays.clone(data);
        }
        System.arraycopy(data, 0, existing, 0, existing.length);
        return existing;
    }

    public static byte[][] clone(byte[][] data) {
        if (data == null) {
            return null;
        }
        byte[][] byArrayArray = new byte[data.length][];
        for (int i2 = 0; i2 != byArrayArray.length; ++i2) {
            byArrayArray[i2] = Arrays.clone(data[i2]);
        }
        return byArrayArray;
    }

    public static byte[][][] clone(byte[][][] data) {
        if (data == null) {
            return null;
        }
        byte[][][] byArrayArray = new byte[data.length][][];
        for (int i2 = 0; i2 != byArrayArray.length; ++i2) {
            byArrayArray[i2] = Arrays.clone(data[i2]);
        }
        return byArrayArray;
    }

    public static int[] clone(int[] data) {
        if (data == null) {
            return null;
        }
        int[] nArray = new int[data.length];
        System.arraycopy(data, 0, nArray, 0, data.length);
        return nArray;
    }

    public static long[] clone(long[] data) {
        if (data == null) {
            return null;
        }
        long[] lArray = new long[data.length];
        System.arraycopy(data, 0, lArray, 0, data.length);
        return lArray;
    }

    public static long[] clone(long[] data, long[] existing) {
        if (data == null) {
            return null;
        }
        if (existing == null || existing.length != data.length) {
            return Arrays.clone(data);
        }
        System.arraycopy(data, 0, existing, 0, existing.length);
        return existing;
    }

    public static short[] clone(short[] data) {
        if (data == null) {
            return null;
        }
        short[] sArray = new short[data.length];
        System.arraycopy(data, 0, sArray, 0, data.length);
        return sArray;
    }

    public static BigInteger[] clone(BigInteger[] data) {
        if (data == null) {
            return null;
        }
        BigInteger[] bigIntegerArray = new BigInteger[data.length];
        System.arraycopy(data, 0, bigIntegerArray, 0, data.length);
        return bigIntegerArray;
    }

    public static byte[] copyOf(byte[] data, int newLength) {
        byte[] byArray = new byte[newLength];
        if (newLength < data.length) {
            System.arraycopy(data, 0, byArray, 0, newLength);
        } else {
            System.arraycopy(data, 0, byArray, 0, data.length);
        }
        return byArray;
    }

    public static char[] copyOf(char[] data, int newLength) {
        char[] cArray = new char[newLength];
        if (newLength < data.length) {
            System.arraycopy(data, 0, cArray, 0, newLength);
        } else {
            System.arraycopy(data, 0, cArray, 0, data.length);
        }
        return cArray;
    }

    public static int[] copyOf(int[] data, int newLength) {
        int[] nArray = new int[newLength];
        if (newLength < data.length) {
            System.arraycopy(data, 0, nArray, 0, newLength);
        } else {
            System.arraycopy(data, 0, nArray, 0, data.length);
        }
        return nArray;
    }

    public static long[] copyOf(long[] data, int newLength) {
        long[] lArray = new long[newLength];
        if (newLength < data.length) {
            System.arraycopy(data, 0, lArray, 0, newLength);
        } else {
            System.arraycopy(data, 0, lArray, 0, data.length);
        }
        return lArray;
    }

    public static BigInteger[] copyOf(BigInteger[] data, int newLength) {
        BigInteger[] bigIntegerArray = new BigInteger[newLength];
        if (newLength < data.length) {
            System.arraycopy(data, 0, bigIntegerArray, 0, newLength);
        } else {
            System.arraycopy(data, 0, bigIntegerArray, 0, data.length);
        }
        return bigIntegerArray;
    }

    public static byte[] copyOfRange(byte[] data, int from, int to) {
        int n2 = Arrays.a(from, to);
        byte[] byArray = new byte[n2];
        if (data.length - from < n2) {
            System.arraycopy(data, from, byArray, 0, data.length - from);
        } else {
            System.arraycopy(data, from, byArray, 0, n2);
        }
        return byArray;
    }

    public static int[] copyOfRange(int[] data, int from, int to) {
        int n2 = Arrays.a(from, to);
        int[] nArray = new int[n2];
        if (data.length - from < n2) {
            System.arraycopy(data, from, nArray, 0, data.length - from);
        } else {
            System.arraycopy(data, from, nArray, 0, n2);
        }
        return nArray;
    }

    public static long[] copyOfRange(long[] data, int from, int to) {
        int n2 = Arrays.a(from, to);
        long[] lArray = new long[n2];
        if (data.length - from < n2) {
            System.arraycopy(data, from, lArray, 0, data.length - from);
        } else {
            System.arraycopy(data, from, lArray, 0, n2);
        }
        return lArray;
    }

    public static BigInteger[] copyOfRange(BigInteger[] data, int from, int to) {
        int n2 = Arrays.a(from, to);
        BigInteger[] bigIntegerArray = new BigInteger[n2];
        if (data.length - from < n2) {
            System.arraycopy(data, from, bigIntegerArray, 0, data.length - from);
        } else {
            System.arraycopy(data, from, bigIntegerArray, 0, n2);
        }
        return bigIntegerArray;
    }

    private static int a(int n2, int n3) {
        int n4 = n3 - n2;
        if (n4 < 0) {
            StringBuffer stringBuffer = new StringBuffer(n2);
            stringBuffer.append(" > ").append(n3);
            throw new IllegalArgumentException(stringBuffer.toString());
        }
        return n4;
    }

    public static byte[] append(byte[] a2, byte b2) {
        if (a2 == null) {
            return new byte[]{b2};
        }
        int n2 = a2.length;
        byte[] byArray = new byte[n2 + 1];
        System.arraycopy(a2, 0, byArray, 0, n2);
        byArray[n2] = b2;
        return byArray;
    }

    public static short[] append(short[] a2, short b2) {
        if (a2 == null) {
            return new short[]{b2};
        }
        int n2 = a2.length;
        short[] sArray = new short[n2 + 1];
        System.arraycopy(a2, 0, sArray, 0, n2);
        sArray[n2] = b2;
        return sArray;
    }

    public static int[] append(int[] a2, int b2) {
        if (a2 == null) {
            return new int[]{b2};
        }
        int n2 = a2.length;
        int[] nArray = new int[n2 + 1];
        System.arraycopy(a2, 0, nArray, 0, n2);
        nArray[n2] = b2;
        return nArray;
    }

    public static String[] append(String[] a2, String b2) {
        if (a2 == null) {
            return new String[]{b2};
        }
        int n2 = a2.length;
        String[] stringArray = new String[n2 + 1];
        System.arraycopy(a2, 0, stringArray, 0, n2);
        stringArray[n2] = b2;
        return stringArray;
    }

    public static byte[] concatenate(byte[] a2, byte[] b2) {
        if (a2 != null && b2 != null) {
            byte[] byArray = new byte[a2.length + b2.length];
            System.arraycopy(a2, 0, byArray, 0, a2.length);
            System.arraycopy(b2, 0, byArray, a2.length, b2.length);
            return byArray;
        }
        if (b2 != null) {
            return Arrays.clone(b2);
        }
        return Arrays.clone(a2);
    }

    public static byte[] concatenate(byte[] a2, byte[] b2, byte[] c2) {
        if (a2 != null && b2 != null && c2 != null) {
            byte[] byArray = new byte[a2.length + b2.length + c2.length];
            System.arraycopy(a2, 0, byArray, 0, a2.length);
            System.arraycopy(b2, 0, byArray, a2.length, b2.length);
            System.arraycopy(c2, 0, byArray, a2.length + b2.length, c2.length);
            return byArray;
        }
        if (a2 == null) {
            return Arrays.concatenate(b2, c2);
        }
        if (b2 == null) {
            return Arrays.concatenate(a2, c2);
        }
        return Arrays.concatenate(a2, b2);
    }

    public static byte[] concatenate(byte[] a2, byte[] b2, byte[] c2, byte[] d2) {
        if (a2 != null && b2 != null && c2 != null && d2 != null) {
            byte[] byArray = new byte[a2.length + b2.length + c2.length + d2.length];
            System.arraycopy(a2, 0, byArray, 0, a2.length);
            System.arraycopy(b2, 0, byArray, a2.length, b2.length);
            System.arraycopy(c2, 0, byArray, a2.length + b2.length, c2.length);
            System.arraycopy(d2, 0, byArray, a2.length + b2.length + c2.length, d2.length);
            return byArray;
        }
        if (d2 == null) {
            return Arrays.concatenate(a2, b2, c2);
        }
        if (c2 == null) {
            return Arrays.concatenate(a2, b2, d2);
        }
        if (b2 == null) {
            return Arrays.concatenate(a2, c2, d2);
        }
        return Arrays.concatenate(b2, c2, d2);
    }

    public static byte[] concatenate(byte[][] arrays) {
        int n2 = 0;
        for (int i2 = 0; i2 != arrays.length; ++i2) {
            n2 += arrays[i2].length;
        }
        byte[] byArray = new byte[n2];
        int n3 = 0;
        for (int i3 = 0; i3 != arrays.length; ++i3) {
            System.arraycopy(arrays[i3], 0, byArray, n3, arrays[i3].length);
            n3 += arrays[i3].length;
        }
        return byArray;
    }

    public static int[] concatenate(int[] a2, int[] b2) {
        if (a2 == null) {
            return Arrays.clone(b2);
        }
        if (b2 == null) {
            return Arrays.clone(a2);
        }
        int[] nArray = new int[a2.length + b2.length];
        System.arraycopy(a2, 0, nArray, 0, a2.length);
        System.arraycopy(b2, 0, nArray, a2.length, b2.length);
        return nArray;
    }

    public static byte[] prepend(byte[] a2, byte b2) {
        if (a2 == null) {
            return new byte[]{b2};
        }
        int n2 = a2.length;
        byte[] byArray = new byte[n2 + 1];
        System.arraycopy(a2, 0, byArray, 1, n2);
        byArray[0] = b2;
        return byArray;
    }

    public static short[] prepend(short[] a2, short b2) {
        if (a2 == null) {
            return new short[]{b2};
        }
        int n2 = a2.length;
        short[] sArray = new short[n2 + 1];
        System.arraycopy(a2, 0, sArray, 1, n2);
        sArray[0] = b2;
        return sArray;
    }

    public static int[] prepend(int[] a2, int b2) {
        if (a2 == null) {
            return new int[]{b2};
        }
        int n2 = a2.length;
        int[] nArray = new int[n2 + 1];
        System.arraycopy(a2, 0, nArray, 1, n2);
        nArray[0] = b2;
        return nArray;
    }

    public static byte[] reverse(byte[] a2) {
        if (a2 == null) {
            return null;
        }
        int n2 = 0;
        int n3 = a2.length;
        byte[] byArray = new byte[n3];
        while (--n3 >= 0) {
            byArray[n3] = a2[n2++];
        }
        return byArray;
    }

    public static int[] reverse(int[] a2) {
        if (a2 == null) {
            return null;
        }
        int n2 = 0;
        int n3 = a2.length;
        int[] nArray = new int[n3];
        while (--n3 >= 0) {
            nArray[n3] = a2[n2++];
        }
        return nArray;
    }

    public static void clear(byte[] array) {
        if (array != null) {
            for (int i2 = 0; i2 < array.length; ++i2) {
                array[i2] = 0;
            }
        }
    }

    public static class Iterator<T>
    implements java.util.Iterator<T> {
        private final T[] a;
        private int b = 0;

        public Iterator(T[] dataArray) {
            this.a = dataArray;
        }

        @Override
        public boolean hasNext() {
            return this.b < this.a.length;
        }

        @Override
        public T next() {
            if (this.b == this.a.length) {
                throw new NoSuchElementException("Out of elements: " + this.b);
            }
            return this.a[this.b++];
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Cannot remove element from an Array.");
        }
    }
}

