/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.util;

import java.math.BigInteger;
import java.security.SecureRandom;

public final class BigIntegers {
    private static final BigInteger a = BigInteger.valueOf(0L);

    public static byte[] asUnsignedByteArray(BigInteger value) {
        byte[] byArray = value.toByteArray();
        if (byArray[0] == 0) {
            byte[] byArray2 = new byte[byArray.length - 1];
            System.arraycopy(byArray, 1, byArray2, 0, byArray2.length);
            return byArray2;
        }
        return byArray;
    }

    public static byte[] asUnsignedByteArray(int length, BigInteger value) {
        byte[] byArray = value.toByteArray();
        if (byArray.length == length) {
            return byArray;
        }
        int n2 = byArray[0] == 0 ? 1 : 0;
        int n3 = byArray.length - n2;
        if (n3 > length) {
            throw new IllegalArgumentException("standard length exceeded for value");
        }
        byte[] byArray2 = new byte[length];
        System.arraycopy(byArray, n2, byArray2, byArray2.length - n3, n3);
        return byArray2;
    }

    public static BigInteger createRandomInRange(BigInteger min, BigInteger max, SecureRandom random) {
        int n2 = min.compareTo(max);
        if (n2 >= 0) {
            if (n2 > 0) {
                throw new IllegalArgumentException("'min' may not be greater than 'max'");
            }
            return min;
        }
        if (min.bitLength() > max.bitLength() / 2) {
            return BigIntegers.createRandomInRange(a, max.subtract(min), random).add(min);
        }
        for (int i2 = 0; i2 < 1000; ++i2) {
            BigInteger bigInteger = new BigInteger(max.bitLength(), random);
            if (bigInteger.compareTo(min) < 0 || bigInteger.compareTo(max) > 0) continue;
            return bigInteger;
        }
        return new BigInteger(max.subtract(min).bitLength() - 1, random).add(min);
    }

    public static BigInteger fromUnsignedByteArray(byte[] buf) {
        return new BigInteger(1, buf);
    }

    public static BigInteger fromUnsignedByteArray(byte[] buf, int off, int length) {
        byte[] byArray = buf;
        if (off != 0 || length != buf.length) {
            byArray = new byte[length];
            System.arraycopy(buf, off, byArray, 0, length);
        }
        return new BigInteger(1, byArray);
    }
}

