/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.util;

import com.enterprisedt.bouncycastle.crypto.digests.SHA512tDigest;
import com.enterprisedt.bouncycastle.util.Arrays;

public class Fingerprint {
    private static char[] a = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'a', 'b', 'c', 'd', 'e', 'f'};
    private final byte[] b;

    public Fingerprint(byte[] source) {
        this.b = Fingerprint.calculateFingerprint(source);
    }

    public byte[] getFingerprint() {
        return Arrays.clone(this.b);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        for (int i2 = 0; i2 != this.b.length; ++i2) {
            if (i2 > 0) {
                stringBuffer.append(":");
            }
            stringBuffer.append(a[this.b[i2] >>> 4 & 0xF]);
            stringBuffer.append(a[this.b[i2] & 0xF]);
        }
        return stringBuffer.toString();
    }

    public boolean equals(Object o2) {
        if (o2 == this) {
            return true;
        }
        if (o2 instanceof Fingerprint) {
            return Arrays.areEqual(((Fingerprint)o2).b, this.b);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.b);
    }

    public static byte[] calculateFingerprint(byte[] input) {
        SHA512tDigest sHA512tDigest = new SHA512tDigest(160);
        sHA512tDigest.update(input, 0, input.length);
        byte[] byArray = new byte[sHA512tDigest.getDigestSize()];
        sHA512tDigest.doFinal(byArray, 0);
        return byArray;
    }
}

