/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.util.encoders;

import com.enterprisedt.bouncycastle.util.encoders.Encoder;
import java.io.IOException;
import java.io.OutputStream;

public class Base64Encoder
implements Encoder {
    protected final byte[] encodingTable = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    protected byte padding = (byte)61;
    protected final byte[] decodingTable = new byte[128];

    protected void initialiseDecodingTable() {
        int n2;
        for (n2 = 0; n2 < this.decodingTable.length; ++n2) {
            this.decodingTable[n2] = -1;
        }
        for (n2 = 0; n2 < this.encodingTable.length; ++n2) {
            this.decodingTable[this.encodingTable[n2]] = (byte)n2;
        }
    }

    public Base64Encoder() {
        this.initialiseDecodingTable();
    }

    @Override
    public int encode(byte[] data, int off, int length, OutputStream out) throws IOException {
        int n2;
        int n3 = length % 3;
        int n4 = length - n3;
        for (n2 = off; n2 < off + n4; n2 += 3) {
            int n5 = data[n2] & 0xFF;
            int n6 = data[n2 + 1] & 0xFF;
            int n7 = data[n2 + 2] & 0xFF;
            out.write(this.encodingTable[n5 >>> 2 & 0x3F]);
            out.write(this.encodingTable[(n5 << 4 | n6 >>> 4) & 0x3F]);
            out.write(this.encodingTable[(n6 << 2 | n7 >>> 6) & 0x3F]);
            out.write(this.encodingTable[n7 & 0x3F]);
        }
        switch (n3) {
            case 0: {
                break;
            }
            case 1: {
                int n8 = data[off + n4] & 0xFF;
                n2 = n8 >>> 2 & 0x3F;
                int n9 = n8 << 4 & 0x3F;
                out.write(this.encodingTable[n2]);
                out.write(this.encodingTable[n9]);
                out.write(this.padding);
                out.write(this.padding);
                break;
            }
            case 2: {
                int n10 = data[off + n4] & 0xFF;
                int n11 = data[off + n4 + 1] & 0xFF;
                n2 = n10 >>> 2 & 0x3F;
                int n12 = (n10 << 4 | n11 >>> 4) & 0x3F;
                int n13 = n11 << 2 & 0x3F;
                out.write(this.encodingTable[n2]);
                out.write(this.encodingTable[n12]);
                out.write(this.encodingTable[n13]);
                out.write(this.padding);
            }
        }
        return n4 / 3 * 4 + (n3 == 0 ? 0 : 4);
    }

    private boolean a(char c2) {
        return c2 == '\n' || c2 == '\r' || c2 == '\t' || c2 == ' ';
    }

    @Override
    public int decode(byte[] data, int off, int length, OutputStream out) throws IOException {
        int n2;
        int n3;
        int n4 = 0;
        for (n3 = off + length; n3 > off && this.a((char)data[n3 - 1]); --n3) {
        }
        if (n3 == 0) {
            return 0;
        }
        int n5 = 0;
        for (n2 = n3; n2 > off && n5 != 4; --n2) {
            if (this.a((char)data[n2 - 1])) continue;
            ++n5;
        }
        n5 = this.a(data, off, n2);
        while (n5 < n2) {
            byte by;
            byte by2 = this.decodingTable[data[n5++]];
            n5 = this.a(data, n5, n2);
            byte by3 = this.decodingTable[data[n5++]];
            n5 = this.a(data, n5, n2);
            byte by4 = this.decodingTable[data[n5++]];
            n5 = this.a(data, n5, n2);
            if ((by2 | by3 | by4 | (by = this.decodingTable[data[n5++]])) < 0) {
                throw new IOException("invalid characters encountered in base64 data");
            }
            out.write(by2 << 2 | by3 >> 4);
            out.write(by3 << 4 | by4 >> 2);
            out.write(by4 << 6 | by);
            n4 += 3;
            n5 = this.a(data, n5, n2);
        }
        int n6 = this.a(data, n5, n3);
        int n7 = this.a(data, n6 + 1, n3);
        int n8 = this.a(data, n7 + 1, n3);
        int n9 = this.a(data, n8 + 1, n3);
        return n4 += this.a(out, (char)data[n6], (char)data[n7], (char)data[n8], (char)data[n9]);
    }

    private int a(byte[] byArray, int n2, int n3) {
        while (n2 < n3 && this.a((char)byArray[n2])) {
            ++n2;
        }
        return n2;
    }

    @Override
    public int decode(String data, OutputStream out) throws IOException {
        int n2;
        int n3;
        int n4 = 0;
        for (n3 = data.length(); n3 > 0 && this.a(data.charAt(n3 - 1)); --n3) {
        }
        if (n3 == 0) {
            return 0;
        }
        int n5 = 0;
        for (n2 = n3; n2 > 0 && n5 != 4; --n2) {
            if (this.a(data.charAt(n2 - 1))) continue;
            ++n5;
        }
        n5 = this.a(data, 0, n2);
        while (n5 < n2) {
            byte by;
            byte by2 = this.decodingTable[data.charAt(n5++)];
            n5 = this.a(data, n5, n2);
            byte by3 = this.decodingTable[data.charAt(n5++)];
            n5 = this.a(data, n5, n2);
            byte by4 = this.decodingTable[data.charAt(n5++)];
            n5 = this.a(data, n5, n2);
            if ((by2 | by3 | by4 | (by = this.decodingTable[data.charAt(n5++)])) < 0) {
                throw new IOException("invalid characters encountered in base64 data");
            }
            out.write(by2 << 2 | by3 >> 4);
            out.write(by3 << 4 | by4 >> 2);
            out.write(by4 << 6 | by);
            n4 += 3;
            n5 = this.a(data, n5, n2);
        }
        int n6 = this.a(data, n5, n3);
        int n7 = this.a(data, n6 + 1, n3);
        int n8 = this.a(data, n7 + 1, n3);
        int n9 = this.a(data, n8 + 1, n3);
        return n4 += this.a(out, data.charAt(n6), data.charAt(n7), data.charAt(n8), data.charAt(n9));
    }

    private int a(OutputStream outputStream, char c2, char c3, char c4, char c5) throws IOException {
        if (c4 == this.padding) {
            if (c5 != this.padding) {
                throw new IOException("invalid characters encountered at end of base64 data");
            }
            byte by = this.decodingTable[c2];
            byte by2 = this.decodingTable[c3];
            if ((by | by2) < 0) {
                throw new IOException("invalid characters encountered at end of base64 data");
            }
            outputStream.write(by << 2 | by2 >> 4);
            return 1;
        }
        if (c5 == this.padding) {
            byte by = this.decodingTable[c2];
            byte by3 = this.decodingTable[c3];
            byte by4 = this.decodingTable[c4];
            if ((by | by3 | by4) < 0) {
                throw new IOException("invalid characters encountered at end of base64 data");
            }
            outputStream.write(by << 2 | by3 >> 4);
            outputStream.write(by3 << 4 | by4 >> 2);
            return 2;
        }
        byte by = this.decodingTable[c2];
        byte by5 = this.decodingTable[c3];
        byte by6 = this.decodingTable[c4];
        byte by7 = this.decodingTable[c5];
        if ((by | by5 | by6 | by7) < 0) {
            throw new IOException("invalid characters encountered at end of base64 data");
        }
        outputStream.write(by << 2 | by5 >> 4);
        outputStream.write(by5 << 4 | by6 >> 2);
        outputStream.write(by6 << 6 | by7);
        return 3;
    }

    private int a(String string, int n2, int n3) {
        while (n2 < n3 && this.a(string.charAt(n2))) {
            ++n2;
        }
        return n2;
    }
}

