/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.util.encoders;

import com.enterprisedt.bouncycastle.util.encoders.Encoder;
import java.io.IOException;
import java.io.OutputStream;

public class HexEncoder
implements Encoder {
    protected final byte[] encodingTable = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};
    protected final byte[] decodingTable = new byte[128];

    protected void initialiseDecodingTable() {
        int n2;
        for (n2 = 0; n2 < this.decodingTable.length; ++n2) {
            this.decodingTable[n2] = -1;
        }
        for (n2 = 0; n2 < this.encodingTable.length; ++n2) {
            this.decodingTable[this.encodingTable[n2]] = (byte)n2;
        }
        this.decodingTable[65] = this.decodingTable[97];
        this.decodingTable[66] = this.decodingTable[98];
        this.decodingTable[67] = this.decodingTable[99];
        this.decodingTable[68] = this.decodingTable[100];
        this.decodingTable[69] = this.decodingTable[101];
        this.decodingTable[70] = this.decodingTable[102];
    }

    public HexEncoder() {
        this.initialiseDecodingTable();
    }

    @Override
    public int encode(byte[] data, int off, int length, OutputStream out) throws IOException {
        for (int i2 = off; i2 < off + length; ++i2) {
            int n2 = data[i2] & 0xFF;
            out.write(this.encodingTable[n2 >>> 4]);
            out.write(this.encodingTable[n2 & 0xF]);
        }
        return length * 2;
    }

    private static boolean a(char c2) {
        return c2 == '\n' || c2 == '\r' || c2 == '\t' || c2 == ' ';
    }

    @Override
    public int decode(byte[] data, int off, int length, OutputStream out) throws IOException {
        int n2;
        int n3 = 0;
        for (n2 = off + length; n2 > off && HexEncoder.a((char)data[n2 - 1]); --n2) {
        }
        int n4 = off;
        while (n4 < n2) {
            byte by;
            while (n4 < n2 && HexEncoder.a((char)data[n4])) {
                ++n4;
            }
            byte by2 = this.decodingTable[data[n4++]];
            while (n4 < n2 && HexEncoder.a((char)data[n4])) {
                ++n4;
            }
            if ((by2 | (by = this.decodingTable[data[n4++]])) < 0) {
                throw new IOException("invalid characters encountered in Hex data");
            }
            out.write(by2 << 4 | by);
            ++n3;
        }
        return n3;
    }

    @Override
    public int decode(String data, OutputStream out) throws IOException {
        int n2;
        int n3 = 0;
        for (n2 = data.length(); n2 > 0 && HexEncoder.a(data.charAt(n2 - 1)); --n2) {
        }
        int n4 = 0;
        while (n4 < n2) {
            byte by;
            while (n4 < n2 && HexEncoder.a(data.charAt(n4))) {
                ++n4;
            }
            byte by2 = this.decodingTable[data.charAt(n4++)];
            while (n4 < n2 && HexEncoder.a(data.charAt(n4))) {
                ++n4;
            }
            if ((by2 | (by = this.decodingTable[data.charAt(n4++)])) < 0) {
                throw new IOException("invalid characters encountered in Hex string");
            }
            out.write(by2 << 4 | by);
            ++n3;
        }
        return n3;
    }
}

