/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.util.encoders;

import com.enterprisedt.bouncycastle.util.encoders.Translator;

public class HexTranslator
implements Translator {
    private static final byte[] a = new byte[]{48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 97, 98, 99, 100, 101, 102};

    @Override
    public int getEncodedBlockSize() {
        return 2;
    }

    @Override
    public int encode(byte[] in, int inOff, int length, byte[] out, int outOff) {
        int n2 = 0;
        int n3 = 0;
        while (n2 < length) {
            out[outOff + n3] = a[in[inOff] >> 4 & 0xF];
            out[outOff + n3 + 1] = a[in[inOff] & 0xF];
            ++inOff;
            ++n2;
            n3 += 2;
        }
        return length * 2;
    }

    @Override
    public int getDecodedBlockSize() {
        return 1;
    }

    @Override
    public int decode(byte[] in, int inOff, int length, byte[] out, int outOff) {
        int n2 = length / 2;
        for (int i2 = 0; i2 < n2; ++i2) {
            byte by = in[inOff + i2 * 2];
            byte by2 = in[inOff + i2 * 2 + 1];
            out[outOff] = by < 97 ? (byte)(by - 48 << 4) : (byte)(by - 97 + 10 << 4);
            if (by2 < 97) {
                int n3 = outOff;
                out[n3] = (byte)(out[n3] + (byte)(by2 - 48));
            } else {
                int n4 = outOff;
                out[n4] = (byte)(out[n4] + (byte)(by2 - 97 + 10));
            }
            ++outOff;
        }
        return n2;
    }
}

