/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.bouncycastle.util.io;

import com.enterprisedt.bouncycastle.util.io.StreamOverflowException;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public final class Streams {
    private static int a = 4096;

    public static void drain(InputStream inStr) throws IOException {
        byte[] byArray = new byte[a];
        while (inStr.read(byArray, 0, byArray.length) >= 0) {
        }
    }

    public static byte[] readAll(InputStream inStr) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Streams.pipeAll(inStr, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static byte[] readAllLimited(InputStream inStr, int limit) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        Streams.pipeAllLimited(inStr, limit, byteArrayOutputStream);
        return byteArrayOutputStream.toByteArray();
    }

    public static int readFully(InputStream inStr, byte[] buf) throws IOException {
        return Streams.readFully(inStr, buf, 0, buf.length);
    }

    public static int readFully(InputStream inStr, byte[] buf, int off, int len) throws IOException {
        int n2;
        int n3;
        for (n2 = 0; n2 < len && (n3 = inStr.read(buf, off + n2, len - n2)) >= 0; n2 += n3) {
        }
        return n2;
    }

    public static void pipeAll(InputStream inStr, OutputStream outStr) throws IOException {
        int n2;
        byte[] byArray = new byte[a];
        while ((n2 = inStr.read(byArray, 0, byArray.length)) >= 0) {
            outStr.write(byArray, 0, n2);
        }
    }

    public static long pipeAllLimited(InputStream inStr, long limit, OutputStream outStr) throws IOException {
        int n2;
        long l2 = 0L;
        byte[] byArray = new byte[a];
        while ((n2 = inStr.read(byArray, 0, byArray.length)) >= 0) {
            if (limit - l2 < (long)n2) {
                throw new StreamOverflowException("Data Overflow");
            }
            l2 += (long)n2;
            outStr.write(byArray, 0, n2);
        }
        return l2;
    }

    public static void writeBufTo(ByteArrayOutputStream buf, OutputStream output) throws IOException {
        buf.writeTo(output);
    }
}

