/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.SecureFileTransferClient;
import com.enterprisedt.net.ftp.WriteMode;
import com.enterprisedt.net.ftp.async.AsyncCallback;
import com.enterprisedt.net.ftp.async.ChangeDirectoryResult;
import com.enterprisedt.net.ftp.async.ConnectResult;
import com.enterprisedt.net.ftp.async.CreateDirectoryResult;
import com.enterprisedt.net.ftp.async.DeleteDirectoryResult;
import com.enterprisedt.net.ftp.async.DeleteFileResult;
import com.enterprisedt.net.ftp.async.DeleteMultipleFilesResult;
import com.enterprisedt.net.ftp.async.DirectoryListResult;
import com.enterprisedt.net.ftp.async.DirectoryNameListResult;
import com.enterprisedt.net.ftp.async.DisconnectResult;
import com.enterprisedt.net.ftp.async.DownloadByteArrayResult;
import com.enterprisedt.net.ftp.async.DownloadFileResult;
import com.enterprisedt.net.ftp.async.DownloadMultipleResult;
import com.enterprisedt.net.ftp.async.DownloadStreamResult;
import com.enterprisedt.net.ftp.async.ExecuteCommandResult;
import com.enterprisedt.net.ftp.async.ExistsResult;
import com.enterprisedt.net.ftp.async.GetSystemTypeResult;
import com.enterprisedt.net.ftp.async.ModifiedTimeResult;
import com.enterprisedt.net.ftp.async.PermissionsResult;
import com.enterprisedt.net.ftp.async.RenameResult;
import com.enterprisedt.net.ftp.async.SizeResult;
import com.enterprisedt.net.ftp.async.UploadByteArrayResult;
import com.enterprisedt.net.ftp.async.UploadFileResult;
import com.enterprisedt.net.ftp.async.UploadMultipleResult;
import com.enterprisedt.net.ftp.async.UploadStreamResult;
import com.enterprisedt.net.ftp.async.internal.SecureConnectionContext;
import com.enterprisedt.util.debug.Logger;
import java.io.FileFilter;
import java.io.IOException;
import java.util.Date;

public class AsyncFileTransferClient
extends SecureFileTransferClient {
    private static Logger a = Logger.getLogger("AsyncFileTransferClient");

    public AsyncFileTransferClient(int initialPoolSize, int maxPoolSize) {
        super(initialPoolSize, maxPoolSize);
    }

    public AsyncFileTransferClient() {
    }

    @Override
    public void setContentType(FTPTransferType type) throws IOException, FTPException {
        SecureConnectionContext secureConnectionContext = this.asyncImpl.getApplicableContext();
        secureConnectionContext.setContentType(type);
        a.debug("Setting content type to " + type.toString());
    }

    @Override
    public FTPTransferType getContentType() {
        SecureConnectionContext secureConnectionContext = this.asyncImpl.getApplicableContext();
        return secureConnectionContext.getContentType();
    }

    @Override
    public void setDetectContentType(boolean detectContentType) {
        SecureConnectionContext secureConnectionContext = this.asyncImpl.getApplicableContext();
        secureConnectionContext.setDetectContentType(detectContentType);
    }

    @Override
    public boolean isDetectContentType() {
        SecureConnectionContext secureConnectionContext = this.asyncImpl.getApplicableContext();
        return secureConnectionContext.getDetectContentType();
    }

    public ConnectResult connectAsync(AsyncCallback.Connect callback, Object tag) throws FTPException {
        return this.asyncImpl.connectAsync(this, callback, tag);
    }

    public ExecuteCommandResult executeCommandAsync(String command, AsyncCallback.ExecuteCommand callback, Object tag) throws FTPException {
        return this.asyncImpl.executeCommandAsync(this, command, callback, tag);
    }

    public GetSystemTypeResult getSystemTypeAsync(AsyncCallback.GetSystemType callback, Object tag) throws FTPException {
        return this.asyncImpl.getSystemTypeAsync(this, callback, tag);
    }

    public DirectoryNameListResult directoryNameListAsync(String directoryName, boolean isLongListing, AsyncCallback.DirectoryNameList callback, Object tag) throws FTPException {
        return this.asyncImpl.directoryNameListAsync(this, directoryName, isLongListing, callback, tag);
    }

    public DirectoryListResult directoryListAsync(String directoryName, AsyncCallback.DirectoryList callback, Object tag) throws FTPException {
        return this.asyncImpl.directoryListAsync(this, directoryName, callback, tag);
    }

    public DownloadByteArrayResult downloadByteArrayAsync(String remoteFileName, AsyncCallback.DownloadByteArray callback, Object tag) throws FTPException {
        return this.asyncImpl.downloadByteArrayAsync(this, remoteFileName, callback, tag);
    }

    public DownloadFileResult downloadFileAsync(String localFileName, String remoteFileName, WriteMode writeMode, AsyncCallback.DownloadFile callback, Object tag) throws FTPException {
        return this.asyncImpl.downloadFileAsync(this, localFileName, remoteFileName, writeMode, callback, tag);
    }

    public DownloadStreamResult downloadStreamAsync(String remoteFileName, AsyncCallback.DownloadStream callback, Object tag) throws FTPException {
        return this.asyncImpl.downloadStreamAsync(this, remoteFileName, callback, tag);
    }

    public UploadFileResult uploadFileAsync(String localFileName, String remoteFileName, AsyncCallback.UploadFile callback, Object tag) throws FTPException {
        return this.uploadFileAsync(localFileName, remoteFileName, WriteMode.OVERWRITE, callback, tag);
    }

    public UploadFileResult uploadFileAsync(String localFileName, String remoteFileName, WriteMode writeMode, AsyncCallback.UploadFile callback, Object tag) throws FTPException {
        return this.asyncImpl.uploadFileAsync(this, localFileName, remoteFileName, writeMode, callback, tag);
    }

    public UploadByteArrayResult uploadByteArrayAsync(byte[] bytes, String remoteFileName, WriteMode writeMode, AsyncCallback.UploadByteArray callback, Object tag) throws FTPException {
        return this.asyncImpl.uploadByteArrayAsync(this, bytes, remoteFileName, writeMode, callback, tag);
    }

    public UploadStreamResult uploadStreamAsync(String remoteFileName, AsyncCallback.UploadStream callback, Object tag) throws FTPException {
        return this.uploadStreamAsync(remoteFileName, WriteMode.OVERWRITE, callback, tag);
    }

    public UploadStreamResult uploadStreamAsync(String remoteFileName, WriteMode writeMode, AsyncCallback.UploadStream callback, Object tag) throws FTPException {
        return this.asyncImpl.uploadStreamAsync(this, remoteFileName, writeMode, callback, tag);
    }

    public SizeResult getSizeAsync(String remoteFileName, AsyncCallback.Size callback, Object tag) throws FTPException {
        return this.asyncImpl.getSizeAsync(this, remoteFileName, callback, tag);
    }

    public ModifiedTimeResult getModifiedTimeAsync(String remoteFileName, AsyncCallback.GetModifiedTime callback, Object tag) throws FTPException {
        return this.asyncImpl.getModifiedTimeAsync(this, remoteFileName, callback, tag);
    }

    public ModifiedTimeResult setModifiedTimeAsync(String remoteFileName, Date modifiedTime, AsyncCallback.SetModifiedTime callback, Object tag) throws FTPException {
        return this.asyncImpl.setModifiedTimeAsync(this, remoteFileName, modifiedTime, callback, tag);
    }

    public PermissionsResult setPermissionsAsync(String remotePath, int permissions, AsyncCallback.SetPermissions callback, Object tag) throws FTPException, IOException {
        return this.asyncImpl.setPermissionsAsync(this, remotePath, permissions, callback, tag);
    }

    public ExistsResult existsAsync(String remoteFileName, AsyncCallback.Exists callback, Object tag) throws FTPException {
        return this.asyncImpl.existsAsync(this, remoteFileName, callback, tag);
    }

    public DeleteFileResult deleteFileAsync(String remoteFileName, AsyncCallback.DeleteFile callback, Object tag) throws FTPException {
        return this.asyncImpl.deleteFileAsync(this, remoteFileName, callback, tag);
    }

    public DeleteMultipleFilesResult deleteMultipleFilesAsync(FileFilter filter, AsyncCallback.DeleteMultipleFiles callback, Object tag) throws FTPException {
        return this.asyncImpl.deleteMultipleFilesAsync(this, filter, callback, tag);
    }

    public DeleteMultipleFilesResult deleteMultipleFilesAsync(String wildcard, AsyncCallback.DeleteMultipleFiles callback, Object tag) throws FTPException {
        return this.asyncImpl.deleteMultipleFilesAsync(this, wildcard, callback, tag);
    }

    public DeleteMultipleFilesResult deleteMultipleFilesAsync(String remoteDirectory, String wildcard, boolean recursive, AsyncCallback.DeleteMultipleFiles callback, Object tag) throws FTPException {
        return this.asyncImpl.deleteMultipleFilesAsync(this, remoteDirectory, wildcard, recursive, callback, tag);
    }

    public DeleteMultipleFilesResult deleteMultipleFilesAsync(String remoteDirectory, FileFilter filter, boolean recursive, AsyncCallback.DeleteMultipleFiles callback, Object tag) throws FTPException {
        return this.asyncImpl.deleteMultipleFilesAsync(this, remoteDirectory, filter, recursive, callback, tag);
    }

    public RenameResult renameAsync(String renameFromName, String renameToName, AsyncCallback.Rename callback, Object tag) throws FTPException {
        return this.asyncImpl.renameAsync(this, renameFromName, renameToName, callback, tag);
    }

    @Override
    public void changeDirectory(String directoryName) throws FTPException, IOException {
        super.changeDirectory(directoryName);
    }

    public ChangeDirectoryResult changeDirectoryAsync(String directoryName, AsyncCallback.ChangeDirectory callback, Object tag) throws FTPException {
        return this.asyncImpl.changeDirectoryAsync(this, directoryName, callback, tag);
    }

    public ChangeDirectoryResult changeToParentDirectoryAsync(AsyncCallback.ChangeDirectory callback, Object tag) throws FTPException {
        return this.asyncImpl.changeToParentDirectoryAsync(this, callback, tag);
    }

    public CreateDirectoryResult createDirectoryAsync(String directoryName, AsyncCallback.CreateDirectory callback, Object tag) throws FTPException {
        return this.asyncImpl.createDirectoryAsync(this, directoryName, callback, tag);
    }

    public DeleteDirectoryResult deleteDirectoryAsync(String directoryName, AsyncCallback.DeleteDirectory callback, Object tag) throws FTPException {
        return this.asyncImpl.deleteDirectoryAsync(this, directoryName, callback, tag);
    }

    public DeleteDirectoryResult deleteDirectoryAsync(String directoryName, boolean recursive, AsyncCallback.DeleteDirectory callback, Object tag) throws FTPException {
        return this.asyncImpl.deleteDirectoryAsync(this, directoryName, recursive, callback, tag);
    }

    public UploadMultipleResult uploadMultipleAsync(String localDir, FileFilter filter, AsyncCallback.UploadMultiple callback, Object tag) throws FTPException {
        return this.asyncImpl.uploadMultipleAsync(this, localDir, filter, callback, tag);
    }

    public UploadMultipleResult uploadMultipleAsync(String localDir, String wildcard, AsyncCallback.UploadMultiple callback, Object tag) throws FTPException {
        return this.asyncImpl.uploadMultipleAsync(this, localDir, wildcard, callback, tag);
    }

    public UploadMultipleResult uploadMultipleAsync(String localDir, String remoteDir, String wildcard, boolean recursive, AsyncCallback.UploadMultiple callback, Object tag) throws FTPException {
        return this.asyncImpl.uploadMultipleAsync(this, localDir, remoteDir, wildcard, recursive, callback, tag);
    }

    public UploadMultipleResult uploadMultipleAsync(String localDir, String remoteDir, FileFilter filter, boolean recursive, AsyncCallback.UploadMultiple callback, Object tag) throws FTPException {
        return this.asyncImpl.uploadMultipleAsync(this, localDir, remoteDir, filter, recursive, callback, tag);
    }

    public DownloadMultipleResult downloadMultipleAsync(String localDir, FileFilter filter, AsyncCallback.DownloadMultiple callback, Object tag) throws FTPException {
        return this.asyncImpl.downloadMultipleAsync(this, localDir, filter, callback, tag);
    }

    public DownloadMultipleResult downloadMultipleAsync(String localDir, String wildcard, AsyncCallback.DownloadMultiple callback, Object tag) throws FTPException {
        return this.asyncImpl.downloadMultipleAsync(this, localDir, wildcard, callback, tag);
    }

    public DownloadMultipleResult downloadMultipleAsync(String localDir, String remoteDir, String wildcard, boolean recursive, AsyncCallback.DownloadMultiple callback, Object tag) throws FTPException {
        return this.asyncImpl.downloadMultipleAsync(this, localDir, remoteDir, wildcard, recursive, callback, tag);
    }

    public DownloadMultipleResult downloadMultipleAsync(String localDir, String remoteDir, FileFilter filter, boolean recursive, AsyncCallback.DownloadMultiple callback, Object tag) throws FTPException {
        return this.asyncImpl.downloadMultipleAsync(this, localDir, remoteDir, filter, recursive, callback, tag);
    }

    public void setDisconnectCallback(AsyncCallback.Disconnect callback) {
        this.asyncImpl.setDisconnectCallback(callback);
    }

    public AsyncCallback.Disconnect getDisconnectCallback() {
        return this.asyncImpl.getDisconnectCallback();
    }

    public DisconnectResult disconnectAsync(AsyncCallback.Disconnect callback, Object tag) throws FTPException {
        return this.disconnectAsync(false, callback, tag);
    }

    public DisconnectResult disconnectAsync(boolean immediate, AsyncCallback.Disconnect callback, Object tag) throws FTPException {
        return this.asyncImpl.disconnectAsync(this, immediate, callback, tag);
    }
}

