/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.FTPClient;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPProgressMonitor;
import com.enterprisedt.net.ftp.FTPProgressMonitorEx;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.FileTransferOutputStream;
import com.enterprisedt.net.ftp.TransferDirection;
import com.enterprisedt.util.debug.Logger;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class FTPOutputStream
extends FileTransferOutputStream {
    private static Logger a = Logger.getLogger("FTPOutputStream");
    private long b;
    private FTPClient c;
    private BufferedOutputStream d;
    private boolean e = false;
    private long f = 0L;
    private FTPProgressMonitor g;
    private FTPProgressMonitorEx h;
    private byte[] i = new byte[FTPClient.FTP_LINE_SEPARATOR.length];
    private int j = 0;

    public FTPOutputStream(FTPClient client, String remoteFile) throws IOException, FTPException {
        this(client, remoteFile, false);
    }

    public FTPOutputStream(FTPClient client, String remoteFile, boolean append) throws IOException, FTPException {
        this.c = client;
        this.remoteFile = remoteFile;
        try {
            this.remoteFile = client.initPut(remoteFile, append);
            this.d = new BufferedOutputStream(new DataOutputStream(client.getOutputStream()), client.getTransferBufferSize() * 2);
        }
        catch (IOException iOException) {
            client.validateTransferOnError(iOException);
            throw iOException;
        }
        this.b = client.getMonitorInterval();
        this.g = client.getProgressMonitor();
        this.e = client.getType().equals(FTPTransferType.ASCII);
    }

    public void setMonitor(FTPProgressMonitorEx monitor, long monitorInterval) {
        this.g = monitor;
        this.h = monitor;
        this.b = monitorInterval;
    }

    @Override
    public void write(int b2) throws IOException {
        byte[] byArray = new byte[]{(byte)b2};
        this.write(byArray, 0, 1);
    }

    @Override
    public void write(byte[] b2, int off, int len) throws IOException {
        if (this.e) {
            for (int i2 = off; i2 < off + len; ++i2) {
                if (b2[i2] == 10 && this.j == 0) {
                    this.d.write(13);
                    this.d.write(10);
                    this.size += 2L;
                    this.f += 2L;
                    continue;
                }
                if (b2[i2] == FTPClient.FTP_LINE_SEPARATOR[this.j]) {
                    this.i[this.j] = b2[i2];
                    ++this.j;
                    if (this.j != FTPClient.FTP_LINE_SEPARATOR.length) continue;
                    this.d.write(13);
                    this.d.write(10);
                    this.size += 2L;
                    this.f += 2L;
                    this.j = 0;
                    continue;
                }
                if (this.j > 0) {
                    this.d.write(13);
                    this.d.write(10);
                    this.size += 2L;
                    this.f += 2L;
                }
                this.d.write(b2[i2]);
                ++this.size;
                ++this.f;
                this.j = 0;
            }
        } else {
            this.d.write(b2, off, len);
            this.size += (long)len;
            this.f += (long)len;
        }
        if (this.g != null && this.f > this.b) {
            this.g.bytesTransferred(this.size);
            this.f = 0L;
        }
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.closed = true;
            if (this.e && this.j > 0) {
                this.d.write(this.i, 0, this.j);
                this.size += (long)this.j;
                this.f += (long)this.j;
            }
            this.c.forceResumeOff();
            this.c.closeDataSocket(this.d);
            if (this.g != null) {
                this.g.bytesTransferred(this.size);
            }
            a.debug("Transferred " + this.size + " bytes from remote host");
            try {
                this.c.validateTransfer();
            }
            catch (FTPException fTPException) {
                throw new IOException(fTPException.getMessage());
            }
            if (this.h != null) {
                this.h.transferComplete(TransferDirection.UPLOAD, this.remoteFile);
            }
        }
    }
}

