/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp;

import com.enterprisedt.net.ftp.AdvancedFTPSettings;
import com.enterprisedt.net.ftp.AdvancedGeneralSettings;
import com.enterprisedt.net.ftp.AdvancedSSHSettings;
import com.enterprisedt.net.ftp.AdvancedSSLSettings;
import com.enterprisedt.net.ftp.DirectoryListCallback;
import com.enterprisedt.net.ftp.EventListener;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPFile;
import com.enterprisedt.net.ftp.FTPReply;
import com.enterprisedt.net.ftp.FTPTransferCancelledException;
import com.enterprisedt.net.ftp.FTPTransferType;
import com.enterprisedt.net.ftp.FileStatistics;
import com.enterprisedt.net.ftp.FileTransferClient;
import com.enterprisedt.net.ftp.FileTransferClientInterface;
import com.enterprisedt.net.ftp.FileTransferInputStream;
import com.enterprisedt.net.ftp.FileTransferOutputStream;
import com.enterprisedt.net.ftp.MultipleTransferSettings;
import com.enterprisedt.net.ftp.Protocol;
import com.enterprisedt.net.ftp.WriteMode;
import com.enterprisedt.net.ftp.a;
import com.enterprisedt.net.ftp.async.ChangeDirectoryResult;
import com.enterprisedt.net.ftp.async.DownloadFileResult;
import com.enterprisedt.net.ftp.async.DownloadStreamResult;
import com.enterprisedt.net.ftp.async.ErrorListener;
import com.enterprisedt.net.ftp.async.ExistsResult;
import com.enterprisedt.net.ftp.async.ModifiedTimeResult;
import com.enterprisedt.net.ftp.async.SizeResult;
import com.enterprisedt.net.ftp.async.UploadByteArrayResult;
import com.enterprisedt.net.ftp.async.UploadFileResult;
import com.enterprisedt.net.ftp.async.UploadStreamResult;
import com.enterprisedt.net.ftp.async.internal.AsyncFileTransferClientImpl;
import com.enterprisedt.net.ftp.async.internal.SecureConnectionContext;
import com.enterprisedt.net.ftp.b;
import com.enterprisedt.util.proxy.ProxySettings;
import java.io.FileFilter;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.ParseException;
import java.util.Date;
import java.util.HashMap;

public class SecureFileTransferClient
implements FileTransferClientInterface {
    protected AsyncFileTransferClientImpl asyncImpl;
    protected SecureConnectionContext masterContext;
    protected HashMap activeTransferTasks = new HashMap();
    protected EventListener eventListener;
    protected MultipleTransferSettings multiSettings;
    protected ProxySettings proxySettings = new ProxySettings();
    protected AdvancedFTPSettings advancedFTPSettings;
    protected AdvancedGeneralSettings advancedSettings;
    protected AdvancedSSLSettings advancedSSLSettings;
    protected AdvancedSSHSettings advancedSSHSettings;

    public SecureFileTransferClient(int initialPoolSize, int maxPoolSize) {
        this.masterContext = new SecureConnectionContext();
        this.multiSettings = new MultipleTransferSettings(this.masterContext);
        this.advancedFTPSettings = new AdvancedFTPSettings(this.masterContext);
        this.advancedSettings = new AdvancedGeneralSettings(this.masterContext);
        this.advancedSSLSettings = new AdvancedSSLSettings(this.masterContext);
        this.advancedSSHSettings = new AdvancedSSHSettings(this.masterContext);
        this.masterContext.setProxySettings(this.proxySettings);
        this.asyncImpl = new AsyncFileTransferClientImpl(this.masterContext, initialPoolSize, maxPoolSize);
    }

    public SecureFileTransferClient() {
        this.masterContext = new SecureConnectionContext();
        this.multiSettings = new MultipleTransferSettings(this.masterContext);
        this.advancedFTPSettings = new AdvancedFTPSettings(this.masterContext);
        this.advancedSettings = new AdvancedGeneralSettings(this.masterContext);
        this.advancedSSLSettings = new AdvancedSSLSettings(this.masterContext);
        this.advancedSSHSettings = new AdvancedSSHSettings(this.masterContext);
        this.masterContext.setProxySettings(this.proxySettings);
        this.asyncImpl = new AsyncFileTransferClientImpl(this.masterContext);
    }

    protected void checkConnection(boolean shouldBeConnected) throws FTPException {
        if (shouldBeConnected && !this.isConnected()) {
            throw new FTPException("The file transfer client has not yet connected to the server.  The requested action cannot be performed until after a connection has been established.");
        }
        if (!shouldBeConnected && this.isConnected()) {
            throw new FTPException("The file transfer client has already been connected to the server.  The requested action must be performed before a connection is established.");
        }
    }

    private static void a(String string, URL uRL, SecureFileTransferClient secureFileTransferClient) throws FTPException, MalformedURLException, IOException {
        if (string.equals("ftp")) {
            secureFileTransferClient.setProtocol(Protocol.FTP);
        } else if (string.equals("ftps") || string.equals("ftpes") || string.equals("ftpse")) {
            secureFileTransferClient.setProtocol(Protocol.FTPS_EXPLICIT);
        } else if (string.equals("ftpis") || string.equals("ftpsi")) {
            secureFileTransferClient.setProtocol(Protocol.FTPS_IMPLICIT);
        } else if (string.equals("sftp")) {
            secureFileTransferClient.setProtocol(Protocol.SFTP);
        } else {
            throw new MalformedURLException("Unsupported protocol: " + uRL.getProtocol());
        }
        FileTransferClient.prepareURLTransfer(uRL, secureFileTransferClient);
    }

    private static String a(String string) throws MalformedURLException {
        int n2 = string.indexOf(58);
        if (n2 < 0) {
            throw new MalformedURLException("No protocol specified");
        }
        return string.substring(0, n2);
    }

    private static String b(String string) throws MalformedURLException {
        int n2 = string.indexOf(58);
        if (n2 < 0) {
            throw new MalformedURLException("No protocol specified");
        }
        return "ftp" + string.substring(n2);
    }

    @Override
    public String getRemoteHost() {
        return this.masterContext.getRemoteHost();
    }

    @Override
    public void setRemoteHost(String remoteHost) throws FTPException {
        this.checkConnection(false);
        this.masterContext.setRemoteHost(remoteHost);
    }

    public Protocol getProtocol() {
        return this.masterContext.getProtocol();
    }

    public void setProtocol(Protocol protocol) throws FTPException {
        this.checkConnection(false);
        this.masterContext.setProtocol(protocol);
    }

    public ProxySettings getProxySettings() {
        return this.proxySettings;
    }

    @Override
    public int getTimeout() {
        return this.masterContext.getTimeout();
    }

    @Override
    public void setTimeout(int timeout) throws FTPException {
        this.checkConnection(false);
        this.masterContext.setTimeout(timeout);
    }

    @Override
    public int getNetworkBufferSize() {
        return this.masterContext.getNetworkBufferSize();
    }

    @Override
    public void setNetworkBufferSize(int networkBufferSize) throws FTPException {
        this.checkConnection(false);
        this.masterContext.setNetworkBufferSize(networkBufferSize);
    }

    @Override
    public int getRemotePort() {
        return this.masterContext.getRemotePort();
    }

    @Override
    public void setRemotePort(int remotePort) throws FTPException {
        this.checkConnection(false);
        this.masterContext.setRemotePort(remotePort);
    }

    @Override
    public void setContentType(FTPTransferType type) throws IOException, FTPException {
        this.masterContext.setContentType(type);
    }

    @Override
    public FTPTransferType getContentType() {
        return this.masterContext.getContentType();
    }

    @Override
    public void setDetectContentType(boolean detectContentType) {
        this.masterContext.setDetectContentType(detectContentType);
    }

    @Override
    public boolean isDetectContentType() {
        return this.masterContext.getDetectContentType();
    }

    @Override
    public void setUserName(String userName) throws FTPException {
        this.checkConnection(false);
        this.masterContext.setUserName(userName);
    }

    @Override
    public String getPassword() {
        return this.masterContext.getPassword();
    }

    @Override
    public void setPassword(String password) throws FTPException {
        this.checkConnection(false);
        this.masterContext.setPassword(password);
    }

    @Override
    public String getUserName() {
        return this.masterContext.getUserName();
    }

    public void setMaxTransferRate(int thresholdBytesPerSecond) {
        this.masterContext.setMaxTransferRate(thresholdBytesPerSecond);
    }

    public int getMaxTransferRate() {
        return this.masterContext.getMaxTransferRate();
    }

    public boolean isTransferIntegrityCheck() {
        return this.masterContext.isTransferIntegrityCheck();
    }

    public void setTransferIntegrityCheck(boolean enabled) {
        this.masterContext.setTransferIntegrityCheck(enabled);
    }

    public boolean isCompressionPreferred() {
        return this.masterContext.isCompressionPreferred();
    }

    public void setCompressionPreferred(boolean enabled) {
        this.masterContext.setCompressionPreferred(enabled);
    }

    @Override
    public AdvancedFTPSettings getAdvancedFTPSettings() {
        return this.advancedFTPSettings;
    }

    @Override
    public AdvancedGeneralSettings getAdvancedSettings() {
        return this.advancedSettings;
    }

    public AdvancedSSLSettings getAdvancedSSLSettings() {
        return this.advancedSSLSettings;
    }

    public AdvancedSSHSettings getAdvancedSSHSettings() {
        return this.advancedSSHSettings;
    }

    public MultipleTransferSettings getMultipleTransferSettings() {
        return this.multiSettings;
    }

    public boolean changeIntoPathDirectory() {
        return this.masterContext.changeIntoPathDirectory();
    }

    public void setChangeIntoPathDirectory(boolean changeIntoPathDirectory) {
        this.masterContext.setChangeIntoPathDirectory(changeIntoPathDirectory);
    }

    public boolean isServerValidationEnabled() {
        return this.masterContext.isServerValidationEnabled();
    }

    public synchronized void setServerValidationEnabled(boolean enabled) throws FTPException {
        this.checkConnection(false);
        this.masterContext.setServerValidationEnabled(enabled);
    }

    public boolean isKeepAliveEnabled() {
        return this.masterContext.isKeepAliveEnabled();
    }

    public synchronized void setKeepAliveEnabled(boolean enabled) throws FTPException {
        this.checkConnection(false);
        this.masterContext.setKeepAliveEnabled(enabled);
    }

    public void loadSSLServerValidation(String rootCertificatesPath) throws FileNotFoundException, IOException, FTPException {
        this.checkConnection(false);
        this.masterContext.loadSSLServerValidation(rootCertificatesPath);
        this.masterContext.setServerValidationEnabled(true);
    }

    public void loadSSHServerValidation(String knownHosts) throws FileNotFoundException, IOException, FTPException {
        this.checkConnection(false);
        this.masterContext.loadSSHServerValidation(knownHosts);
        this.masterContext.setServerValidationEnabled(true);
    }

    @Override
    public boolean isConnected() {
        return this.masterContext.isConnected();
    }

    public String getInitialRemoteDirectory() {
        return this.masterContext.getInitialRemoteDirectory();
    }

    public void setInitialRemoteDirectory(String directory) throws FTPException {
        this.checkConnection(false);
        this.masterContext.setInitialRemoteDirectory(directory);
    }

    @Override
    public String getRemoteDirectory() {
        return this.masterContext.getRemoteDirectory();
    }

    @Override
    public void setEventListener(EventListener listener) {
        this.eventListener = listener;
        this.asyncImpl.setEventListener(listener);
    }

    @Override
    public FileStatistics getStatistics() {
        return this.asyncImpl.getStatistics();
    }

    @Override
    public void connect() throws FTPException, IOException {
        this.asyncImpl.connectAsync(null, null, null).endAsync();
    }

    @Override
    public String executeCommand(String command) throws FTPException, IOException {
        return this.asyncImpl.executeCommandAsync(null, command, null, null).endAsync();
    }

    public FTPReply getLastReply() {
        return this.asyncImpl.getLastReply();
    }

    @Override
    public String getSystemType() throws FTPException, IOException {
        return this.asyncImpl.getSystemTypeAsync(null, null, null).endAsync();
    }

    @Override
    public String[] directoryNameList() throws FTPException, IOException {
        return this.directoryNameList("", false);
    }

    @Override
    public String[] directoryNameList(String directoryName, boolean isLongListing) throws FTPException, IOException {
        return this.asyncImpl.directoryNameListAsync(null, directoryName, isLongListing, null, null).endAsync();
    }

    @Override
    public FTPFile[] directoryList() throws FTPException, IOException, ParseException {
        return this.directoryList("");
    }

    @Override
    public void directoryList(String directoryName, DirectoryListCallback lister) throws FTPException, IOException {
        this.asyncImpl.directoryListAsync(null, directoryName, lister, null, null).endAsync();
    }

    @Override
    public FTPFile[] directoryList(String directoryName) throws FTPException, IOException {
        return this.asyncImpl.directoryListAsync(null, directoryName, null, null).endAsync();
    }

    @Override
    public byte[] downloadByteArray(String remoteFileName) throws FTPException, IOException {
        return this.asyncImpl.downloadByteArrayAsync(null, remoteFileName, null, null).endAsync();
    }

    @Override
    public void downloadFile(String localFileName, String remoteFileName) throws FTPException, IOException {
        this.downloadFile(localFileName, remoteFileName, WriteMode.OVERWRITE);
    }

    @Override
    public void downloadFile(String localFileName, String remoteFileName, WriteMode writeMode) throws FTPException, IOException {
        DownloadFileResult downloadFileResult = this.asyncImpl.downloadFileAsync(null, localFileName, remoteFileName, writeMode, null, null);
        downloadFileResult.endAsync();
        if (downloadFileResult.isCancelled()) {
            throw new FTPTransferCancelledException();
        }
    }

    @Override
    public FileTransferInputStream downloadStream(String remoteFileName) throws FTPException, IOException {
        DownloadStreamResult downloadStreamResult = this.asyncImpl.downloadStreamAsync(null, remoteFileName, null, null);
        try {
            return downloadStreamResult.getInputStream();
        }
        catch (Throwable throwable) {
            throw new FTPException(throwable.getMessage());
        }
    }

    public static FileTransferInputStream downloadURLStream(String ftpURL) throws MalformedURLException, IOException, FTPException {
        String string = SecureFileTransferClient.a(ftpURL);
        URL uRL = new URL(SecureFileTransferClient.b(ftpURL));
        SecureFileTransferClient secureFileTransferClient = new SecureFileTransferClient();
        SecureFileTransferClient.a(string, uRL, secureFileTransferClient);
        secureFileTransferClient.connect();
        return new a(secureFileTransferClient.downloadStream(uRL.getPath()), secureFileTransferClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void downloadURLFile(String localFileName, String ftpURL) throws MalformedURLException, IOException, FTPException {
        String string = SecureFileTransferClient.a(ftpURL);
        URL uRL = new URL(SecureFileTransferClient.b(ftpURL));
        SecureFileTransferClient secureFileTransferClient = new SecureFileTransferClient();
        SecureFileTransferClient.a(string, uRL, secureFileTransferClient);
        secureFileTransferClient.connect();
        try {
            secureFileTransferClient.downloadFile(localFileName, uRL.getPath());
        }
        finally {
            secureFileTransferClient.disconnect();
        }
    }

    @Override
    public String uploadFile(String localFileName, String remoteFileName) throws FTPException, IOException {
        return this.uploadFile(localFileName, remoteFileName, WriteMode.OVERWRITE);
    }

    @Override
    public String uploadFile(String localFileName, String remoteFileName, WriteMode writeMode) throws FTPException, IOException {
        UploadFileResult uploadFileResult = this.asyncImpl.uploadFileAsync(null, localFileName, remoteFileName, writeMode, null, null);
        uploadFileResult.endAsync();
        if (uploadFileResult.isCancelled()) {
            throw new FTPTransferCancelledException();
        }
        return uploadFileResult.getRemoteFileName();
    }

    public String uploadByteArray(byte[] bytes, String remoteFileName, WriteMode writeMode) throws FTPException, IOException {
        UploadByteArrayResult uploadByteArrayResult = this.asyncImpl.uploadByteArrayAsync(null, bytes, remoteFileName, writeMode, null, null);
        uploadByteArrayResult.endAsync();
        if (uploadByteArrayResult.isCancelled()) {
            throw new FTPTransferCancelledException();
        }
        return uploadByteArrayResult.getRemoteFileName();
    }

    @Override
    public FileTransferOutputStream uploadStream(String remoteFileName) throws FTPException {
        UploadStreamResult uploadStreamResult = this.asyncImpl.uploadStreamAsync(null, remoteFileName, WriteMode.OVERWRITE, null, null);
        try {
            return uploadStreamResult.getOutputStream();
        }
        catch (Throwable throwable) {
            throw new FTPException(throwable.getMessage());
        }
    }

    @Override
    public FileTransferOutputStream uploadStream(String remoteFileName, WriteMode writeMode) throws FTPException {
        UploadStreamResult uploadStreamResult = this.asyncImpl.uploadStreamAsync(null, remoteFileName, writeMode, null, null);
        try {
            return uploadStreamResult.getOutputStream();
        }
        catch (Throwable throwable) {
            throw new FTPException(throwable.getMessage());
        }
    }

    public static FileTransferOutputStream uploadURLStream(String ftpURL) throws MalformedURLException, IOException, FTPException {
        String string = SecureFileTransferClient.a(ftpURL);
        URL uRL = new URL(SecureFileTransferClient.b(ftpURL));
        SecureFileTransferClient secureFileTransferClient = new SecureFileTransferClient();
        SecureFileTransferClient.a(string, uRL, secureFileTransferClient);
        secureFileTransferClient.connect();
        return new b(secureFileTransferClient.uploadStream(uRL.getPath()), secureFileTransferClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void uploadURLFile(String localFileName, String ftpURL) throws MalformedURLException, IOException, FTPException {
        String string = SecureFileTransferClient.a(ftpURL);
        URL uRL = new URL(SecureFileTransferClient.b(ftpURL));
        SecureFileTransferClient secureFileTransferClient = new SecureFileTransferClient();
        SecureFileTransferClient.a(string, uRL, secureFileTransferClient);
        secureFileTransferClient.connect();
        try {
            secureFileTransferClient.uploadFile(localFileName, uRL.getPath());
        }
        finally {
            secureFileTransferClient.disconnect();
        }
    }

    @Override
    public long getSize(String remoteFileName) throws FTPException, IOException {
        SizeResult sizeResult = this.asyncImpl.getSizeAsync(null, remoteFileName, null, null);
        sizeResult.endAsync();
        return sizeResult.getSize();
    }

    @Override
    public Date getModifiedTime(String remoteFileName) throws FTPException, IOException {
        ModifiedTimeResult modifiedTimeResult = this.asyncImpl.getModifiedTimeAsync(null, remoteFileName, null, null);
        return modifiedTimeResult.endAsync();
    }

    @Override
    public synchronized void setModifiedTime(String remoteFileName, Date modifiedTime) throws FTPException, IOException {
        this.asyncImpl.setModifiedTimeAsync(null, remoteFileName, modifiedTime, null, null).endAsync();
    }

    public synchronized void setPermissions(String remotePath, int permissions) throws FTPException, IOException {
        this.asyncImpl.setPermissionsAsync(null, remotePath, permissions, null, null).endAsync();
    }

    @Override
    public boolean exists(String remoteFileName) throws FTPException, IOException {
        ExistsResult existsResult = this.asyncImpl.existsAsync(null, remoteFileName, null, null);
        existsResult.endAsync();
        return existsResult.exists();
    }

    public boolean existsDirectory(String remoteDir) throws FTPException, IOException {
        ExistsResult existsResult = this.asyncImpl.existsDirectoryAsync(null, remoteDir, null, null);
        existsResult.endAsync();
        return existsResult.exists();
    }

    @Override
    public void deleteFile(String remoteFileName) throws FTPException, IOException {
        this.asyncImpl.deleteFileAsync(null, remoteFileName, null, null).endAsync();
    }

    public void deleteMultipleFiles(String wildcard) throws FTPException, IOException {
        this.asyncImpl.deleteMultipleFilesAsync(null, wildcard, null, null).endAsync();
    }

    public void deleteMultipleFiles(FileFilter filter) throws FTPException, IOException {
        this.asyncImpl.deleteMultipleFilesAsync(null, filter, null, null).endAsync();
    }

    public void deleteMultipleFiles(String remoteDirectory, String wildcard, boolean recursive) throws FTPException, IOException {
        this.asyncImpl.deleteMultipleFilesAsync(null, remoteDirectory, wildcard, recursive, null, null).endAsync();
    }

    public void deleteMultipleFiles(String remoteDirectory, FileFilter filter, boolean recursive) throws FTPException, IOException {
        this.asyncImpl.deleteMultipleFilesAsync(null, remoteDirectory, filter, recursive, null, null).endAsync();
    }

    @Override
    public void rename(String renameFromName, String renameToName) throws FTPException, IOException {
        this.asyncImpl.renameAsync(null, renameFromName, renameToName, null, null).endAsync();
    }

    @Override
    public void changeDirectory(String directoryName) throws FTPException, IOException {
        ChangeDirectoryResult changeDirectoryResult = this.asyncImpl.changeDirectoryAsync(null, directoryName, null, null);
        changeDirectoryResult.endAsync();
        this.masterContext.setRemoteDirectory(changeDirectoryResult.getRemoteDirectory());
    }

    @Override
    public void changeToParentDirectory() throws FTPException, IOException {
        ChangeDirectoryResult changeDirectoryResult = this.asyncImpl.changeToParentDirectoryAsync(null, null, null);
        changeDirectoryResult.endAsync();
        this.masterContext.setRemoteDirectory(changeDirectoryResult.getRemoteDirectory());
    }

    @Override
    public void createDirectory(String directoryName) throws FTPException, IOException {
        this.asyncImpl.createDirectoryAsync(null, directoryName, null, null).endAsync();
    }

    @Override
    public void deleteDirectory(String directoryName) throws FTPException, IOException {
        this.asyncImpl.deleteDirectoryAsync(null, directoryName, null, null).endAsync();
    }

    public void deleteDirectory(String directoryName, boolean recursive) throws FTPException, IOException {
        this.asyncImpl.deleteDirectoryAsync(null, directoryName, recursive, null, null).endAsync();
    }

    public void uploadMultiple(String localDir, FileFilter filter) throws FTPException, IOException {
        this.asyncImpl.uploadMultipleAsync(null, localDir, filter, null, null).endAsync();
    }

    public void uploadMultiple(String localDir, String wildcard) throws FTPException, IOException {
        this.asyncImpl.uploadMultipleAsync(null, localDir, wildcard, null, null).endAsync();
    }

    public void uploadMultiple(String localDir, String remoteDir, String wildcard, boolean recursive) throws FTPException, IOException {
        this.asyncImpl.uploadMultipleAsync(null, localDir, remoteDir, wildcard, recursive, null, null).endAsync();
    }

    public void uploadMultiple(String localDir, String remoteDir, FileFilter filter, boolean recursive) throws FTPException, IOException {
        this.asyncImpl.uploadMultipleAsync(null, localDir, remoteDir, filter, recursive, null, null).endAsync();
    }

    public void downloadMultiple(String localDir, FileFilter filter) throws FTPException, IOException {
        this.asyncImpl.downloadMultipleAsync(null, localDir, filter, null, null).endAsync();
    }

    public void downloadMultiple(String localDir, String wildcard) throws FTPException, IOException {
        this.asyncImpl.downloadMultipleAsync(null, localDir, wildcard, null, null).endAsync();
    }

    public void downloadMultiple(String localDir, String remoteDir, String wildcard, boolean recursive) throws FTPException, IOException {
        this.asyncImpl.downloadMultipleAsync(null, localDir, remoteDir, wildcard, recursive, null, null).endAsync();
    }

    public void downloadMultiple(String localDir, String remoteDir, FileFilter filter, boolean recursive) throws FTPException, IOException {
        this.asyncImpl.downloadMultipleAsync(null, localDir, remoteDir, filter, recursive, null, null).endAsync();
    }

    @Override
    public void disconnect() throws FTPException, IOException {
        this.asyncImpl.disconnectAsync(null, false, null, null).endAsync();
    }

    @Override
    public void disconnect(boolean immediate) throws FTPException, IOException {
        this.asyncImpl.disconnectAsync(null, immediate, null, null).endAsync();
    }

    public void addErrorListener(ErrorListener listener) {
        this.asyncImpl.addErrorListener(listener);
    }

    protected void shutdown(boolean immediate) {
        this.asyncImpl.shutdown(immediate);
    }

    public void finalize() {
        this.shutdown(true);
    }

    @Override
    public void cancelAllTransfers() {
        this.asyncImpl.cancelAllTransfers();
    }
}

