/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.async.internal;

import com.enterprisedt.net.ftp.FTPClientInterface;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.async.AsyncCallback;
import com.enterprisedt.net.ftp.async.ConnectResult;
import com.enterprisedt.net.ftp.async.internal.FTPConnection;
import com.enterprisedt.net.ftp.async.internal.FTPTaskProcessor;
import com.enterprisedt.net.ftp.async.internal.SecureConnectionContext;
import com.enterprisedt.net.ftp.async.internal.Task;
import com.enterprisedt.net.ftp.async.internal.TaskState;
import com.enterprisedt.net.ftp.async.internal.TaskType;
import com.enterprisedt.net.ftp.async.internal.a;
import com.enterprisedt.net.ftp.pro.ProFTPClientInterface;
import com.enterprisedt.util.debug.Logger;
import com.enterprisedt.util.proxy.ProxySettings;
import java.io.IOException;

public abstract class ConnectTask
extends Task {
    private static Logger a = Logger.getLogger("ConnectTask");
    protected AsyncCallback.Connect callback;
    protected ConnectResult result;

    public ConnectTask(FTPTaskProcessor taskProcessor, ConnectResult result, AsyncCallback.Connect callback) {
        super(taskProcessor, TaskType.a, result);
        this.result = result;
        this.callback = callback;
    }

    @Override
    public String toString() {
        return this.getId() + ":" + this.getTaskType().getName() + "[" + this.getContext().getRemoteHost() + ":" + this.getContext().getRemotePort() + "]";
    }

    protected void connect(FTPClientInterface ftp) throws IOException, FTPException {
        this.preConnectConfigure(ftp, this.getContext());
        ftp.connect();
        this.login(ftp, this.getContext());
        this.postConnectConfigure(ftp, this.getContext());
    }

    protected abstract void login(FTPClientInterface var1, SecureConnectionContext var2) throws IOException, FTPException;

    protected void preConnectConfigure(FTPClientInterface ftpClient, SecureConnectionContext context) throws IOException, FTPException {
        ftpClient.setRemoteHost(context.getRemoteHost());
        if (context.getRemotePort() > 0) {
            ftpClient.setRemotePort(context.getRemotePort());
        }
        ftpClient.setTimeout(context.getTimeout());
        ftpClient.setNetworkBufferSize(context.getNetworkBufferSize());
        ftpClient.setDetectTransferMode(context.getDetectContentType());
        ftpClient.setFileLockingEnabled(context.getFileLockingEnabled());
        ftpClient.setControlEncoding(context.getControlEncoding());
        ((ProFTPClientInterface)ftpClient).setMaxTransferRate(context.getMaxTransferRate());
        this.a(context, ((ProFTPClientInterface)ftpClient).getProxySettings());
    }

    private void a(SecureConnectionContext secureConnectionContext, ProxySettings proxySettings) {
        proxySettings.setProxyType(secureConnectionContext.getProxySettings().getProxyType());
        proxySettings.setProxyAddress(secureConnectionContext.getProxySettings().getProxyAddress());
        proxySettings.setProxyPort(secureConnectionContext.getProxySettings().getProxyPort());
        proxySettings.setProxyUserName(secureConnectionContext.getProxySettings().getProxyUserName());
        proxySettings.setProxyPassword(secureConnectionContext.getProxySettings().getProxyPassword());
        proxySettings.setPublicProxyAddress(secureConnectionContext.getProxySettings().getPublicProxyAddress());
    }

    protected void postConnectConfigure(FTPClientInterface ftpClient, SecureConnectionContext context) throws IOException, FTPException {
        ftpClient.setType(context.getContentType());
    }

    @Override
    public void setFailed(Throwable t2) {
        super.setFailed(t2);
        this.result.setLocalContext(this.getContext());
        if (this.callback != null) {
            try {
                this.callback.onConnect(this.result);
            }
            catch (Throwable throwable) {
                this.taskProcessor.a(this.result, throwable);
            }
        }
        this.result.setLocalContext(null);
    }

    @Override
    public void run(FTPConnection conn) {
        this.setState(TaskState.RUNNING_STATE);
        ProFTPClientInterface proFTPClientInterface = conn.getClient();
        try {
            this.connect(proFTPClientInterface);
            conn.setLastUsedTime(System.currentTimeMillis());
            String string = this.taskProcessor.getMasterContext().getInitialRemoteDirectory();
            if (string != null) {
                proFTPClientInterface.chdir(string);
            }
            String string2 = proFTPClientInterface.pwd();
            conn.getContext().setRemoteDirectory(string2);
            this.getContext().setRemoteDirectory(string2);
            this.result.setCurrentDir(string2);
            this.setState(TaskState.COMPLETED_SUCCESS_STATE);
            this.result.setSuccessful(true);
        }
        catch (Throwable throwable) {
            a.error(this.toString() + " failed", throwable);
            this.result.setThrowable(throwable);
            this.setState(TaskState.COMPLETED_FAILURE_STATE);
        }
        this.result.notifyComplete();
        this.result.setLocalContext(this.getContext());
        if (this.callback != null) {
            try {
                this.callback.onConnect(this.result);
            }
            catch (Throwable throwable) {
                this.taskProcessor.a(this.result, throwable);
            }
        }
        this.result.setLocalContext(null);
        try {
            if (!this.result.endAsyncCalled()) {
                this.result.endAsync();
            }
        }
        catch (Throwable throwable) {
            this.taskProcessor.a(this.result, throwable);
        }
        if (this.result.getThrowable() != null) {
            throw new a(this.result.getThrowable().getMessage());
        }
    }
}

