/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.async.internal;

import com.enterprisedt.net.ftp.FTPClientInterface;
import com.enterprisedt.net.ftp.async.AsyncCallback;
import com.enterprisedt.net.ftp.async.DirectoryNameListResult;
import com.enterprisedt.net.ftp.async.internal.FTPConnection;
import com.enterprisedt.net.ftp.async.internal.FTPTaskProcessor;
import com.enterprisedt.net.ftp.async.internal.Task;
import com.enterprisedt.net.ftp.async.internal.TaskState;
import com.enterprisedt.net.ftp.async.internal.TaskType;
import com.enterprisedt.util.debug.Logger;

public class DirectoryNameListTask
extends Task {
    private static Logger a = Logger.getLogger("DirectoryNameListTask");
    private AsyncCallback.DirectoryNameList b;
    private DirectoryNameListResult c;
    private FTPClientInterface d;

    public DirectoryNameListTask(FTPTaskProcessor taskProcessor, DirectoryNameListResult result, AsyncCallback.DirectoryNameList callback) {
        super(taskProcessor, TaskType.f, result);
        this.c = result;
        this.b = callback;
    }

    @Override
    public String toString() {
        return this.getId() + ":" + this.getTaskType().getName() + "[" + this.c.getRemoteDirectory() + "]";
    }

    @Override
    public void run(FTPConnection conn) {
        this.setState(TaskState.RUNNING_STATE);
        try {
            this.configureConnection(conn);
            if (!this.getState().equals(TaskState.RUNNING_STATE)) {
                a.debug("Task cancelled [" + this.toString() + "]");
            } else {
                this.d = conn.getClient();
                String[] stringArray = this.d.dir(this.c.getRemoteDirectory(), this.c.isLongListing());
                this.c.setListing(stringArray);
                this.c.setRemoteDirectory(this.d.pwd());
                this.c.setSuccessful(true);
                this.setState(TaskState.COMPLETED_SUCCESS_STATE);
                conn.setLastUsedTime(System.currentTimeMillis());
            }
        }
        catch (Throwable throwable) {
            a.error(this.toString() + " failed", throwable);
            this.c.setThrowable(throwable);
            this.setState(TaskState.COMPLETED_FAILURE_STATE);
        }
        this.c.notifyComplete();
        this.c.setLocalContext(this.getContext());
        if (this.b != null) {
            try {
                this.b.onDirectoryListed(this.c);
            }
            catch (Throwable throwable) {
                this.taskProcessor.a(this.c, throwable);
            }
        }
        this.c.setLocalContext(null);
        try {
            if (!this.c.endAsyncCalled()) {
                this.c.endAsync();
            }
        }
        catch (Throwable throwable) {
            this.taskProcessor.a(this.c, throwable);
        }
    }

    @Override
    public synchronized boolean cancel() {
        TaskState taskState = this.getState();
        if (taskState.equals(TaskState.PENDING_STATE)) {
            this.setState(TaskState.DISCARDED_STATE);
            return true;
        }
        if (taskState.equals(TaskState.RUNNING_STATE)) {
            this.setState(TaskState.INTERRUPTED_STATE);
            if (this.d != null) {
                a.debug("Interrupting transfer");
                this.d.cancelTransfer();
            }
            return false;
        }
        return false;
    }
}

