/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.async.internal;

import com.enterprisedt.net.ftp.async.AsyncCallback;
import com.enterprisedt.net.ftp.async.ExecuteCommandResult;
import com.enterprisedt.net.ftp.async.internal.FTPConnection;
import com.enterprisedt.net.ftp.async.internal.FTPTaskProcessor;
import com.enterprisedt.net.ftp.async.internal.Task;
import com.enterprisedt.net.ftp.async.internal.TaskState;
import com.enterprisedt.net.ftp.async.internal.TaskType;
import com.enterprisedt.util.debug.Logger;

public class ExecuteCommandTask
extends Task {
    private static Logger a = Logger.getLogger("ExecuteCommandTask");
    private ExecuteCommandResult b;
    private AsyncCallback.ExecuteCommand c;

    public ExecuteCommandTask(FTPTaskProcessor taskProcessor, ExecuteCommandResult result, AsyncCallback.ExecuteCommand callback) {
        super(taskProcessor, TaskType.m, result);
        this.b = result;
        this.c = callback;
    }

    @Override
    public void run(FTPConnection conn) {
        this.setState(TaskState.RUNNING_STATE);
        try {
            this.configureConnection(conn);
            if (!this.getState().equals(TaskState.RUNNING_STATE)) {
                a.debug("Task cancelled [" + this.toString() + "]");
            } else {
                String string = conn.getClient().executeCommand(this.b.getCommand());
                this.b.setResult(string);
                this.b.setSuccessful(true);
                this.setState(TaskState.COMPLETED_SUCCESS_STATE);
                conn.setLastUsedTime(System.currentTimeMillis());
            }
        }
        catch (Throwable throwable) {
            a.error(this.toString() + " failed", throwable);
            this.b.setThrowable(throwable);
            this.setState(TaskState.COMPLETED_FAILURE_STATE);
        }
        this.b.notifyComplete();
        this.b.setLocalContext(this.getContext());
        if (this.c != null) {
            try {
                this.c.onCommandExecuted(this.b);
            }
            catch (Throwable throwable) {
                this.taskProcessor.a(this.b, throwable);
            }
        }
        this.b.setLocalContext(null);
        try {
            if (!this.b.endAsyncCalled()) {
                this.b.endAsync();
            }
        }
        catch (Throwable throwable) {
            this.taskProcessor.a(this.b, throwable);
        }
    }

    @Override
    public boolean cancel() {
        TaskState taskState = this.getState();
        if (taskState.equals(TaskState.PENDING_STATE)) {
            this.setState(TaskState.DISCARDED_STATE);
            return true;
        }
        if (taskState.equals(TaskState.RUNNING_STATE)) {
            return false;
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getId() + ":" + this.getTaskType().getName() + "[" + this.b.getCommand() + "]";
    }
}

