/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.ftp.ssl;

import com.enterprisedt.BaseIOException;
import com.enterprisedt.net.ftp.FTPControlSocket;
import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.ftp.FTPMessageListener;
import com.enterprisedt.net.ftp.FTPReply;
import com.enterprisedt.net.ftp.internal.FTPDataSocket;
import com.enterprisedt.net.ftp.internal.FTPPassiveDataSocket;
import com.enterprisedt.net.ftp.pro.ProFTPActiveDataSocket;
import com.enterprisedt.net.ftp.ssl.SSLFTPCertificateException;
import com.enterprisedt.net.ftp.ssl.SSLFTPException;
import com.enterprisedt.net.ftp.ssl.SSLFTPValidator;
import com.enterprisedt.net.ftp.ssl.SSLProxyServerSocket;
import com.enterprisedt.net.ftp.ssl.a;
import com.enterprisedt.net.ftp.ssl.b;
import com.enterprisedt.net.puretls.SSLContext;
import com.enterprisedt.net.puretls.SSLException;
import com.enterprisedt.net.puretls.SSLSocket;
import com.enterprisedt.net.puretls.cert.CertificateVerifyException;
import com.enterprisedt.util.debug.Logger;
import com.enterprisedt.util.proxy.ProxyServerSocket;
import com.enterprisedt.util.proxy.ProxySettings;
import com.enterprisedt.util.proxy.ProxyType;
import com.enterprisedt.util.proxy.StreamSocket;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.Vector;

public class SSLFTPControlSocket
extends FTPControlSocket {
    private ProxySettings a;
    private boolean b = false;
    private boolean c = false;
    private SSLContext d;
    private boolean e = true;
    private boolean f = true;
    private int g;
    private boolean h = false;
    private Vector i = new Vector();
    public static final int IMPLICIT_FTPS_CONTROL_PORT = 990;
    private static Logger j = Logger.getLogger("SSLFTPControlSocket");

    SSLFTPControlSocket(ProxySettings proxySettings, SSLContext sslContext, StreamSocket sock, InetAddress remoteAddr, int controlPort, int timeout, boolean implicitFTPS, int configFlags, SSLFTPValidator validator, String encoding, FTPMessageListener messageListener) throws IOException, FTPException {
        super(remoteAddr, sock, timeout, encoding, messageListener);
        boolean bl;
        this.a = proxySettings;
        this.d = sslContext;
        this.h = implicitFTPS;
        this.g = configFlags;
        this.e = (configFlags & 1) == 0;
        j.debug("DISABLE_CONTROL_SSL_CLOSURE=" + !this.e);
        this.f = (configFlags & 4) == 0;
        j.debug("DISABLE_CONTROL_WAIT_ON_CLOSE=" + !this.f);
        boolean bl2 = (configFlags & 0x40) != 0;
        sslContext.getPolicy().getCertVerifyPolicy().allowBasicConstraintsInNonCA(bl2);
        j.debug("ALLOW_BASIC_CONSTRAINTS_IN_NON_CA=" + bl2);
        boolean bl3 = bl = (configFlags & 0x80) != 0;
        if (bl) {
            sslContext.getPolicy().setSessonLifetime(0);
        }
        if (implicitFTPS) {
            this.c = true;
            this.b = true;
            j.debug("SSL handshake completed on control channel");
        }
        sslContext.getPolicy().handshakeOnConnect(false);
    }

    @Override
    protected boolean usingProxy() {
        return this.a != null && !this.a.getProxyType().equals(ProxyType.NO_PROXY);
    }

    @Override
    public boolean isSecureMode() {
        return this.controlSock != null ? this.controlSock.isSecureMode() : false;
    }

    void c() throws IOException, SSLFTPException {
        SSLSocket sSLSocket = (SSLSocket)this.controlSock;
        try {
            j.debug("Starting SSL handshake on control socket");
            sSLSocket.handshake();
            if (j.isDebugEnabled()) {
                j.debug("SSL handshake on control socket complete (version = " + sSLSocket.getVersionString() + ")");
            }
        }
        catch (SSLException sSLException) {
            j.debug("Caught: " + sSLException.getClass().getName());
            Throwable throwable = sSLException;
            while (throwable != null) {
                if (throwable instanceof CertificateVerifyException) {
                    j.debug("Rethrowing as SSLFTPCertificateException");
                    CertificateVerifyException certificateVerifyException = (CertificateVerifyException)throwable;
                    throw new SSLFTPCertificateException(certificateVerifyException.getMessage(), certificateVerifyException.getCertificates());
                }
                if (!(throwable instanceof SSLException)) break;
                if ((throwable = ((BaseIOException)throwable).getInnerThrowable()) == null) continue;
                j.debug("Inner throwable = " + throwable.getClass().getName());
            }
            j.debug("Caught: " + sSLException.getClass().getName());
            throw sSLException;
        }
        this.initStreams();
        this.b = true;
    }

    @Override
    public void logout() throws IOException {
        if (this.b) {
            SSLSocket sSLSocket = (SSLSocket)this.controlSock;
            if (this.e) {
                j.debug("Sending SSL closure alert on control socket");
                sSLSocket.sendClose();
                if (this.f) {
                    j.debug("Waiting for SSL closure response on control socket");
                    try {
                        sSLSocket.waitForClose(false);
                    }
                    catch (IOException iOException) {
                        j.warn("Error while awaiting closure confirmation: " + iOException.getMessage());
                    }
                }
            }
            j.debug("Closing socket on control socket");
            sSLSocket.hardClose();
        } else {
            this.controlSock.close();
        }
    }

    public void shutdownSSL() throws IOException, FTPException {
        if (this.b) {
            SSLSocket sSLSocket = (SSLSocket)this.controlSock;
            if (this.e) {
                j.debug("Sending SSL closure alert on control socket");
                sSLSocket.sendClose();
                if (this.f) {
                    j.debug("Waiting for SSL closure response on control socket");
                    try {
                        sSLSocket.waitForClose(false);
                    }
                    catch (IOException iOException) {
                        j.error("Error while awaiting closure confirmation", iOException);
                    }
                }
            } else {
                sSLSocket.unsecure();
            }
        } else {
            throw new FTPException("Cannot shut down SSL connection as it's not currently in SSL mode.");
        }
        this.initStreams();
        this.b = false;
    }

    Vector d() {
        return this.i;
    }

    @Override
    protected void setDataPort(InetAddress host, int portNo) throws IOException, FTPException {
        if (!this.isIPV6(this.controlSock.getInetAddress())) {
            super.setDataPort(host, portNo);
        } else {
            String string = host.getHostAddress();
            if (!this.isIPV6(host)) {
                string = "::" + string;
            }
            if (this.forcedActiveIP != null) {
                j.info("Forcing use of fixed IP for EPRT command");
                string = this.forcedActiveIP;
            }
            String string2 = new StringBuffer("EPRT |2|").append(string).append("|").append(portNo).append("|").toString();
            FTPReply fTPReply = this.sendCommand(string2);
            this.validateReply(fTPReply, "200");
        }
    }

    @Override
    protected FTPDataSocket createDataSocketPASV() throws IOException, FTPException {
        if (!this.isIPV6(this.controlSock.getInetAddress())) {
            return super.createDataSocketPASV();
        }
        FTPReply fTPReply = this.sendCommand("EPSV");
        this.validateReply(fTPReply, "229");
        String string = fTPReply.getReplyText();
        int n2 = string.indexOf("(|||");
        int n3 = string.indexOf("|)");
        String string2 = string.substring(n2 += "(|||".length(), n3).trim();
        int n4 = Integer.parseInt(string2);
        String string3 = this.remoteAddr.getHostAddress();
        j.debug("Creating new passive socket at (" + string3 + ":" + n4 + ")");
        return this.newPassiveDataSocket(string3, n4);
    }

    @Override
    protected FTPDataSocket newActiveDataSocket(int port) throws IOException {
        ProxyServerSocket proxyServerSocket;
        FTPDataSocket fTPDataSocket;
        Object object;
        if (this.a.getProxyType().equals(ProxyType.HTTP)) {
            throw new IOException("Cannot use active mode with HTTP proxies");
        }
        if (this.c) {
            object = new SSLProxyServerSocket(this.d, this.a);
            fTPDataSocket = new a((SSLProxyServerSocket)object, this.g);
            proxyServerSocket = object;
        } else {
            proxyServerSocket = new ProxyServerSocket(this.a);
            fTPDataSocket = new ProFTPActiveDataSocket(proxyServerSocket);
        }
        object = null;
        if (this.a.getProxyType().equals(ProxyType.NO_PROXY)) {
            object = this.listenOnAllInterfaces ? new Socket().getLocalAddress() : this.controlSock.getLocalAddress();
            proxyServerSocket.setLocalAddress(this.controlSock.getLocalAddress());
        } else {
            object = this.remoteAddr;
        }
        j.debug("ListenOnAllInterfaces=" + this.listenOnAllInterfaces);
        j.debug(this.c ? "Creating SSLFTPActiveDataSocket" : "Creating FTPActiveDataSocket");
        proxyServerSocket.setSoTimeout(this.controlSock.getSoTimeout());
        proxyServerSocket.bind(port, (InetAddress)object);
        return fTPDataSocket;
    }

    @Override
    protected FTPDataSocket newPassiveDataSocket(String remoteHost, int port) throws IOException {
        if (this.c) {
            j.debug("Creating SSLFTPPassiveDataSocket");
            return new b(remoteHost, port, this.controlSock.getSoTimeout(), this.g, this.a, this.d);
        }
        j.debug("Creating FTPPassiveDataSocket");
        return new FTPPassiveDataSocket(remoteHost, port, this.controlSock.getSoTimeout());
    }

    void c(boolean bl) {
        this.c = bl;
    }

    boolean e() {
        return this.b;
    }
}

