/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.openssh;

import com.enterprisedt.net.j2ssh.openssh.KeyInfo;
import com.enterprisedt.net.j2ssh.util.SimpleASNReader;
import com.enterprisedt.net.j2ssh.util.SimpleASNWriter;
import java.io.IOException;
import java.math.BigInteger;
import java.security.spec.DSAPrivateKeySpec;
import java.security.spec.DSAPublicKeySpec;
import java.security.spec.KeySpec;

public class DSAKeyInfo
implements KeyInfo {
    private BigInteger a;
    private BigInteger b;
    private BigInteger c;
    private BigInteger d;
    private BigInteger e;

    public DSAKeyInfo(BigInteger p2, BigInteger q2, BigInteger g2, BigInteger x2, BigInteger y2) {
        this.a = p2;
        this.b = q2;
        this.c = g2;
        this.d = x2;
        this.e = y2;
    }

    public BigInteger getG() {
        return this.c;
    }

    public BigInteger getP() {
        return this.a;
    }

    public BigInteger getQ() {
        return this.b;
    }

    public BigInteger getX() {
        return this.d;
    }

    public BigInteger getY() {
        return this.e;
    }

    @Override
    public KeySpec getPrivateKeySpec() {
        return new DSAPrivateKeySpec(this.d, this.a, this.b, this.c);
    }

    @Override
    public KeySpec getPublicKeySpec() {
        return new DSAPublicKeySpec(this.e, this.a, this.b, this.c);
    }

    public static DSAKeyInfo getDSAKeyInfo(SimpleASNReader asn) throws IOException {
        asn.assertByte(48);
        asn.getLength();
        asn.assertByte(2);
        asn.getData();
        asn.assertByte(2);
        byte[] byArray = asn.getData();
        asn.assertByte(2);
        byte[] byArray2 = asn.getData();
        asn.assertByte(2);
        byte[] byArray3 = asn.getData();
        asn.assertByte(2);
        byte[] byArray4 = asn.getData();
        asn.assertByte(2);
        byte[] byArray5 = asn.getData();
        return new DSAKeyInfo(new BigInteger(byArray), new BigInteger(byArray2), new BigInteger(byArray3), new BigInteger(byArray5), new BigInteger(byArray4));
    }

    public static void writeDSAKeyInfo(SimpleASNWriter asn, DSAKeyInfo keyInfo) {
        SimpleASNWriter simpleASNWriter = new SimpleASNWriter();
        simpleASNWriter.writeByte(2);
        byte[] byArray = new byte[1];
        simpleASNWriter.writeData(byArray);
        simpleASNWriter.writeByte(2);
        simpleASNWriter.writeData(keyInfo.getP().toByteArray());
        simpleASNWriter.writeByte(2);
        simpleASNWriter.writeData(keyInfo.getQ().toByteArray());
        simpleASNWriter.writeByte(2);
        simpleASNWriter.writeData(keyInfo.getG().toByteArray());
        simpleASNWriter.writeByte(2);
        simpleASNWriter.writeData(keyInfo.getY().toByteArray());
        simpleASNWriter.writeByte(2);
        simpleASNWriter.writeData(keyInfo.getX().toByteArray());
        byte[] byArray2 = simpleASNWriter.toByteArray();
        asn.writeByte(48);
        asn.writeData(byArray2);
    }
}

