/*
 * Decompiled with CFR 0.152.
 */
package com.enterprisedt.net.j2ssh.sftp;

import com.enterprisedt.net.ftp.FTPException;
import com.enterprisedt.net.j2ssh.io.UnsignedInteger32;
import com.enterprisedt.net.j2ssh.io.UnsignedInteger64;
import com.enterprisedt.net.j2ssh.sftp.SftpFile;
import com.enterprisedt.util.debug.Logger;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;

public class SftpFileOutputStream
extends OutputStream {
    private static Logger a = Logger.getLogger("SftpFileOutputStream");
    private SftpFile b;
    private UnsignedInteger64 c = new UnsignedInteger64("0");
    private List d = new ArrayList();
    private boolean e = true;
    private boolean f = true;

    public SftpFileOutputStream(boolean parallelWriteMode, SftpFile file) throws IOException {
        if (file.getHandle() == null) {
            throw new IOException("The file does not have a valid handle!");
        }
        if (file.getSFTPSubsystem() == null) {
            throw new IOException("The file is not attached to an SFTP subsystem!");
        }
        this.e = parallelWriteMode;
        a.debug("Parallel write mode = " + parallelWriteMode);
        this.b = file;
    }

    public SftpFileOutputStream(boolean parallelWriteMode, SftpFile file, boolean append) throws IOException {
        this(parallelWriteMode, file);
        if (append) {
            this.c = file.getAttributes().getSize();
        }
    }

    @Override
    public void write(byte[] buffer, int offset, int len) throws IOException {
        int n2 = 0;
        int n3 = (int)Math.min(this.b.getSFTPSubsystem().getLocalPacketSize(), this.b.getSFTPSubsystem().getRemotePacketSize());
        a.debug("Writing buffer of size " + buffer.length + " (max packet size=" + n3 + ")");
        while (n2 < len) {
            long l2;
            long l3 = l2 = this.b.getSFTPSubsystem().availableRemoteWindowSpace() < (long)n3 ? (long)((int)this.b.getSFTPSubsystem().availableRemoteWindowSpace()) : (long)n3;
            if ((l2 -= 50L) <= 0L) {
                this.b.getSFTPSubsystem().waitForRemoteWindowSpace(50);
                continue;
            }
            int n4 = (int)(l2 < (long)(len - n2) ? l2 : (long)(len - n2));
            if (this.e) {
                UnsignedInteger32 unsignedInteger32 = this.b.getSFTPSubsystem().writeFileAsync(this.b.getHandle(), this.c, buffer, offset + n2, n4);
                this.a();
                this.d.add(unsignedInteger32);
            } else {
                this.b.getSFTPSubsystem().writeFile(this.b.getHandle(), this.c, buffer, offset + n2, n4);
            }
            this.c = UnsignedInteger64.add(this.c, n4);
            n2 += n4;
        }
    }

    private void a() throws IOException {
        ArrayList<UnsignedInteger32> arrayList = new ArrayList<UnsignedInteger32>();
        for (UnsignedInteger32 unsignedInteger32 : this.d) {
            if (this.b.getSFTPSubsystem().getOKRequestStatusAsync(unsignedInteger32)) continue;
            arrayList.add(unsignedInteger32);
        }
        this.d.clear();
        this.d = arrayList;
    }

    private void b() throws IOException {
        for (UnsignedInteger32 unsignedInteger32 : this.d) {
            try {
                this.b.getSFTPSubsystem().getOKRequestStatus(unsignedInteger32);
            }
            catch (FTPException fTPException) {
                throw new IOException(fTPException.getMessage());
            }
        }
        this.d.clear();
    }

    @Override
    public void write(int b2) throws IOException {
        byte[] byArray = new byte[]{(byte)b2};
        this.b.getSFTPSubsystem().writeFile(this.b.getHandle(), this.c, byArray, 0, 1);
        this.c = UnsignedInteger64.add(this.c, 1);
    }

    @Override
    public void close() throws IOException {
        if (this.e) {
            this.a();
            this.b();
        }
        this.b.close();
        this.b = null;
    }

    protected void finalize() throws IOException {
        if (this.b.getHandle() != null) {
            this.close();
        }
    }
}

